package org.eaglei.repository.servlet;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import javax.servlet.ServletContextListener;
import javax.servlet.ServletContextEvent;

import org.eaglei.repository.DataRepository;

/**
 * Manage application-wide state by responding to Web Application
 * lifecycle events.  Keep one live Sesame repository object in
 * the Servlet Context.  It *must* be closed when container shuts down.
 *
 * Important configuration variables:
 *  - Sesame repository object (not the connection, it makes connections)
 *  - Default namespace
 *  - Title (in configuration)
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class RepositoryContextListener implements ServletContextListener
{
    private static Logger log = LogManager.getLogger(RepositoryContextListener.class);

    /**
     * {@inheritDoc}
     *
     * Web app initialization hook from servlet container.
     */
    public void contextInitialized(ServletContextEvent sce)
    {
        try {
            DataRepository.initialize(sce.getServletContext());
        } catch (Exception e) {
            log.error("Got exception in Webapp context initialization, EXPECT NOTHING WILL WORK:", e);
        }
    }

    /**
     * {@inheritDoc}
     *
     * Web app destruction hook from servlet container.
     */
    public void contextDestroyed(ServletContextEvent sce)
    {
        DataRepository dr = DataRepository.getInstance();
        if (dr == null)
            log.error("Data Repository was not successfully initialized, cannot destroy!");
        else {
            try {
                dr.destroy(sce.getServletContext());
            } catch (Exception e) {
                log.error("Got exception in Webapp context finalization, but forging ahead:", e);
            }
        }
    }
}
