/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.Formats;
import org.eaglei.repository.User;
import org.eaglei.repository.View;
import org.eaglei.repository.admin.AuthUser;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class ImportExport
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(ImportExport.class);
    private static final URI EXPORT_AUTH_PASSWORD = new URIImpl("http://eagle-i.org/ont/repo/1.0/exportAuthPassword");
    private static final URI EXPORT_AUTH_TYPE = new URIImpl("http://eagle-i.org/ont/repo/1.0/exportAuthType");
    private static final URI EXPORT_AUTH_TYPE_BUILTIN = new URIImpl("http://eagle-i.org/ont/repo/1.0/exportAuthType_Builtin");
    private static final String importUserGetAuthUsers = "SELECT * WHERE { \nGRAPH <" + REPO.NG_INTERNAL + "> { " + " ?authUser <" + EXPORT_AUTH_TYPE + "> <" + EXPORT_AUTH_TYPE_BUILTIN + ">; " + " <" + REPO.HAS_PRINCIPAL_NAME + "> ?username; " + " <" + EXPORT_AUTH_PASSWORD + "> ?password " + " OPTIONAL { ?authUser <" + REPO.HAS_ROLE + "> ?su " + "   FILTER(?su = <" + REPO.ROLE_SUPERUSER + ">)}}}";
    private static final String importUserGetStatements = "SELECT ?g ?s ?p ?v ?username WHERE { \nGRAPH <" + REPO.NG_USERS + "> { ?s a <" + REPO.PERSON + "> }\n" + "OPTIONAL { GRAPH <" + REPO.NG_INTERNAL + "> { " + "    ?s <" + REPO.HAS_PRINCIPAL_NAME + "> ?username}}\n" + "GRAPH ?g {?s ?p ?v \n" + "  FILTER((?g = <" + REPO.NG_INTERNAL + "> && isURI(?s) &&\n" + "         (?p = <" + REPO.HAS_ROLE + "> || ?p = <" + REPO.HAS_PRINCIPAL_NAME + ">)) ||\n" + "        (?g = <" + REPO.NG_USERS + ">))}}";
    private boolean isImport = false;
    private boolean isExport = false;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.isExport = sc.getInitParameter("export") != null;
        boolean bl = this.isImport = sc.getInitParameter("import") != null;
        if (!this.isExport && !this.isImport) {
            log.error((Object)"Servlet was initialized without either import or export mode set, THIS IS BAD.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isExport) {
            throw new HttpStatusException(501, "GET is not implemented by this service");
        }
        String rawFormat = null;
        String rawView = null;
        String rawWorkspace = null;
        String rawType = null;
        String include = null;
        String exclude = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                File tmp = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
                if (tmp == null) {
                    throw new InternalServerErrorException("Cannot find servlet context attr = \"javax.servlet.context.tempdir\"");
                }
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, tmp));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("format")) {
                        rawFormat = item.getString();
                        continue;
                    }
                    if (ifn.equals("view")) {
                        rawView = item.getString();
                        continue;
                    }
                    if (ifn.equals("workspace")) {
                        rawWorkspace = item.getString();
                        continue;
                    }
                    if (ifn.equals("type")) {
                        rawType = item.getString();
                        continue;
                    }
                    if (ifn.equals("include")) {
                        include = item.getString();
                        continue;
                    }
                    if (ifn.equals("exclude")) {
                        exclude = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request");
            }
        } else {
            rawFormat = request.getParameter("format");
            rawView = request.getParameter("view");
            rawWorkspace = request.getParameter("workspace");
            rawType = request.getParameter("type");
            include = request.getParameter("include");
            exclude = request.getParameter("exclude");
        }
        TypeArg type = (TypeArg)Utils.parseKeywordArg(TypeArg.class, (String)rawType, (String)"type", (boolean)true, null);
        View view = (View)Utils.parseKeywordArg(View.class, (String)rawView, (String)"view", (boolean)false, null);
        URIImpl workspace = null;
        if (rawWorkspace != null) {
            if (Utils.isValidURI((String)rawWorkspace)) {
                workspace = new URIImpl(rawWorkspace);
            } else {
                throw new BadRequestException("Workspace is not a valid URI: " + rawWorkspace);
            }
        }
        if (workspace != null && view != null) {
            throw new BadRequestException("Only one of the 'workspace' or 'view' args may be specified.");
        }
        if (workspace == null && view == null) {
            view = type == TypeArg.resource ? View.USER_RESOURCES : View.USER;
        }
        Set includes = this.parseXCludeList(include);
        Set excludes = this.parseXCludeList(exclude);
        String mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)rawFormat, (String)RDFFormat.TRIG.getDefaultMIMEType());
        RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)mimeType);
        if (format == null) {
            throw new HttpStatusException(415, "MIME type of serialized RDF is not supported: \"" + mimeType + "\"");
        }
        if (!format.supportsContexts()) {
            throw new HttpStatusException(415, "Format does not support quad (graph) encoding: " + format);
        }
        try {
            log.debug((Object)("Output serialization format = " + format));
            response.setContentType(mimeType);
            RDFWriter realOut = Rio.createWriter((RDFFormat)format, (OutputStream)response.getOutputStream());
            mergeHandler out = new mergeHandler((RDFHandler)realOut, null);
            realOut.startRDF();
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            if (type == TypeArg.user) {
                if (!Access.isSuperuser((HttpServletRequest)request)) {
                    throw new ForbiddenException("This request requires administrator privileges.");
                }
                Map authUsers = AuthUser.findAllAsMap();
                for (User u : User.findAll((HttpServletRequest)request)) {
                    URI uu = u.getURI();
                    String uus = uu.toString();
                    String un = u.getUsername();
                    AuthUser au = (AuthUser)authUsers.remove(un);
                    if (excludes.contains(un) || excludes.contains(uus)) {
                        log.debug((Object)("SKIP USER because of exclude: " + u));
                        continue;
                    }
                    if (includes.isEmpty() || includes.contains(un) || includes.contains(uus)) {
                        log.debug((Object)("EXPORT USER: " + uu));
                        rc.exportStatements((Resource)uu, null, null, false, (RDFHandler)out, new Resource[]{REPO.NG_USERS, REPO.NG_INTERNAL});
                        if (au == null) {
                            log.warn((Object)("User is NOT IN RDBMS, so no password: username=" + un));
                            continue;
                        }
                        out.handleStatement((Statement)new ContextStatementImpl((Resource)uu, EXPORT_AUTH_TYPE, (Value)EXPORT_AUTH_TYPE_BUILTIN, (Resource)REPO.NG_INTERNAL));
                        out.handleStatement((Statement)new ContextStatementImpl((Resource)uu, EXPORT_AUTH_PASSWORD, (Value)new LiteralImpl(au.getPassword(), XMLSchema.STRING), (Resource)REPO.NG_INTERNAL));
                        continue;
                    }
                    log.debug((Object)("SKIP USER because of include: " + u));
                }
                for (AuthUser au : authUsers.values()) {
                    BNode subject = vf.createBNode();
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, EXPORT_AUTH_TYPE, (Value)EXPORT_AUTH_TYPE_BUILTIN, (Resource)REPO.NG_INTERNAL));
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, REPO.HAS_PRINCIPAL_NAME, (Value)new LiteralImpl(au.getUsername(), XMLSchema.STRING), (Resource)REPO.NG_INTERNAL));
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, EXPORT_AUTH_PASSWORD, (Value)new LiteralImpl(au.getPassword(), XMLSchema.STRING), (Resource)REPO.NG_INTERNAL));
                }
            } else {
                throw new HttpStatusException(501, "Resource export not implemented yet.");
            }
            realOut.endRDF();
        }
        catch (NamingException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (SQLException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block38: {
            if (this.isExport) {
                this.doGet(request, response);
                return;
            }
            if (!this.isImport) {
                throw new HttpStatusException(501, "Servlet must be configured for import or export.");
            }
            String rawFormat = null;
            String rawDuplicate = null;
            String rawTransform = null;
            String rawNewGraph = null;
            String rawType = null;
            String include = null;
            String exclude = null;
            String contentType = null;
            Reader content = null;
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                try {
                    ServletFileUpload upload = new ServletFileUpload();
                    File tmp = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
                    if (tmp == null) {
                        throw new InternalServerErrorException("Cannot find servlet context attr = \"javax.servlet.context.tempdir\"");
                    }
                    upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, tmp));
                    for (DiskFileItem item : upload.parseRequest(request)) {
                        String ifn = item.getFieldName();
                        if (ifn.equals("format")) {
                            rawFormat = item.getString();
                            continue;
                        }
                        if (ifn.equals("duplicate")) {
                            rawDuplicate = item.getString();
                            continue;
                        }
                        if (ifn.equals("transform")) {
                            rawTransform = item.getString();
                            continue;
                        }
                        if (ifn.equals("newgraph")) {
                            rawNewGraph = item.getString();
                            continue;
                        }
                        if (ifn.equals("type")) {
                            rawType = item.getString();
                            continue;
                        }
                        if (ifn.equals("include")) {
                            include = item.getString();
                            continue;
                        }
                        if (ifn.equals("exclude")) {
                            exclude = item.getString();
                            continue;
                        }
                        if (ifn.equals("content")) {
                            content = new InputStreamReader(item.getInputStream());
                            contentType = item.getContentType();
                            log.debug((Object)("Got content stream, MIME type = " + contentType));
                            continue;
                        }
                        log.warn((Object)("Unrecoginized request argument: " + ifn));
                    }
                }
                catch (FileUploadException e) {
                    log.error((Object)e);
                    throw new BadRequestException("failed parsing multipart request");
                }
            } else {
                rawFormat = request.getParameter("format");
                rawDuplicate = request.getParameter("duplicate");
                rawTransform = request.getParameter("transform");
                rawNewGraph = request.getParameter("newgraph");
                rawType = request.getParameter("type");
                include = request.getParameter("include");
                exclude = request.getParameter("exclude");
                String cs = request.getParameter("content");
                if (cs != null) {
                    content = new StringReader(cs);
                }
            }
            TypeArg type = (TypeArg)Utils.parseKeywordArg(TypeArg.class, (String)rawType, (String)"type", (boolean)true, null);
            DuplicateArg duplicate = (DuplicateArg)Utils.parseKeywordArg(DuplicateArg.class, (String)rawDuplicate, (String)"duplicate", (boolean)false, (Enum)DuplicateArg.abort);
            NewGraphArg newGraph = (NewGraphArg)Utils.parseKeywordArg(NewGraphArg.class, (String)rawNewGraph, (String)"newgraph", (boolean)false, (Enum)NewGraphArg.abort);
            boolean transform = Utils.parseBooleanParameter((String)rawTransform, (String)"transform", (boolean)true, (boolean)false);
            Set includes = this.parseXCludeList(include);
            Set excludes = this.parseXCludeList(exclude);
            if (rawFormat == null) {
                rawFormat = contentType;
            }
            if (rawFormat == null) {
                throw new BadRequestException("Missing required argument: format (or content-type on input)");
            }
            RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)rawFormat);
            if (format == null) {
                throw new HttpStatusException(415, "MIME type of serialized RDF is not supported: \"" + rawFormat + "\"");
            }
            if (!format.supportsContexts()) {
                throw new HttpStatusException(415, "Format does not support quad (graph) encoding: " + format);
            }
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            log.debug((Object)("Input serialization format = " + format));
            try {
                if (type == TypeArg.user) {
                    if (!Access.isSuperuser((HttpServletRequest)request)) {
                        throw new ForbiddenException("This request requires administrator privileges.");
                    }
                    SailRepository mr = null;
                    RepositoryConnection mrc = null;
                    try {
                        mr = new SailRepository((Sail)new MemoryStore());
                        mr.initialize();
                        mrc = mr.getConnection();
                        mrc.add(content, "", format, new Resource[0]);
                        TupleQuery q = mrc.prepareTupleQuery(QueryLanguage.SPARQL, importUserGetAuthUsers);
                        log.debug((Object)("SPARQL query PASS1 against internal memory repo = " + importUserGetAuthUsers));
                        q.setDataset(User.getUserDataset());
                        q.setIncludeInferred(false);
                        Connection c = AuthUser.startTransaction();
                        authUserPass1Handler ah = new authUserPass1Handler(c, rc, transform, duplicate, includes, excludes);
                        try {
                            q.evaluate((TupleQueryResultHandler)ah);
                            q = mrc.prepareTupleQuery(QueryLanguage.SPARQL, importUserGetStatements);
                            log.debug((Object)("SPARQL query PASS2 against internal memory repo = " + importUserGetStatements));
                            q.setDataset(User.getUserDataset());
                            q.setIncludeInferred(false);
                            q.evaluate((TupleQueryResultHandler)new authUserPass2Handler(ah));
                            AuthUser.commitTransaction((Connection)c);
                            rc.commit();
                            c = null;
                            break block38;
                        }
                        finally {
                            if (c != null) {
                                AuthUser.abortTransaction((Connection)c);
                                c = null;
                            }
                        }
                    }
                    catch (handlerBadRequest e) {
                        throw new BadRequestException(e.getMessage());
                    }
                    catch (NamingException e) {
                        log.error((Object)"Failed in IMPORT USER: ", (Throwable)e);
                        throw new InternalServerErrorException((Throwable)e);
                    }
                    catch (SQLException e) {
                        log.error((Object)"Failed in IMPORT USER: ", (Throwable)e);
                        throw new InternalServerErrorException((Throwable)e);
                    }
                    finally {
                        if (mrc != null && mrc.isOpen()) {
                            mrc.rollback();
                            mrc.close();
                        }
                        if (mr != null) {
                            mr.shutDown();
                        }
                    }
                }
                throw new HttpStatusException(501, "import instances");
            }
            catch (OpenRDFException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
    }

    private Set<String> parseXCludeList(String s) {
        HashSet<String> result = new HashSet<String>();
        if (s != null) {
            for (String e : s.split("\\s+")) {
                result.add(e);
            }
        }
        return result;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

