/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.Formats;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.ForbiddenException;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class GetStatements
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(GetStatements.class);
    private static String[] columnNames = new String[]{"subject", "predicate", "object", "context"};

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mimeType;
        TupleQueryResultFormat tqf;
        String subject = request.getParameter("subject");
        String predicate = request.getParameter("predicate");
        String object = request.getParameter("object");
        String format = request.getParameter("format");
        if (!Access.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("This service is only available to administrators.");
        }
        if (format == null) {
            format = "text/html";
        }
        if ((tqf = QueryResultIO.getWriterFormatForMIMEType((String)(mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format, (String)"application/sparql-results+xml")))) == null) {
            log.error((Object)("Failed to get tuple query format, for mime=" + mimeType));
            throw new ServletException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
        }
        response.setContentType(mimeType);
        RepositoryResult rr = null;
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        try {
            TupleQueryResultWriter h = QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream());
            h.startQueryResult(Arrays.asList(columnNames));
            MapBindingSet bs = new MapBindingSet(4);
            URI su = subject == null ? null : vf.createURI(subject);
            URI pu = predicate == null ? null : vf.createURI(predicate);
            URI vu = null;
            if (object != null) {
                try {
                    vu = vf.createURI(object);
                }
                catch (Exception e) {
                    log.debug((Object)("Object was NOT a valid URI, try literal: " + object));
                    vu = vf.createLiteral(object);
                }
            }
            try {
                log.debug((Object)("Try getStatements(" + su + ", " + pu + ", " + vu + ", false)"));
                rr = rc.getStatements((Resource)su, pu, (Value)vu, false, new Resource[0]);
                while (rr.hasNext()) {
                    Statement s = (Statement)rr.next();
                    bs.clear();
                    bs.addBinding("subject", (Value)s.getSubject());
                    bs.addBinding("predicate", (Value)s.getPredicate());
                    bs.addBinding("object", s.getObject());
                    bs.addBinding("context", (Value)s.getContext());
                    h.handleSolution((BindingSet)bs);
                }
                h.endQueryResult();
            }
            finally {
                rr.close();
            }
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }
}

