/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.View;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;

public class ListGraphs
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(ListGraphs.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String format = request.getParameter("format");
        String type = request.getParameter("type");
        DatasetImpl uds = new DatasetImpl();
        View.addGraphs((HttpServletRequest)request, (DatasetImpl)uds, (View)View.USER);
        StringBuilder query = new StringBuilder();
        query.append("SELECT DISTINCT * WHERE { ?namedGraphURI a <").append(REPO.NAMED_GRAPH).append("> . \n").append(" OPTIONAL { ?namedGraphURI <").append(RDFS.LABEL).append("> ?namedGraphLabel } \n").append(" OPTIONAL { ?namedGraphURI <").append(REPO.NG_TYPE).append("> ?typeURI . ?typeURI <").append(RDFS.LABEL).append("> ?typeLabel } \n");
        if (type != null) {
            NamedGraph.Type ngt = NamedGraph.Type.parse((String)type);
            if (ngt == null) {
                throw new BadRequestException("Unrecognized graph type: " + type);
            }
            query.append(" FILTER( ?typeURI = <" + ngt.uri + "> )");
        }
        query.append(" }");
        SPARQL.tupleQueryRequest((HttpServletRequest)request, (HttpServletResponse)response, (String)query.toString(), (String)format, (Dataset)SPARQL.InternalGraphs);
    }
}

