<!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML+RDFa 1.0//EN" "http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"
      xmlns:dc="http://purl.org/dc/elements/1.1/"
      lang="en"
      xml:lang="en">
<%--
   -  Display application version for users and as RDFa
   -
   -  This sets standard DC (Dublin Core Element Set) properties
   -  although the meaning is somewhat dubious; it is valid enough
   -  to ues this interpretation within eaglei and have *some* meaning
   -  in the outside world too.  Unfortunately the DC properties were
   -  intended as library metadata so there aren't really any good choices.
   -
   -   dc:date - the build date/time
   -   dc:source - the SCM version number
   -   dc:description - the Maven package version
   -
   - $Id$
  --%>
<%@ page import="org.eaglei.repository.DataRepository" %>
<%
    String mavenVersion = DataRepository.getInstance().getProjectVersion();
    String buildTime = DataRepository.getInstance().getTimestamp();
    String scmVersion = DataRepository.getInstance().getRevision();
    String scmBranch = DataRepository.getInstance().getBranch();
    String about = request.getRequestURL().toString();
 %>
  <head about="<%= about %>">
    <meta property="dc:description" content="<%= mavenVersion %>" />
    <meta property="dc:date" content="<%= buildTime %>" />
    <meta property="dc:source" content="<%= scmVersion %>" />
    <title>Eagle-I Repository Version</title>
  </head>
  <body about="<%= about %>">
    <h1>Eagle-i Data Repository Version Information</h1>
    <dl>
      <dt>Maven package version</dt>
      <dd><tt property="dc:description"><%= mavenVersion %></tt></dd>
      <dt>Build time</dt>
      <dd><tt property="dc:date"><%= buildTime %></tt></dd>
      <dt>SCM Branch</dt>
      <dd><tt property="dc:source"><%= scmBranch == null ? "trunk" : scmBranch %></tt></dd>
      <dt>SCM revision</dt>
      <dd><tt property="dc:source"><%= scmVersion %></tt></dd>
    </dl>
  </body>
</html>
