package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.model.ValueFactory;
import org.eaglei.repository.Access;
import org.eaglei.repository.AccessGrant;
import org.eaglei.repository.User;
import org.eaglei.repository.vocabulary.REPO;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.DataRepository;

public final class editGrants_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

 private static Logger log = LogManager.getLogger("org.eaglei.repository.admin.namedGraphs.jsp"); 
  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
      out.write("\n\n  <head>\n    <title>Eagle-I Data Repository Admin - Edit Access Control List</title>\n  </head>\n");

    try {

      out.write("\n  <body>\n");

    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = false;

    // sanity-check args
    String rawuri = request.getParameter("uri");
    if (rawuri == null) {
        response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'uri'");
        return;
    }
    RepositoryConnection rc = WithRepositoryConnection.get(request);
    ValueFactory vf = rc.getValueFactory();
    URI uri = null;
    try {
        uri = vf.createURI(rawuri);
    } catch (IllegalArgumentException e) {
        response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Illegal URI: "+e);
        return;
    }
    String type = request.getParameter("type");
    if (type == null)
        type = "Unknown-type";

    // if action given, try to do the add or remove..
    // sanity check args first:
    String action = request.getParameter("action");
    String access = request.getParameter("access");
    String agents[] = request.getParameterValues("agent");
    if (action != null) {
        String agent = null;
        for (String a : agents) {
            if (a.length() > 0) {
                if (agent != null) {
                    response.sendError(HttpServletResponse.SC_BAD_REQUEST,
                      "There may not be more than one value for agent: "+agent+", and: "+a);
                    return;
                } else
                    agent = a;
            }
        }
        if (agent == null || agent.length() == 0 || access == null || access.length() == 0) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST,  "Request is missing one of the required arguments, 'agent' or 'access'.");
            return;
        }
        try {
            URI agentURI = vf.createURI(agent);
            URI accessURI = vf.createURI(access);
            if (action.equals("add")) {
                Access.addGrant(request, uri, agentURI, accessURI);
                messageSuccess = true;
                message = "New grant has been added.";
            } else if (action.equals("remove")) {
                messageSuccess = Access.removeGrant(request, uri, agentURI, accessURI);
                message = messageSuccess ? "Grant has been removed." : "Specified grant was not found.";
            } else {
                response.sendError(HttpServletResponse.SC_BAD_REQUEST,  "Unrecognized value of 'action': "+action);
                return;
            }
            // need to save changes to the triplestore.
            rc.commit();
        } catch (IllegalArgumentException e) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Illegal URI: "+e);
            return;
        }
    }

    // need these later
    String backLink = request.getParameter("backLink");
    if (backLink == null)
        backLink = request.getHeader("Referer");  // "sic"
    String backLabel = request.getParameter("backLabel");

      out.write("\n    ");
      out.write("\n\n\n<hr/>\n    <table border=\"0\" width=\"100%\" >\n      <tr>\n        <td width=\"30%\"><a href=\"http://www.eagle-i.org/\"><img border=\"0\" alt=\"Institutional Logo\" align=\"right\"\n               src=\"");
      out.print( DataRepository.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" /></a>\n        </td>\n        <td width=\"40%\"><div align=\"center\">\n          <font size=\"+2\" color=\"black\">\n            Repository Administration Area\n          </font>\n          <p>");
      out.print( DataRepository.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)") );
      out.write("</p>\n        </div></td>\n        <td width=\"30%\">&nbsp;</td>\n      </tr>\n    </table>\n<hr/>\n");
      out.write("\n    <h2>Edit Access to a ");
      out.print( StringEscapeUtils.escapeHtml(type) );
      out.write("</h2>\n    <h3>");
 String ulabel = request.getParameter("label");
         if (ulabel != null)
            out.write("Name: "+StringEscapeUtils.escapeHtml(ulabel)); 
      out.write("\n        <br>URI: <code>&nbsp;");
      out.print( uri.toString() );
      out.write("</code>\n    </h3>\n\n");

    if (message != null) {

      out.write("\n      <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n          ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("\n          </font>\n     </h3>\n");

    }

      out.write("\n\n   <h2>Current Access Grants:</h2>\n    <table border=\"1\">\n      <tr><th>Agent</th><th>Access Type</th><th>Delete</th></tr>\n");

    for (AccessGrant g : Access.getGrants(request, uri)) {

      out.write("\n      <tr>\n        <td>\n        ");
      out.print( StringEscapeUtils.escapeHtml(g.agent.label) );
      out.write("\n        [");
      out.print( StringEscapeUtils.escapeHtml(g.agentType.label) );
      out.write("]\n        </td>\n        <td>");
      out.print( StringEscapeUtils.escapeHtml(g.access.label) );
      out.write("</td>\n        <td>\n");
  if (g.builtin) { 
      out.write("\n          <i>Built-In</i>\n");
  } else { 
      out.write("\n          <form method=\"post\" action=\"\" style=\"margin: 0pt;\">\n");
      if (backLink != null) { 
      out.write("\n          <input type=\"hidden\" name=\"backLink\" value=\"");
      out.print( backLink );
      out.write("\"/>\n");
      } 
      out.write('\n');
  if (backLabel != null) { 
      out.write("\n          <input type=\"hidden\" name=\"backLabel\" value=\"");
      out.print( backLabel );
      out.write("\"/>\n");
      } 
      out.write("\n          <input type=\"hidden\" name=\"type\" value=\"");
      out.print( type );
      out.write("\"/>\n          <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( uri.toString() );
      out.write("\"/>\n          <input type=\"hidden\" name=\"action\" value=\"remove\"/>\n          <input type=\"hidden\" name=\"agent\" value=\"");
      out.print( g.agent.toString() );
      out.write("\"/>\n          <input type=\"hidden\" name=\"access\" value=\"");
      out.print( g.access.toString() );
      out.write("\"/>\n          <button type=\"submit\">Delete!</button>\n          </form>\n");
  } 
      out.write("\n        </td>\n      </tr>\n");

    }

      out.write("\n    </table>\n\n  <h2>Add New Access Grant:</h2>\n\n   <form method=\"post\" action=\"\">\n");
  if (backLink != null) { 
      out.write("\n    <input type=\"hidden\" name=\"backLink\" value=\"");
      out.print( backLink );
      out.write("\"/>\n");
  } 
      out.write('\n');
  if (backLabel != null) { 
      out.write("\n    <input type=\"hidden\" name=\"backLabel\" value=\"");
      out.print( backLabel );
      out.write("\"/>\n");
  } 
      out.write("\n    <input type=\"hidden\" name=\"type\" value=\"");
      out.print( type );
      out.write("\"/>\n    <input type=\"hidden\" name=\"action\" value=\"add\"/>\n    <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( uri.toString() );
      out.write("\"/>\n   <div style=\"width: 50%;\">\n    <fieldset style=\"width: 80%; align: center;\">\n     <legend><b>Choose Agent to have Access</b></legend>\n       <font size=\"-1\"><i>Select EITHER a user OR role:</i></font><br/>\n       <b>User:</b>\n       <select name=\"agent\">\n         <option value=\"\">--none--</option>\n");

    for (User u : User.findAll(request)) {

      out.write("\n            <option value=\"");
      out.print( u.getURI() );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(u.getTitle()) );
      out.write("</option>\n");

    }

      out.write("\n       </select>\n       <br>&nbsp;&nbsp;&nbsp;<b>-- or --</b>\n       <br>\n       <b>Role:</b>\n       <select name=\"agent\">\n         <option value=\"\">--none--</option>\n");

    for (AccessGrant.Term t : Access.getAllRoles(request)) {

      out.write("\n            <option value=\"");
      out.print( t.toString() );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(t.label) );
      out.write("</option>\n");

    }

      out.write("\n          </select>\n    </fieldset>\n    <p>\n\n   <b>Access Type:</b>\n         <select name=\"access\">\n           <option value=\"\">--none--</option>\n");

    for (AccessGrant.Term t : Access.getAllAccesses(request)) {

      out.write("\n           <option value=\"");
      out.print( t.toString() );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(t.label) );
      out.write("</option>\n");

    }

      out.write("\n         </select>\n    <p>\n    <div width=\"50%\" align=\"center\">\n      <button type=\"reset\">Reset Form</button>\n      &nbsp;&nbsp;&nbsp;&nbsp;\n      <button name=\"submit\" value=\"submit\" type=\"submit\">Add!</button>\n    </div>\n   </div>\n\n   </form>\n");

    if (backLink != null) {
        if (backLabel == null)
            backLabel = "Back to previous page";

      out.write("\n    <br/>\n    <br/>\n    <a href=\"");
      out.print( backLink );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(backLabel) );
      out.write("</a>\n");
      } 
      out.write("\n    <br/>\n    <br/>\n    <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n  </body>\n");

    // see "try" at start of body tag.
    // This is the idiom that much of the repo code uses to pass
    // HTTP status results back as a RuntimeException subclass..
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
