package org.eaglei.repository.servlet;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import  org.eaglei.repository.Access;

/**
 * <p>Logout class.</p>
 *
 * @author lcs
 * @version $Id: $
 */
public class Logout extends HttpServlet
{
    private static Logger log = LogManager.getLogger(Logout.class);

    /**
     * {@inheritDoc}
     *
     * Although it is incorrect HTTP and REST usage, respond to the GET
     * by logging out -- mainly because there is no way to get a browser to
     * execute a POST for a URL entered into the location bar. It's also
     * inconvenient to POST when coding links in a page but at least
     * that is possible.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        log.debug("Got logout GET request");
        doPost(request, response);
    }

    /** {@inheritDoc} */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        log.debug("Got logout POST request");
        Access.logout(request);
        response.setStatus(HttpServletResponse.SC_OK);
    }
}
