/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ConflictException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerBase;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class FakeFlow
extends TupleQueryResultHandlerBase {
    private static Logger log = LogManager.getLogger(FakeFlow.class);
    private static final URI DEFAULT_STATE = REPO.WFS_DRAFT;
    private static Set<URI> wfStates = null;
    private URI resource = null;
    private URI state = null;
    private String stateLabel = null;
    private URI owner = null;
    private String ownerLabel = null;
    private static final String fwfQuery = "SELECT * WHERE { \n?instance <" + REPO.HAS_WORKFLOW_STATE + "> ?state . \n" + "?state <" + RDFS.LABEL + "> ?stateLabel \n" + "OPTIONAL { ?instance <" + REPO.HAS_WORKFLOW_OWNER + "> ?owner . \n" + " OPTIONAL { ?owner <" + RDFS.LABEL + "> ?ownerLabel } } }";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(RepositoryConnection rc) {
        if (wfStates == null) {
            wfStates = new HashSet();
            try {
                RepositoryResult rr = null;
                try {
                    rr = rc.getStatements(null, RDF.TYPE, (Value)REPO.WORKFLOW_STATE, false, new Resource[0]);
                    while (rr.hasNext()) {
                        Resource sub = ((Statement)rr.next()).getSubject();
                        if (sub instanceof URI) {
                            wfStates.add((URI)sub);
                            continue;
                        }
                        log.warn((Object)("Got non-URI in workflow state query: " + sub));
                    }
                }
                finally {
                    rr.close();
                }
            }
            catch (RepositoryException e) {
                log.error((Object)"Failed finding Workflow State instances.");
            }
        }
    }

    private FakeFlow(URI resource) {
        this.resource = resource;
    }

    public static boolean isWorkflowState(HttpServletRequest request, URI uri) {
        return FakeFlow.isWorkflowState((RepositoryConnection)WithRepositoryConnection.get((ServletRequest)request), (URI)uri);
    }

    public static boolean isWorkflowState(RepositoryConnection rc, URI uri) {
        FakeFlow.init((RepositoryConnection)rc);
        return wfStates.contains(uri);
    }

    public static boolean isWorkflowPredicate(URI uri) {
        return REPO.HAS_WORKFLOW_STATE.equals(uri) || REPO.HAS_WORKFLOW_OWNER.equals(uri);
    }

    public static FakeFlow find(HttpServletRequest request, URI resource) {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            Dataset ds = SPARQL.getInternalAndMetadataGraphs((HttpServletRequest)request);
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, fwfQuery);
            q.setBinding("instance", (Value)resource);
            q.setDataset(ds);
            q.setIncludeInferred(false);
            FakeFlow result = new FakeFlow(resource);
            q.evaluate((TupleQueryResultHandler)result);
            if (result.state == null) {
                log.debug((Object)("NO fake workflow properties found on Resource Instance=" + resource));
                return null;
            }
            log.debug((Object)("Found fake workflow state=" + result.state + " for Resource Instance=" + resource));
            return result;
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void handleSolution(BindingSet bs) throws TupleQueryResultHandlerException {
        Value state = bs.getValue("state");
        Value stateLabel = bs.getValue("stateLabel");
        Value owner = bs.getValue("owner");
        Value ownerLabel = bs.getValue("ownerLabel");
        if (state != null && state instanceof URI) {
            this.state = (URI)state;
        } else {
            log.warn((Object)("Got strange result with no State for uri=" + this.resource));
        }
        if (stateLabel != null && stateLabel instanceof Literal) {
            this.stateLabel = ((Literal)stateLabel).getLabel();
        }
        if (owner != null && owner instanceof URI) {
            this.owner = (URI)owner;
        }
        if (ownerLabel != null && ownerLabel instanceof Literal) {
            this.ownerLabel = ((Literal)ownerLabel).getLabel();
        }
    }

    public static FakeFlow create(HttpServletRequest request, URI resource) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (rc.hasStatement((Resource)resource, REPO.HAS_WORKFLOW_STATE, null, false, new Resource[]{REPO.NG_METADATA})) {
                throw new InternalServerErrorException("This resource instance already has a workflow state: " + resource);
            }
            FakeFlow result = new FakeFlow(resource);
            result.state = DEFAULT_STATE;
            result.owner = Access.getPrincipalURI((HttpServletRequest)request);
            rc.add((Resource)resource, REPO.HAS_WORKFLOW_STATE, (Value)result.state, new Resource[]{REPO.NG_METADATA});
            rc.add((Resource)resource, REPO.HAS_WORKFLOW_OWNER, (Value)result.owner, new Resource[]{REPO.NG_METADATA});
            log.debug((Object)("Created FakeFlow entries for resource instance= " + resource + ", state=" + result.state + ", owner=" + result.owner));
            return result;
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed creating FakeFlow entry: ", (Throwable)e);
            throw new InternalServerErrorException("Failed creating FakeFlow: ", (Throwable)e);
        }
    }

    public void clear(HttpServletRequest request) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.resource, REPO.HAS_WORKFLOW_STATE, null, new Resource[]{REPO.NG_METADATA});
            rc.remove((Resource)this.resource, REPO.HAS_WORKFLOW_OWNER, null, new Resource[]{REPO.NG_METADATA});
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed clearing FakeFlow: ", (Throwable)e);
            throw new InternalServerErrorException("Failed clearing FakeFlow: ", (Throwable)e);
        }
    }

    public void promote(HttpServletRequest request, URI newState) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (!Access.isSuperuser((HttpServletRequest)request)) {
                throw new ForbiddenException("Fakeflow promotion is only permitted to Administrators.");
            }
            if (REPO.WFS_DRAFT.equals(newState)) {
                if (!REPO.WFS_CURATION.equals(this.state)) {
                    throw new ConflictException("May not make this transition from current Fakeflow state.");
                }
            } else if (REPO.WFS_CURATION.equals(newState)) {
                if (!REPO.WFS_DRAFT.equals(this.state)) {
                    throw new ConflictException("May not make this transition from current Fakeflow state.");
                }
            } else if (REPO.WFS_PUBLISHED.equals(newState)) {
                if (!REPO.WFS_CURATION.equals(this.state) && !REPO.WFS_WITHDRAWN.equals(this.state)) {
                    throw new ConflictException("May not make this transition from current Fakeflow state.");
                }
                this.moveToGraph(rc, REPO.NG_PUBLISHED);
            } else if (REPO.WFS_WITHDRAWN.equals(newState)) {
                if (!REPO.WFS_PUBLISHED.equals(this.state)) {
                    throw new ConflictException("May not make this transition from current Fakeflow state.");
                }
                this.moveToGraph(rc, REPO.NG_WITHDRAWN);
            } else {
                throw new BadRequestException("There are no transitions to the given workflow state.");
            }
            rc.remove((Resource)this.resource, REPO.HAS_WORKFLOW_STATE, null, new Resource[]{REPO.NG_METADATA});
            rc.remove((Resource)this.resource, REPO.HAS_WORKFLOW_OWNER, null, new Resource[]{REPO.NG_METADATA});
            rc.add((Resource)this.resource, REPO.HAS_WORKFLOW_STATE, (Value)newState, new Resource[]{REPO.NG_METADATA});
            new Provenance(this.resource).setModified(request, new Date());
            log.debug((Object)("Completed transition to workflow state: " + newState));
        }
        catch (RepositoryException e) {
            String msg = "Failed in promote() for resource inst=" + this.resource;
            log.error((Object)msg);
            throw new InternalServerErrorException(msg, (Throwable)e);
        }
    }

    public void claim(HttpServletRequest request, URI newOwner) {
        if (!Access.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Fakeflow claim is only permitted to Administrators.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (rc.hasStatement((Resource)this.resource, REPO.HAS_WORKFLOW_OWNER, null, false, new Resource[]{REPO.NG_METADATA})) {
                rc.remove((Resource)this.resource, REPO.HAS_WORKFLOW_OWNER, null, new Resource[]{REPO.NG_METADATA});
            }
            if (newOwner != null) {
                rc.add((Resource)this.resource, REPO.HAS_WORKFLOW_OWNER, (Value)newOwner, new Resource[]{REPO.NG_METADATA});
            }
        }
        catch (RepositoryException e) {
            String msg = "Failed in claim() for resource inst=" + this.resource;
            log.error((Object)msg);
            throw new InternalServerErrorException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToGraph(RepositoryConnection rc, URI newGraph) {
        Object homeGraph = null;
        try {
            RepositoryResult rr = null;
            try {
                rr = rc.getStatements((Resource)this.resource, RDF.TYPE, null, false, new Resource[0]);
                while (rr.hasNext()) {
                    Statement s = (Statement)rr.next();
                    Resource ctx = s.getContext();
                    log.debug((Object)("Found statement: " + this.resource + " rdf:type " + s.getObject() + ", in graph " + ctx));
                    if (ctx == null || !(ctx instanceof URI)) continue;
                    homeGraph = (URI)ctx;
                    break;
                }
            }
            finally {
                rr.close();
            }
            if (homeGraph == null) {
                log.error((Object)("Failed to find home graph for resource instance=" + this.resource));
                throw new InternalServerErrorException("Failed to find home graph for resource instance=" + this.resource);
            }
            if (homeGraph.equals(newGraph)) {
                log.warn((Object)("Tried to move resource inst=" + this.resource + " to the same named graph: " + homeGraph));
                return;
            }
            List stms = null;
            try {
                rr = rc.getStatements((Resource)this.resource, null, null, false, new Resource[]{homeGraph});
                stms = rr.asList();
            }
            finally {
                rr.close();
            }
            for (Statement s : stms) {
                rc.remove(s, new Resource[]{homeGraph});
                rc.add(s, new Resource[]{newGraph});
            }
        }
        catch (RepositoryException e) {
            String msg = "Failed moving statments for resource inst=" + this.resource + ", from=" + homeGraph + ", to=" + newGraph;
            log.error((Object)msg);
            throw new InternalServerErrorException(msg, (Throwable)e);
        }
    }

    public URI getResource() {
        return this.resource;
    }

    public URI getState() {
        return this.state;
    }

    public URI getOwner() {
        return this.owner;
    }

    public String getStateLabel() {
        return this.stateLabel == null ? this.state.getLocalName() : this.stateLabel;
    }

    public String getOwnerLabel() {
        return this.ownerLabel == null ? this.owner.getLocalName() : this.ownerLabel;
    }
}

