/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.format;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.format.SPARQLHTMLWriter;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class RDFHTMLWriter
extends RDFHandlerBase
implements RDFWriter {
    public static final String MIME = "text/html";
    private BufferedWriter out = null;
    public static final RDFFormat FORMAT = new RDFFormat("RDFHTML", "text/html", Charset.defaultCharset(), "html", false, true);

    public RDFFormat getRDFFormat() {
        return FORMAT;
    }

    public RDFHTMLWriter(Writer out) {
        this.out = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void handleStatement(Statement s) throws RDFHandlerException {
        try {
            this.out.write("<tr>");
            this.out.newLine();
            this.handleResource(s.getSubject());
            this.handleResource((Resource)s.getPredicate());
            Value so = s.getObject();
            if (so instanceof Literal) {
                this.out.write("<td><tt>");
                String ls = StringEscapeUtils.escapeHtml((String)so.toString());
                Matcher m = Pattern.compile("[\n\r]").matcher(ls);
                int lastEnd = 0;
                while (m.find()) {
                    char c;
                    int len1 = m.start() - lastEnd;
                    if (len1 > 0) {
                        this.out.write(ls, lastEnd, len1);
                    }
                    if ((c = ls.charAt(m.start())) == '\n') {
                        this.out.write("<br/>");
                        this.out.newLine();
                    }
                    lastEnd = m.end();
                }
                this.out.write(ls, lastEnd, ls.length() - lastEnd);
                this.out.write("</tt></td>");
                this.out.newLine();
            } else {
                this.handleResource((Resource)so);
            }
            this.out.write("</tr>");
            this.out.newLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void handleResource(Resource ss) throws IOException {
        this.out.write("<td><tt>");
        if (ss instanceof URI) {
            this.out.write(SPARQLHTMLWriter.renderLinkedURI((URI)((URI)ss)));
        } else {
            this.out.write(StringEscapeUtils.escapeHtml((String)("_:" + ((BNode)ss).getID())));
        }
        this.out.write("</tt></td>");
        this.out.newLine();
    }

    public void endRDF() throws RDFHandlerException {
        try {
            this.out.write("</table></div></body></html>\r\n");
            this.out.newLine();
            this.out.close();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void startRDF() throws RDFHandlerException {
        try {
            this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\"><head>  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />  <title>SPARQL Query Results</title> <link rel=\"stylesheet\" type=\"text/css\" href=\"/repository/style/sparql.css\" /></head><body><div><table>\r\n");
            this.out.newLine();
            this.out.write("<tr><th>Subject</th><th>Predicate</th><th>Object</th></tr>");
            this.out.newLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }
}

