/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.FakeFlow;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryException;

/*
 * Exception performing whole class analysis ignored.
 */
public class FakeWorkflow
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(FakeWorkflow.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String rawuri = request.getParameter("uri");
        String format = request.getParameter("format");
        if (rawuri == null) {
            throw new BadRequestException("Missing required arg 'uri'.");
        }
        if (request.getParameter("promote") != null || request.getParameter("claim") != null) {
            throw new BadRequestException("The promote and claim args require POST method.");
        }
        FakeFlow ff = FakeWorkflow.getFakeFlow((HttpServletRequest)request, (String)rawuri, (boolean)false);
        if (ff != null) {
            URI owner;
            ArrayList<MapBindingSet> results = new ArrayList<MapBindingSet>(1);
            MapBindingSet bs = new MapBindingSet(4);
            bs.addBinding("state", (Value)ff.getState());
            if (ff.getStateLabel() != null) {
                bs.addBinding("stateLabel", (Value)new LiteralImpl(ff.getStateLabel()));
            }
            if ((owner = ff.getOwner()) != null) {
                bs.addBinding("owner", (Value)owner);
                if (ff.getOwnerLabel() != null) {
                    bs.addBinding("ownerLabel", (Value)new LiteralImpl(ff.getOwnerLabel()));
                }
            }
            results.add(bs);
            SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, results);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FakeFlow ff;
        String rawuri = request.getParameter("uri");
        String promote = request.getParameter("promote");
        String claim = request.getParameter("claim");
        if (rawuri == null) {
            throw new BadRequestException("Missing required arg 'uri'.");
        }
        if (promote == null && claim == null) {
            throw new BadRequestException("Missing required arg: at least one of 'promote' or 'claim' must be specified.");
        }
        URIImpl stateURI = null;
        if (promote != null) {
            try {
                stateURI = new URIImpl(promote);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Promotion state is malformed: " + promote);
            }
        }
        URI claimURI = null;
        if (claim != null && !claim.equals("nobody")) {
            if (claim.equals("self")) {
                claimURI = Access.getPrincipalURI((HttpServletRequest)request);
            } else {
                try {
                    claimURI = new URIImpl(claim);
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException("Claim user URI is malformed: " + claim);
                }
            }
        }
        if ((ff = FakeWorkflow.getFakeFlow((HttpServletRequest)request, (String)rawuri, (boolean)false)) == null) {
            throw new BadRequestException("Resource instance has no (fake) workflow properties: " + rawuri);
        }
        boolean dirty = false;
        if (stateURI != null) {
            ff.promote(request, (URI)stateURI);
            dirty = true;
        }
        if (claim != null && claim.equals("nobody")) {
            ff.claim(request, null);
            dirty = true;
        } else if (claimURI != null) {
            ff.claim(request, claimURI);
            dirty = true;
        }
        if (dirty) {
            try {
                WithRepositoryConnection.get((ServletRequest)request).commit();
            }
            catch (RepositoryException e) {
                String msg = "Failed committing workflow changes, resource inst=" + ff.getResource();
                log.error((Object)msg);
                throw new InternalServerErrorException(msg, (Throwable)e);
            }
        }
    }

    private static FakeFlow getFakeFlow(HttpServletRequest request, String rawuri, boolean createp) {
        try {
            URIImpl uri = new URIImpl(rawuri);
            FakeFlow result = FakeFlow.find((HttpServletRequest)request, (URI)uri);
            if (result == null && createp) {
                return FakeFlow.create((HttpServletRequest)request, (URI)uri);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Resource URI is malformed: " + rawuri);
        }
    }
}

