<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -
   - Users Admin - present a list of users with 3 columns:
   -   1. username (login name), also a link to edit user/roles
   -   2. personal name, if any
   -   3. button/link to disable or enable
   -
   -  Args:
   -   action=disable -- handle a disable action on one user
   -    (default action is just to list users; create and reinstate
   -     are done in the user-edit page since they require password entry.)
   -   username -- principal (login) name of new user to disable
  --%>
<%@ page import="java.sql.Connection" %>
<%@ page import="java.util.Arrays" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.HashMap" %>
<%@ page import="java.util.Set" %>
<%@ page import="java.util.Collection" %>
<%@ page import="java.sql.Connection" %>
<%@ page import="java.sql.SQLException" %>

<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>

<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.eaglei.repository.NamedGraph" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.User" %>
<%@ page import="org.eaglei.repository.admin.AuthUser" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.BadRequestException" %>
<%@ page import="org.eaglei.repository.status.NotFoundException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>

  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <title>Eagle-I Data Repository Admin - Manage User Accounts</title>
  </head>
<%
    Logger log = LogManager.getLogger("org.eaglei.repository.admin.users.jsp");

    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = true;

    try {
        if (!Access.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");

        // MUST call this before getting any parameters
        request.setCharacterEncoding("UTF-8");
        String action = request.getParameter("action");
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String disable = request.getParameter("disable");
        String reinstate = request.getParameter("reinstate");

        if (action != null) {
            if (username == null || username.length() == 0)
                throw new BadRequestException("You must enter a username for this action.");

            // disable a user
            if (action.equals("disable")) {
                AuthUser au = AuthUser.find(username);
                if (au == null)
                    throw new NotFoundException("User not found in authentication database: "+username);
                Connection c = AuthUser.startTransaction();
                try {
                    au.delete(c);
                    AuthUser.commitTransaction(c);
                    c = null;
                    log.debug("Deleted authUser, username="+username);
                } finally {
                    if (c != null)
                        AuthUser.abortTransaction(c);
                }
                message = "Disabled user "+username;
                 
            } else {
                throw new BadRequestException("Unrecognized value of 'action' arg: \""+action+"\"");
            }
        }
%>
  <body bgcolor=lightyellow>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Manage User Accounts</h2>

<%
        if (message != null) {
%>
    <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
    </h3>
<%
        }
%>
     <h3>&#x26ab; <a href="/repository/admin/editUserPortlet.jsp?standalone&amp;create_auth">
         Create a New User Account</a>
     </h3>
    <h3>&#x26ab; Manage Existing User Accounts</h3>
    <!-- columns: username, personal name, enabled? -->
    <div style="margin: 0px 0px 0px 30px;">
    <table border="1">
    <tr>
      <th>Login</th>
      <th>Personal Name</th>
      <th>Action</th>
    </tr>
<%
    Map<String,AuthUser> username2auth = AuthUser.findAllAsMap();
    RepositoryConnection rc = WithRepositoryConnection.get(request);
    Map<String,User> username2user = new HashMap<String,User>();

    for (User u : User.findAll(request)) {
        username2user.put(u.getUsername(), u);
    }
    for (String aname : username2auth.keySet()) {
        if (!username2user.containsKey(aname))
            username2user.put(aname, null);
    }
    Set<String> userSet = username2user.keySet();
    String users[] = userSet.toArray(new String[userSet.size()]);
    Arrays.sort(users);
    for (String uu : users) {
        String eu = Utils.urlEncode(uu);
        User u = username2user.get(uu);
        String pn = u == null ? "<i>Undocumented</i>" : u.getPersonalName();
 %>
        <tr>
          <td>
            <a href="/repository/admin/editUserPortlet.jsp?standalone=true&username=<%= eu %>">
                  <tt><%= uu %></tt>
            </a>
          </td>
          <td><%= pn == null ? "" : pn %></td>
          <!-- skull == unicode &#x2620; heart=&#x2661, solidheart 2665  -->
          <td><%=  username2auth.containsKey(uu) ?
                     "<a href=\"/repository/admin/users.jsp?action=disable&username="+eu+"\">&#x2620 Disable</a>" :
                     "<a href=\"/repository/admin/editUserPortlet.jsp?standalone=true&create_auth=true&username="+eu+"\">&#x2665 Reinstate</a>" %>
          </td>
        </tr>
<%
    }
%>
    </table>
    <i>Click on username to edit user's properties, change password, etc.</i>
    </div>
    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
