<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="org.eaglei.repository.User" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<!--
  - Parameters:
  -  1. When sending mail:
  -     uri
  -     label
  -     safe=true - ONLY when it is "safe" to send mail for testing
  -  2. Having SENT mail, this page ALSO reports success:
  -     sent=true  - REQUIRED, this is how to invoke sent mode
  -     uri
  -     test_mode = true when running in test mode..
  -     to - ONLY FOR DEBUG, NOT in production (it would reveal the hidden contact)
  -->
<html>
  <head>
     <meta http-equiv="Content-type" content="text/html;charset=UTF-8" />
    <title>Eagle-I Repository - Contact Owner</title>
  </head>
  <body bgcolor=lightyellow>
<%
    request.setCharacterEncoding("UTF-8");
    String uri = request.getParameter("uri");
    String sent = request.getParameter("sent");
    boolean testMode = Boolean.parseBoolean(request.getParameter("test_mode"));
    if (sent != null) {
%>
        <h2>Message sent.</h2>
<%
        String to = request.getParameter("to");
        if (to != null) {
%>
         <h3>DEBUG: Sent to: <%= testMode ? "Postmaster, in lieu of: ":"" %><tt><%= to %></tt></h3>
<%
        }
        if (uri != null) {
%>
         <p/>
         <p>
         Return to <a href="<%= uri %>"><%= uri %></a>.
<%
        }
%>
        <p/>
        <button type="button" title="Close window" onclick="javascript:window.close();">Close Window</button>
<%
    } else {
        String label = request.getParameter("label");
        String remoteIP = request.getRemoteAddr();
        if (uri == null) {
            response.sendError(response.SC_BAD_REQUEST, "missing required parameter 'uri'");
            return;
        }
        String name = "";
        String email = "";
        try {
            User uu = Access.getPrincipalUser(request);
            if (uu != null) {
                String firstName = uu.getFirstName();
                String lastName = uu.getLastName();
                String mbox = uu.getMbox();
                if (firstName != null || lastName != null)
                    name = (firstName == null) ? lastName :
                                           (lastName == null) ? firstName : firstName+" "+lastName;
                if (mbox != null)
                    email = mbox;
            }
        } catch (ErrorSendingException e) {
            response.sendError(e.getStatus(), e.getMessage());
        }
%>
        <%@ include file="/repository/admin/banner.jsp" %>
        <h2>Contact the Owner of this Resource</h2>
        <blockquote>
<%
        if (label == null) {
%>
        <h3>URI: <tt><%= uri %></tt></h3>
<%
        } else {
%>
        <h3>Label: <%= label %></h3>
        <h4>URI: <tt><%= uri %></tt></h4>
<%
        }
%>
        </blockquote>
        <p/>
        <form method="POST" action="/repository/emailContact">
          <input type="hidden" name="uri" value="<%= uri %>"/>
          <input type="hidden" name="client_ip" value="<%= remoteIP %>"/>
          <label for="id_name"><b>Your Name:</b> </label>
          <input type="text" name="from_name" id="id_name" size="40" value="<%= name %>"/>
          <i>(Required)</i>
          <br/>
          <label for="id_email"><b>Your Email:</b> </label>
          <input type="text" name="from_email" id="id_email" size="40" value="<%= email %>"/>
          <i>(Required)</i>
          <br/>
          <label for="id_subj"><b>Subject:</b> </label>
          <input type="text" name="subject" id="id_subj" size="50" />
<%
        boolean safe = Boolean.parseBoolean(request.getParameter("safe"));
%>
          <br/>
          <label for="id_test"><b>Test Mode: </b></label>
          <input type="checkbox" name="test_mode" id="id_test" checked="true"/>
            <!-- <%= safe ? "" : "checked" %> -->
          <label for="id_test">
            <b>
              <i>
                <%= safe ? "<u>UN</u>Checking this box sends REAL EMAIL, but at least it is going to someone with an \"@eagle-i.org\" address." :
                           "<font color=\"red\">ONLY uncheck this box if you don't mind sending email to some random researcher at an eagle-i site.</font>" %>
              </i>
            </b>
          </label>
          <br/>
          <br/>
          <label for="id_msg"><b>Message:</b> </label>
          <br/>
          <textarea id="id_msg" name="message" cols="60" rows="12"></textarea>
          <br/><i>Note: CAPCHA or security question will be needed for proof of humanity</i>
          <br/>
          <input type="button" value="Cancel" onclick="javascript:window.close();"/>
          <input type="submit" value="Send" name="submit"/>
        </form>
<%
    }
%>
  </body>
</html>
