package org.eaglei.repository.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.model.URI;

import org.eaglei.repository.Access;
import org.eaglei.repository.User;
import org.eaglei.repository.vocabulary.FOAF;
import org.eaglei.repository.vocabulary.REPO;
import org.eaglei.repository.util.SPARQL;

/**
 * Get status of current authenticated user as tabular result.
 * Returns an empty result when there is no authenticated user.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class WhoAmI extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(WhoAmI.class);

    /** {@inheritDoc} */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        request.setCharacterEncoding("UTF-8");
        String format = request.getParameter("format");

        URI me = Access.getPrincipalURI(request);
        String query = "SELECT DISTINCT ?uri ?username ?firstname ?lastname ?mbox \n"+
                "WHERE { ?uri <"+REPO.HAS_PRINCIPAL_NAME+"> ?username .\n"+
                "        OPTIONAL { ?uri <"+FOAF.FIRST_NAME+"> ?firstname } .\n"+
                "        OPTIONAL { ?uri <"+FOAF.SURNAME+"> ?lastname } .\n"+
                "        OPTIONAL { ?uri <"+FOAF.MBOX+"> ?mbox } .\n"+
                "        FILTER( ?uri = <"+me+"> ) }";

        SPARQL.tupleQueryRequest(request, response, query, format, User.getUserDataset());
    }
}
