/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.rid;

import java.util.Iterator;
import java.util.UUID;

public class RIDSequence
implements Iterator<UUID> {
    private long time;
    private long clockID;
    private int start;
    private int amount;
    private int i = 0;

    public RIDSequence(long timeValue, long clockIDValue, int startValue, int amountValue) {
        this.time = timeValue;
        this.clockID = clockIDValue;
        this.start = startValue;
        this.amount = amountValue;
    }

    @Override
    public UUID next() {
        long least = this.composeLeast(this.clockID, this.i);
        ++this.i;
        return new UUID(this.time, least);
    }

    private long composeLeast(long clock, int sequence) {
        return clock | (long)sequence & 0xFFFFFFFFL;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.amount;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

