/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.Formats;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.View;
import org.eaglei.repository.servlet.Harvest;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DATAMODEL;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;

public class Harvest
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Harvest.class);
    private static final String DELETED_PREFIX = "info:/deleted#";
    private static final String[] column = new String[]{"subject", "predicate", "object"};
    private static List<String> columnNames = null;
    private static final String detailIdNoTimeQuery = "SELECT DISTINCT ?subject WHERE \n{ ?subject a ?typ}";
    private static final String detailFullNoTimeQuery;
    private static final String deletedFromTimeQueryProlog;
    private static final String deletedAndWithdrawnFromTimeQuery;
    private static final String deletedNotWithdrawnFromTimeQuery;
    private static final String identifierFromTimeQuery;
    private static final String fullFromTimeQuery;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * Unable to fully structure code
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block33: {
            block34: {
                request.setCharacterEncoding("UTF-8");
                request.setCharacterEncoding("UTF-8");
                format = request.getParameter("format");
                rawview = request.getParameter("view");
                rawws = request.getParameter("workspace");
                inferred = Utils.parseBooleanParameter((String)request.getParameter("inferred"), (String)"inferred", (boolean)false, (boolean)false);
                rawfrom = request.getParameter("from");
                rawdetail = request.getParameter("detail");
                view = null;
                if (request.getParameter("until") != null) {
                    throw new HttpStatusException(501, "The 'until' arg is not implemented yet.");
                }
                detail = (DetailArg)Utils.parseKeywordArg(DetailArg.class, (String)rawdetail, (String)"detail", (boolean)true, null);
                from = null;
                if (rawfrom != null) {
                    from = Utils.parseXMLDate((String)rawfrom);
                }
                if (detail == DetailArg.identifier && inferred) {
                    throw new BadRequestException("The 'inferred' arg is not allowed when detail = identifier.");
                }
                if (rawws != null && rawview != null) {
                    throw new BadRequestException("The 'view' and 'workspace' arguments are mutually exclusive.  Choose only one.");
                }
                workspace = Utils.parseURI((String)rawws, (String)"workspace", (boolean)false);
                startMs = System.currentTimeMillis();
                didQuery = false;
                mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format);
                tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
                if (tqf == null) {
                    throw new InternalServerErrorException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
                }
                response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
                out = QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream());
                lm = DataRepository.getInstance().getLastModified();
                response.addDateHeader("Last-Modified", lm.getTime());
                if (from == null) ** GOTO lbl44
                if (!lm.before(from.toGregorianCalendar().getTime())) break block33;
                Harvest.log.debug((Object)("Optimizing result since last-modified mark is earlier than from: last-mod = " + lm));
                out.startQueryResult(Harvest.columnNames);
                out.endQueryResult();
                if (!didQuery) break block34;
                Harvest.log.info((Object)("SPARQL query for /harvest request completed in " + String.format("%,d mSec.", new Object[]{System.currentTimeMillis() - startMs})));
            }
            return;
        }
        try {
            Harvest.log.debug((Object)("Going ahead with query, last-modified mark is after 'from': last-mod = " + lm));
lbl44:
            // 2 sources

            rc = WithRepositoryConnection.get((ServletRequest)request);
            vf = rc.getValueFactory();
            ds = new DatasetImpl();
            if (workspace != null) {
                View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)ds, (URI)workspace);
            } else {
                v0 = view = rawview == null ? View.PUBLISHED_RESOURCES : View.parseView((String)rawview);
                if (view == null) {
                    throw new BadRequestException("Unknown view: " + rawview);
                }
                View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)view);
            }
            if (Harvest.log.isDebugEnabled()) {
                Harvest.log.debug((Object)("Dataset derived from initial 'view' or 'workspace' args = " + Utils.prettyPrint((Dataset)ds)));
            }
            resDS = new DatasetImpl();
            for (URI g : ds.getDefaultGraphs()) {
                if (REPO.NG_USERS.equals(g)) continue;
                ng = NamedGraph.find((HttpServletRequest)request, (URI)g);
                v1 = ngt = ng == null ? null : ng.getType();
                if (ngt != NamedGraph.Type.published && ngt != NamedGraph.Type.workspace) continue;
                SPARQL.addGraph((DatasetImpl)resDS, (URI)g);
            }
            didQuery = true;
            if (from == null) {
                if (Harvest.log.isDebugEnabled()) {
                    Harvest.log.debug((Object)("Resource Dataset = " + Utils.prettyPrint((Dataset)resDS)));
                }
                if (detail == DetailArg.identifier) {
                    Harvest.log.debug((Object)("HARVEST QUERY NO TIME (detail=" + detail + ") = \n" + "SELECT DISTINCT ?subject WHERE \n{ ?subject a ?typ}"));
                    q = rc.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT DISTINCT ?subject WHERE \n{ ?subject a ?typ}");
                    q.setDataset((Dataset)resDS);
                    q.setIncludeInferred(false);
                    q.evaluate((TupleQueryResultHandler)out);
                } else {
                    dg = resDS.getDefaultGraphs();
                    resGraphs = dg.toArray(new URI[dg.size()]);
                    if (inferred) {
                        SPARQL.addGraph((DatasetImpl)resDS, (URI)REPO.NG_INFERRED);
                    }
                    SPARQL.addGraph((DatasetImpl)resDS, (URI)DATAMODEL.GRAPH_NAME_URI);
                    if (Harvest.log.isDebugEnabled()) {
                        Harvest.log.debug((Object)("HARVEST QUERY NO TIME (detail=" + detail + ") = \n" + Harvest.detailFullNoTimeQuery));
                    }
                    q = rc.prepareTupleQuery(QueryLanguage.SPARQL, Harvest.detailFullNoTimeQuery);
                    q.setDataset((Dataset)resDS);
                    q.setIncludeInferred(inferred);
                    out.startQueryResult(Harvest.columnNames);
                    for (URI graph : resGraphs) {
                        if (Harvest.log.isDebugEnabled()) {
                            Harvest.log.debug((Object)("Getting FULL Resource Instances from graph=" + graph));
                        }
                        q.clearBindings();
                        q.setBinding("graph", (Value)graph);
                        q.evaluate((TupleQueryResultHandler)new wrappedHandler((TupleQueryResultHandler)out));
                    }
                    out.endQueryResult();
                }
            } else {
                dds = new DatasetImpl();
                for (NamedGraph ng : NamedGraph.findAll((HttpServletRequest)request)) {
                    ngt = ng.getType();
                    if (Harvest.log.isDebugEnabled()) {
                        Harvest.log.debug((Object)("for DDS, Trying NamedGraph type=" + ngt + ", name=" + ng.getName()));
                    }
                    if (ngt != NamedGraph.Type.published && ngt != NamedGraph.Type.workspace && ngt != NamedGraph.Type.metadata) continue;
                    SPARQL.addGraph((DatasetImpl)dds, (URI)ng.getName());
                }
                v2 = qs = REPO.NG_WITHDRAWN.equals(workspace) != false ? Harvest.deletedNotWithdrawnFromTimeQuery : Harvest.deletedAndWithdrawnFromTimeQuery;
                if (Harvest.log.isDebugEnabled()) {
                    Harvest.log.debug((Object)("Resource DELETE Dataset = " + Utils.prettyPrint((Dataset)dds)));
                    Harvest.log.debug((Object)("HARVEST QUERY DELETED/WITHDRAWN (detail=" + detail + ") = \n" + qs));
                }
                q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
                q.setDataset((Dataset)dds);
                q.setIncludeInferred(false);
                q.setBinding("from", (Value)vf.createLiteral(from));
                out.startQueryResult((List)(detail == DetailArg.identifier ? Harvest.columnNames.subList(0, 1) : Harvest.columnNames));
                q.evaluate((TupleQueryResultHandler)new deletedHandler((TupleQueryResultHandler)out, detail));
                dg = resDS.getDefaultGraphs();
                resGraphs = dg.toArray(new URI[dg.size()]);
                SPARQL.addGraph((DatasetImpl)resDS, (URI)REPO.NG_METADATA);
                if (inferred) {
                    SPARQL.addGraph((DatasetImpl)resDS, (URI)REPO.NG_INFERRED);
                }
                if (detail == DetailArg.full) {
                    SPARQL.addGraph((DatasetImpl)resDS, (URI)DATAMODEL.GRAPH_NAME_URI);
                }
                q = rc.prepareTupleQuery(QueryLanguage.SPARQL, detail == DetailArg.identifier ? Harvest.identifierFromTimeQuery : Harvest.fullFromTimeQuery);
                q.setDataset((Dataset)resDS);
                q.setIncludeInferred(inferred);
                lfrom = vf.createLiteral(from);
                for (URI graph : resGraphs) {
                    if (Harvest.log.isDebugEnabled()) {
                        Harvest.log.debug((Object)("Getting non-deleted Resource Instances mod. since=" + from + ", from graph=" + graph));
                    }
                    q.clearBindings();
                    q.setBinding("from", (Value)lfrom);
                    q.setBinding("graph", (Value)graph);
                    q.evaluate((TupleQueryResultHandler)new wrappedHandler((TupleQueryResultHandler)out));
                }
                out.endQueryResult();
            }
            ** if (!didQuery) goto lbl-1000
        }
        catch (OpenRDFException e) {
            try {
                Harvest.log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (Throwable var34_37) {
                if (didQuery) {
                    Harvest.log.info((Object)("SPARQL query for /harvest request completed in " + String.format("%,d mSec.", new Object[]{System.currentTimeMillis() - startMs})));
                }
                throw var34_37;
            }
        }
lbl-1000:
        // 1 sources

        {
            Harvest.log.info((Object)("SPARQL query for /harvest request completed in " + String.format("%,d mSec.", new Object[]{System.currentTimeMillis() - startMs})));
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    static /* synthetic */ List access$000() {
        return columnNames;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ String[] access$200() {
        return column;
    }

    static {
        columnNames = Arrays.asList(column);
        detailFullNoTimeQuery = "SELECT ?subject ?predicate ?object WHERE \n{{GRAPH ?graph {?subject a ?typ . GRAPH <" + REPO.NG_INFERRED + "> {?subject ?predicate ?object}}}\n" + " UNION {GRAPH ?graph {?subject a ?typ; ?predicate ?object \n" + "  OPTIONAL { GRAPH <" + "http://purl.obolibrary.org/obo/ero.owl" + "> { ?predicate <" + DATAMODEL.IN_PROPERTY_GROUP + "> ?pgad \n" + "    FILTER(?pgad = <" + DATAMODEL.PROPERTY_GROUP_ADMIN_DATA + ">)}}\n" + "  FILTER(!(BOUND(?pgad))) }}} ORDER BY ?subject";
        deletedFromTimeQueryProlog = "SELECT DISTINCT ?subject WHERE \n{ GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n" + " FILTER(?mod >= ?from)\n" + " OPTIONAL{ GRAPH ?g {?subject a ?t}} \n";
        deletedAndWithdrawnFromTimeQuery = deletedFromTimeQueryProlog + "  FILTER(!bound(?t) || ?g = <" + REPO.NG_WITHDRAWN + ">) }\n" + "ORDER BY ?subject";
        deletedNotWithdrawnFromTimeQuery = deletedFromTimeQueryProlog + "  FILTER(!bound(?t)) }\n" + "ORDER BY ?subject";
        identifierFromTimeQuery = "SELECT DISTINCT ?subject WHERE \n{ GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n" + " FILTER( ?mod >= ?from )" + " GRAPH ?graph {?subject a ?type}} ORDER BY ?mod";
        fullFromTimeQuery = "SELECT DISTINCT ?subject ?predicate ?object WHERE \n{ GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n" + " FILTER( ?mod >= ?from )" + " {{GRAPH <" + REPO.NG_INFERRED + "> {?subject ?predicate ?object}} UNION\n" + "  {GRAPH ?graph {?subject a ?type; ?predicate ?object} \n" + "   OPTIONAL { GRAPH <" + "http://purl.obolibrary.org/obo/ero.owl" + "> { ?predicate <" + DATAMODEL.IN_PROPERTY_GROUP + "> ?pgad \n" + "     FILTER(?pgad = <" + DATAMODEL.PROPERTY_GROUP_ADMIN_DATA + ">)}}\n" + "   FILTER(!(BOUND(?pgad))) }}} ORDER BY ?subject";
    }
}

