/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.User;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.FOAF;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;

public class WhoAmI
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WhoAmI.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String format = request.getParameter("format");
        URI me = Access.getPrincipalURI((HttpServletRequest)request);
        String query = "SELECT DISTINCT ?uri ?username ?firstname ?lastname ?mbox \nWHERE { ?uri <" + REPO.HAS_PRINCIPAL_NAME + "> ?username .\n" + "        OPTIONAL { ?uri <" + FOAF.FIRST_NAME + "> ?firstname } .\n" + "        OPTIONAL { ?uri <" + FOAF.SURNAME + "> ?lastname } .\n" + "        OPTIONAL { ?uri <" + FOAF.MBOX + "> ?mbox } .\n" + "        FILTER( ?uri = <" + me + "> ) }";
        SPARQL.tupleQueryRequest((HttpServletRequest)request, (HttpServletResponse)response, (String)query, (String)format, (Dataset)User.getUserDataset());
    }
}

