/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.util.Utils;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Dataset;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static Logger log = LogManager.getLogger(Utils.class);

    private Utils() {
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static String prettyPrint(Dataset ds) {
        StringBuilder result = new StringBuilder();
        for (URI u : ds.getDefaultGraphs()) {
            result.append("FROM ").append(u == null ? "{null}" : "<" + u.toString() + ">").append("\n");
        }
        for (URI u : ds.getNamedGraphs()) {
            result.append("FROM NAMED ").append(u == null ? "{null}" : "<" + u.toString() + ">").append("\n");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static boolean isValidURI(String s) {
        try {
            new URIImpl(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static URI parseURI(String s, String argName, boolean required) {
        if (s == null) {
            if (required) {
                throw new BadRequestException("Missing required argument: " + argName);
            }
            return null;
        }
        try {
            return new URIImpl(s);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Argument '" + argName + "' is not a valid URI: " + e);
        }
    }

    public static Enum parseKeywordArg(Class et, String name, String argName, boolean required, Enum defaultValue) {
        if (name == null) {
            if (required) {
                throw new BadRequestException("Missing required argument: " + argName);
            }
            return defaultValue;
        }
        try {
            return Enum.valueOf(et, name);
        }
        catch (IllegalArgumentException e) {
            try {
                throw new BadRequestException("Illegal value for '" + argName + "', must be one of: " + Arrays.deepToString((Enum[])et.getMethod("values", new Class[0]).invoke(null, new Object[0])));
            }
            catch (NoSuchMethodException ee) {
                log.error((Object)"Failed generating arglist for exception, ", (Throwable)ee);
                throw new BadRequestException("Illegal value for '" + argName + "'");
            }
            catch (IllegalAccessException ee) {
                log.error((Object)"Failed generating arglist for exception, ", (Throwable)ee);
                throw new BadRequestException("Illegal value for '" + argName + "'");
            }
            catch (InvocationTargetException ee) {
                log.error((Object)"Failed generating arglist for exception, ", (Throwable)ee);
                throw new BadRequestException("Illegal value for '" + argName + "'");
            }
        }
    }

    public static boolean parseBooleanParameter(String name, String argName, boolean required, boolean defaultValue) {
        BooleanArg b = null;
        if (name == null) {
            if (required) {
                throw new BadRequestException("Missing required argument: " + argName);
            }
            b = defaultValue ? BooleanArg.true1 : BooleanArg.false1;
        } else {
            for (BooleanArg ba : BooleanArg.values()) {
                if (!BooleanArg.access$000((BooleanArg)ba).equals(name)) continue;
                b = ba;
                break;
            }
            if (b == null) {
                throw new BadRequestException("Illegal value for '" + argName + "', must be one of: " + Arrays.deepToString(BooleanArg.values()));
            }
        }
        return BooleanArg.access$100((BooleanArg)b);
    }

    public static XMLGregorianCalendar parseXMLDate(String raw) {
        XMLGregorianCalendar result = null;
        try {
            result = XMLDatatypeUtil.parseCalendar((String)raw);
            if (result.getDay() == Integer.MIN_VALUE) {
                throw new BadRequestException("This date/time argument is incomplete, it must include at least complete date: " + raw);
            }
            if (result.getHour() == Integer.MIN_VALUE) {
                result.setHour(0);
            }
            if (result.getMinute() == Integer.MIN_VALUE) {
                result.setMinute(0);
            }
            if (result.getSecond() == Integer.MIN_VALUE) {
                result.setSecond(0);
            }
            if (result.getTimezone() == Integer.MIN_VALUE) {
                TimeZone td = TimeZone.getDefault();
                int tzMinutes = td.getRawOffset() / 60000;
                if (td.inDaylightTime(new Date())) {
                    tzMinutes += td.getDSTSavings() / 60000;
                }
                result.setTimezone(tzMinutes);
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Illegal date format in this date/time argument: " + e.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseXMLDate: given string = \"" + raw + "\", interpreted as = " + result + ", as java.util.Date = " + result.toGregorianCalendar().getTime().toString()));
        }
        return result;
    }

    public static String makeContentType(String mimeType, String charset) {
        if (mimeType.indexOf("charset=") < 0) {
            return mimeType + "; charset=" + charset;
        }
        return mimeType;
    }

    public static String contentTypeGetCharset(String ct, String dflt) {
        int lastQuote;
        String[] e = ct.split(";\\s*[cC][hH][aA][rR][sS][eE][tT]=", 2);
        if (e.length < 2) {
            return dflt;
        }
        String result = e[1];
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if ((lastQuote = result.indexOf("\"")) >= 0) {
            result = result.substring(0, lastQuote);
        }
        return result;
    }

    public static String contentTypeGetMIMEType(String ct) {
        String[] e = ct.split(";\\s*", 2);
        return e[0];
    }

    public static String toString(byte[] ba) {
        StringBuilder result = new StringBuilder("[");
        boolean first = true;
        for (byte b : ba) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            String h = Integer.toHexString(b & 0xFF);
            if (h.length() < 2) {
                result.append("0");
            }
            result.append(h);
        }
        result.append("]");
        return result.toString();
    }

    public static String urlEncode(String in) throws IOException {
        try {
            byte[] bb = in.getBytes("UTF-8");
            StringBuilder result = new StringBuilder();
            for (byte b : bb) {
                char c = (char)b;
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '~') {
                    result.append(c);
                    continue;
                }
                String hex = Integer.toHexString(b & 0xFF);
                log.debug((Object)("Converting reserved char " + String.valueOf(b) + " => " + hex));
                result.append(hex.length() < 2 ? "%0" : "%");
                result.append(hex);
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            throw e;
        }
    }
}

