<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  "Portal" (or frame-content) page to change user password, and
   -  optionally, other user metadata.
   -
   -  Invocation Modes:
   -    1. Password change: when "only_password" arg is present (no value
   -       needed) to get a form that only offers inputs to change the password.
   -    2. Create/reinstate auth user: When create_auth is present,
   -       add a new auth user and require new password to be supplied.
   -    3. Standalone:  Invoking this page with the "standalone" arg
   -       presents it as a regular repository admin-UI page so we can
   -       use it outside of the frame in the data tools
   -
   -  OPTIONAL ARGS: (also passed through form)
   -   username  - principal name of user to change, defaults to authenticated
   -   only_password - if specified, do not include other metadata inputs.
   -   create_auth - create a new authUser record, requires password
   -   standalone - flag to put up a whole standalone UI
   -  Args set by form:
   -   old_password - current (old) password, required for user changing own pw
   -   password - new password
   -   password_confirm - must match new password
   -   first - first name
   -   last - last name
   -   mailbox - mailbox
   -   role - multiple values, URI of roles to apply to user
   -   submit - present when "submit" button is pressed
   -
   -  @author Larry Stone
   -  Started Jul 2010, @version $Id: $
  --%>
<%@ page import="java.sql.Connection" %>
<%@ page import="java.util.List" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.openrdf.model.impl.URIImpl" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.Role" %>
<%@ page import="org.eaglei.repository.User" %>
<%@ page import="org.eaglei.repository.admin.AuthUser" %>
<%@ page import="org.eaglei.repository.status.BadRequestException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>

<%@ page import="org.eaglei.repository.status.NotFoundException" %>
<%!
    private static boolean isDifferent(String a, String b)
    {
        return a == null && b != null ||
                a != null && b == null ||
                !((a == null && b == null) || a.equals(b));
    }
    // return null if param is empty string
    private String getNonEmptyParameter(HttpServletRequest request, String name)
    {
        String result = request.getParameter(name);
        if (result != null && result.length() == 0)
            return null;
        return result;
    }
    private String acceptCharset = "UTF-8";
%>
<%
    Logger log = LogManager.getLogger("org.eaglei.repository.admin.editUserPortlet.jsp");

    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = true;

    // MUST call this before getting any parameters
    request.setCharacterEncoding(acceptCharset);
    boolean standalone = request.getParameter("standalone") != null;
    boolean onlyPassword = request.getParameter("only_password") != null;
    boolean createAuth = request.getParameter("create_auth") != null;
    String submit = request.getParameter("submit");
    String password = getNonEmptyParameter(request, "password");
    String password_confirm = getNonEmptyParameter(request, "password_confirm");
    String first = getNonEmptyParameter(request, "first");
    String last = getNonEmptyParameter(request, "last");
    String mailbox = getNonEmptyParameter(request, "mailbox");
    String username = getNonEmptyParameter(request, "username");
    String roleURI[] = request.getParameterValues("role");

    if (log.isDebugEnabled()) {
        if (first != null)
            log.debug("first=\""+first+"\", bytes="+Utils.toString(first.getBytes(acceptCharset)));
        if (last != null)
            log.debug("last=\""+last+"\", bytes="+Utils.toString(last.getBytes(acceptCharset)));
    }
    try {

        // Get user metadata object UNLESS putting up form to create new user
        // Create MD object if necessary, assuming an "undocumented" auth user.
        User uu = null;
        if (!(createAuth && username == null)) {
            if (username == null) {
                uu = Access.getPrincipalUser(request);
                if (uu == null)
                    throw new BadRequestException("There is no authenticated user.");
                else
                    username = uu.getUsername();
            } else {
                uu = User.findUsername(request, username);
            }
        }

        // are we editing current user?
        boolean currentUser = request.getParameter("username") == null ||
            (uu != null && uu.getURI().equals(Access.getPrincipalURI(request)));

        // present the form, with existing values filled in
        if (submit == null) {
            if (uu != null) {
                first = uu.getFirstName();
                last = uu.getLastName();
                mailbox = uu.getMbox();
            }

        // execute the requested changes
        } else {

            // sanity check: username and password required
            if (username == null)
                throw new BadRequestException("You must enter a Username.");

            // sanity check password
            if (password != null || password_confirm != null) {
                if (!(password != null && password_confirm != null &&
                      password.equals(password_confirm)))
                    throw new BadRequestException("Password values do not match.");
            }

            // create or reinstate a user - must be admin!
            if (createAuth) {
                if (!Access.isSuperuser(request))
                    throw new ForbiddenException("Only an Administrator may create or reinstate a user.");

                if (password == null)
                    throw new BadRequestException("You must enter a Password when creating or reinstating a user.");

                Connection c = AuthUser.startTransaction();
                try {
                    AuthUser.create(c, username, password, false);
                    AuthUser.commitTransaction(c);
                    c = null;
                } finally {
                    if (c != null)
                        AuthUser.abortTransaction(c);
                }

                // also create metadata object in RDF if necessary
                if (uu == null) {
                    uu = User.create(request, username);
                    uu.update(request);
                    log.debug("Created new authUser, username="+username);
                    message = "New user created.";
                } else {
                    log.debug("Reinstated authUser, username="+username);
                    message = "User reinstated.";
                }
                createAuth = false;

            // change password in exsiting AuthUser
            } else if (password != null) {
                if (!Access.hasPermissionOnUser(request, username))
                    throw new ForbiddenException("Not allowed to modify user: "+username);
                AuthUser au = AuthUser.find(username);
                if (au == null)
                    throw new NotFoundException("User not found in authentication database: "+username);
                if (currentUser) {
                    String oldPassword = request.getParameter("old_password");
                    if (oldPassword == null || !au.authenticate(oldPassword))
                        throw new ForbiddenException("Old password does not match, you are not allowed to update your password without it.");
                }
                au.setPassword(password);
                Connection c = AuthUser.startTransaction();
                try {
                    au.update(c);
                    AuthUser.commitTransaction(c);
                    c = null;
                    log.debug("Changed the password, username="+username);
                } finally {
                    if (c != null)
                        AuthUser.abortTransaction(c);
                }
                message = "Password changed.";
            }

            // edit user metadata
            if (!onlyPassword) {
                boolean changed = false;
                if (uu == null) {
                    log.debug("Creating new RDF User, for username="+username);
                    uu = User.create(request, username);
                    if (uu == null)
                        throw new NotFoundException("Failed creating a user named: "+username);
                    else
                        uu.update(request);
                }
                if (isDifferent(first, uu.getFirstName())) {
                    uu.setFirstName(request, first);
                    log.debug("Changed first name = "+first);
                    changed = true;
                }
                if (isDifferent(last, uu.getLastName())) {
                    uu.setLastName(request, last);
                    log.debug("Changed last name = "+last);
                    changed = true;
                }
                if (isDifferent(mailbox, uu.getMbox())) {
                    uu.setMbox(request, mailbox);
                    log.debug("Changed mbox = "+mailbox);
                    changed = true;
                }

                // update roles - let User object figure out diffs.
                if (Access.isSuperuser(request)) {
                    if (roleURI == null)
                        roleURI = new String[0];
                    Role role[] = new Role[roleURI.length];
                    for (int i = 0; i < roleURI.length; ++i)
                        role[i] = Role.find(request, new URIImpl(roleURI[i]));
                    if (uu.setRoles(request, role))
                        changed = true;
                }
                if (changed)
                    uu.update(request);
                if (changed && message == null && messageSuccess)
                    message = "User has been modified.";
            }
        }
%>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <title>Eagle-I Data Repository - Edit User Metadata</title>
<%
        if (standalone) {
%>
              <style type="text/css">
                  .ei_required { color: red; }
                  .eaglei_passwdForm form { margin: 30px 0; }
                  .eaglei_passwdForm label { margin: 0 20px 5px 20px; }
                  .eaglei_passwdForm input { margin: 5px 20px;  }
              </style>
            </head>
            <body bgcolor=lightyellow>
              <%@ include file="/repository/admin/banner.jsp" %>
<%
            if (createAuth && submit == null) {
%>
                <h2><%= username == null ? "Creating a New User" : "Reinstating: <tt>"+username+"</tt>" %></h2>
<%
            } else {
%>
                <h2>Editing <%= currentUser ? "Current":"" %> User: <tt><%= username %></tt></h2>
<%
                if (uu != null) {
%>
                    <h3>URI: <tt><%= uu.getURI() %></tt></h3>
<%
                }
            }
%>
              <span class="ei_required"><i>Input fields labelled in <b>RED</b> are <b>required</b></i></span>
<%
        } else {
%>
              <link REL="stylesheet" TYPE="text/css" HREF="/repository/styles/i.css">
            </head>
            <body>
<%
        }
        if (message != null) {
%>
            <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
                  <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %></font>
            </h3>
<%
        }
%>
    <div class="eaglei_passwdForm">
     <form method="POST" action="/repository/admin/editUserPortlet.jsp" accept-charset="<%= acceptCharset %>">
<%
        if (standalone) {
%>
            <input type="hidden" name="standalone"/>
<%
        }
        if (createAuth && submit == null) {
%>
            <input type="hidden" name="create_auth"/>
<%
        }
        if (onlyPassword) {
%>
            <input type="hidden" name="only_password" value="true"/>
            <input type="hidden" name="username" value="<%= username %>"/>
<%
        } else {
            if (createAuth && submit == null && username == null) {
%>
                <label for="id_username"><span class="ei_required"><b>Username:</b> </span></label>
                <input type="text" name="username" id="id_username" size="30" value="<%= username == null ?  "" :  username %>"/>
                <br/>
<%
            } else {
%>
                <input type="hidden" name="username" value="<%= username %>"/>
<%
            }
%>
            <label for="id_first"><b>First Name:</b> </label>
            <input type="text" name="first" id="id_first" size="30" value="<%= first == null ?  "" :  first %>"/>
            <br/>
            <label for="id_last"><b>Last Name:</b> </label>
            <input type="text" name="last" id="id_last" size="30" value="<%= last == null ? "" : last %>"/>
            <br/>
            <label for="id_mailbox"><b>Mailbox:</b> </label>
            <input type="text" name="mailbox" id="id_mailbox" size="40" value="<%= mailbox == null ? "" : mailbox %>"/>
<%
        }

        // if this is changing our own password, request old password first:
        if (!createAuth && currentUser) {
%>
        <br/>
        <label for="id_old_password">
          <span><b>Your Current Password:</b> </span>
        </label>
        <input type="password" name="old_password" id="id_old_password" size="20"/>
<%
        }
%>
        <br/>
        <label for="id_password">
          <span class="<%= createAuth ? "ei_required" : "" %>"><b><%= createAuth ? "" : "Change " %>Password:</b> </span>
        </label>
        <input type="password" name="password" id="id_password" size="20"/>
        <br/>
        <label for="id_password_confirm">
          <span class="<%= createAuth ? "ei_required" : "" %>"><b>Confirm Password:</b> </span>
        </label>
        <input type="password" name="password_confirm" id="id_password_confirm" size="20"/>
<%
        if (!onlyPassword) {
            String disabled = Access.isSuperuser(request) ? "" : "disabled ";
            List<Role> roles = Role.findAllUserRoles(request);
%>
            <br/>
            <label for="id_role" style="vertical-align: top;">
              <b>Roles: </b>
            </label>
            <select name="role" id="id_role" <%= disabled %>
                    multiple="true" size="<%= roles.size() > 6 ? 6 : roles.size() %>">
<%
            for (Role r : roles) {
                boolean has = uu != null && uu.hasRoleP(r.getURI());
%>
                <option <%= disabled %> <%= has ? "selected" : "" %> value="<%= r.getURI() %>"><%= r.getLabel() %></option>
<%
            }
%>
            </select>
            <br/><label><i>Use CTRL-click or COMMAND-click to select / deselect multiple Roles.</i></label>
            <br/>
<%
        }
%>
        <br/>&nbsp;&nbsp;&nbsp;&nbsp;
        <button type="reset">Reset Form</button>
        &nbsp;&nbsp;&nbsp;&nbsp;
        <button name="submit" value="submit" type="submit">Submit</button>
     </form>
    </div>
<%
        if (standalone) {
%>
            <a href="/repository/admin/users.jsp">Back to User List page</a>
            <br/>
            <br/>
            <a href="/repository/admin/index.jsp">Return to Admin top level</a>
<%
        }
    } catch (IllegalArgumentException e) {
        response.sendError(response.SC_BAD_REQUEST, "Illegal argument: "+e.getMessage());
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
  </body>
</html>
