/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Role;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class Role {
    private static Logger log = LogManager.getLogger(Role.class);
    private URI uri;
    private String label;
    private static Map<URI, Role> cache = new HashMap();
    private static final String roleQuery = "SELECT DISTINCT ?ruri ?rlabel WHERE {  ?ruri <" + RDFS.SUBCLASSOF + "> <" + REPO.ROLE + "> . \n" + "  FILTER ( ?ruri != <" + REPO.ROLE + "> )\n" + "  OPTIONAL { ?ruri <" + RDFS.LABEL + "> ?rlabel } }";

    private Role(URI uri, String label) {
        this.uri = uri;
        this.label = label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Role find(HttpServletRequest request, URI uri) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        String label = null;
        RepositoryResult rr = null;
        try {
            if (!rc.hasStatement((Resource)uri, RDF.TYPE, (Value)REPO.ROLE, true, new Resource[0])) {
                throw new NotFoundException("There is no Role of URI=" + uri);
            }
            try {
                Value lv;
                rr = rc.getStatements((Resource)uri, RDFS.LABEL, null, false, new Resource[0]);
                if (rr.hasNext() && (lv = ((Statement)rr.next()).getObject()) instanceof Literal) {
                    label = ((Literal)lv).getLabel();
                }
            }
            finally {
                rr.close();
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("Failed finding Role for URI=" + uri), (Throwable)e);
            throw new ServletException("Failed finding Role for URI=" + uri, (Throwable)e);
        }
        if (label == null) {
            log.warn((Object)("No label found for Role URI=" + uri));
            label = uri.getLocalName();
        }
        Role result = Role.find((URI)uri, label);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Role.find(" + uri.stringValue() + ") => " + result));
        }
        return result;
    }

    public static Role find(URI uri, String label) {
        if (cache.containsKey(uri)) {
            return (Role)cache.get(uri);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("find: caching a new Role(" + uri.stringValue() + ", " + label + ")"));
        }
        Role result = new Role(uri, label);
        cache.put(uri, result);
        return result;
    }

    public static List<Role> findAll(HttpServletRequest request) throws ServletException {
        return Role.findAllInternal((HttpServletRequest)request, (boolean)false);
    }

    public static List<Role> findAllUserRoles(HttpServletRequest request) throws ServletException {
        return Role.findAllInternal((HttpServletRequest)request, (boolean)true);
    }

    private static List<Role> findAllInternal(HttpServletRequest request, boolean userp) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ArrayList<Role> result = new ArrayList<Role>();
        try {
            log.debug((Object)("All role SPARQL query = " + roleQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, roleQuery);
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            q.setIncludeInferred(true);
            q.evaluate((TupleQueryResultHandler)new allRoleHandler(result, userp));
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        return result;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object other) {
        return other instanceof Role && this.uri.equals(((Role)other).uri);
    }

    public String toString() {
        return "<#Role: uri=" + this.uri.toString() + ", label=" + this.label + ">";
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

