package org.eaglei.repository.servlet;

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.repository.RepositoryException;

import org.eaglei.repository.status.ErrorSendingException;

/**
 *
 *
 *
 * XXX TODO: doc to explain how this interoperates with runtime excep.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class RepositoryServlet extends HttpServlet {

    private static Logger log = LogManager.getLogger(RepositoryServlet.class);

    /** {@inheritDoc} */
    protected void service(HttpServletRequest req, HttpServletResponse resp)
        throws ServletException, IOException
    {
        String reqURI = req.getRequestURI();

        try {
            // make log files easier to trace
            log.debug("============== Starting Request "+reqURI);
            super.service(req, resp);

        // Servlets can throw BadRequetException to elicit a
        // 400 response, since ServletException results in 500..
        // Same mechanism for ForbiddenEx. and NotFoundEx.
        } catch (ErrorSendingException e) {
            // rollback now, prevents Sesame from logging errors at rc close.
            try {
                WithRepositoryConnection.get(req).rollback();
            } catch (RepositoryException re) {
                log.warn("Failed in rollback after error: "+re);
            }
            try {
                resp.sendError(e.getStatus(), e.getMessage());
            } catch (IllegalStateException ie) {
                log.error("Cannot convert Status Exception to appropriate status because response is in wrong state.  Original exception="+e.toString(), ie);
            }
        } finally {
            log.debug("============== Ending Request "+reqURI);
        }
    }
}
