/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.Role;
import org.eaglei.repository.User;
import org.eaglei.repository.admin.AuthUser;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.HandlerBadRequest;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.FOAF;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public class User {
    private static Logger log = LogManager.getLogger(User.class);
    private static final URI USER_GRAPH = REPO.NG_USERS;
    private static DatasetImpl userDataset = SPARQL.copyDataset((Dataset)SPARQL.InternalGraphs);
    private final URI uri;
    private final String username;
    private String firstName = null;
    private String lastName = null;
    private String mbox = null;
    private Set<URI> roles = new HashSet();
    private Boolean newIsSuperuser = null;
    private boolean dirty = false;
    private static final URI EXPORT_AUTH_PASSWORD;
    private static final URI EXPORT_AUTH_TYPE;
    private static final URI EXPORT_AUTH_TYPE_BUILTIN;
    private static final String importUserGetAuthUsers;
    private static final String importUserGetStatements;
    private static final URI[] implicitRoles;
    private static final String userForURIQuery;

    public static Dataset getUserDataset() {
        return userDataset;
    }

    private User(URI uri, String username) {
        this.uri = uri;
        this.username = username;
        for (URI ruri : implicitRoles) {
            this.roles.add(ruri);
        }
    }

    public static User findByUsername(HttpServletRequest request, String pname) throws ServletException {
        return User.findOneUserInternal((HttpServletRequest)request, (String)pname, null);
    }

    public static User find(HttpServletRequest request, URI uri) throws ServletException {
        return User.findOneUserInternal((HttpServletRequest)request, null, (URI)uri);
    }

    private static User findOneUserInternal(HttpServletRequest request, String pname, URI uri) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            AuthUser au;
            log.debug((Object)("Single user SPARQL query = " + userForURIQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, userForURIQuery);
            q.setDataset((Dataset)userDataset);
            q.clearBindings();
            if (pname != null) {
                q.setBinding("hasPrincipalName", (Value)new LiteralImpl(pname));
            } else if (uri != null) {
                q.setBinding("uri", (Value)uri);
            } else {
                throw new ServletException("sanity check: findOneUserInternal called without either username OR uri");
            }
            q.setIncludeInferred(false);
            oneUserHandler h = new oneUserHandler(request);
            q.evaluate((TupleQueryResultHandler)h);
            log.debug((Object)("User.findByUsername(" + pname + ") => " + oneUserHandler.access$000((oneUserHandler)h)));
            if (oneUserHandler.access$000((oneUserHandler)h) != null && (au = AuthUser.find((String)pname)) != null && au.isSuperuser()) {
                oneUserHandler.access$000((oneUserHandler)h).roles.add(REPO.ROLE_SUPERUSER);
            }
            return oneUserHandler.access$000((oneUserHandler)h);
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public static Iterable<User> findAll(HttpServletRequest request) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ArrayList<User> result = new ArrayList<User>();
        try {
            log.debug((Object)("All user SPARQL query = " + userForURIQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, userForURIQuery);
            q.setDataset((Dataset)userDataset);
            q.setIncludeInferred(false);
            q.evaluate((TupleQueryResultHandler)new allUserHandler(request, result));
            Map authUsers = AuthUser.findAllAsMap();
            for (User ru : result) {
                AuthUser au = (AuthUser)authUsers.get(ru.username);
                if (au == null || !au.isSuperuser()) continue;
                ru.roles.add(REPO.ROLE_SUPERUSER);
            }
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        return result;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getMbox() {
        return this.mbox;
    }

    public String getTitle() {
        if (this.username != null) {
            String pn = this.getPersonalName();
            return pn.length() > 0 ? this.username + " (" + pn + ")" : this.username;
        }
        return this.uri.getLocalName();
    }

    public String getPersonalName() {
        return this.firstName == null ? (this.lastName == null ? "" : this.lastName) : (this.lastName == null ? this.firstName : this.firstName + " " + this.lastName);
    }

    private Role[] getRoles(HttpServletRequest request) throws ServletException {
        Role[] result = new Role[this.roles.size()];
        int i = 0;
        for (URI ru : this.roles) {
            result[i] = Role.find((HttpServletRequest)request, (URI)ru);
            ++i;
        }
        return result;
    }

    public boolean hasRoleP(Role r) {
        return this.roles.contains(r.getURI());
    }

    public boolean hasRoleP(URI ru) {
        return this.roles.contains(ru);
    }

    public boolean isSuperuser() {
        return this.hasRoleP(REPO.ROLE_SUPERUSER);
    }

    public void setIsSuperuser(boolean su) {
        if (su) {
            this.roles.add(REPO.ROLE_SUPERUSER);
        } else {
            this.roles.remove(REPO.ROLE_SUPERUSER);
        }
    }

    public void checkImplicitRoles(HttpServletRequest request) throws ServletException {
        for (URI ruri : implicitRoles) {
            if (this.hasRoleP(ruri)) continue;
            this.addRoleAsAdministrator(request, Role.find((HttpServletRequest)request, (URI)ruri));
        }
    }

    public static User create(HttpServletRequest request, String username) throws ServletException {
        return User.createInternal((HttpServletRequest)request, (String)username, (boolean)false);
    }

    public static User createAsAdministrator(HttpServletRequest request, String username) throws ServletException {
        return User.createInternal((HttpServletRequest)request, (String)username, (boolean)true);
    }

    private static User createInternal(HttpServletRequest request, String username, boolean skipAccessCheck) throws ServletException {
        if (!skipAccessCheck && !Access.hasPermissionOnUser((HttpServletRequest)request, (String)username)) {
            throw new ForbiddenException("Not allowed to create user: " + username);
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        User result = null;
        try {
            Literal lpname = vf.createLiteral(username);
            if (rc.hasStatement(null, REPO.HAS_PRINCIPAL_NAME, (Value)lpname, false, new Resource[]{REPO.NG_INTERNAL})) {
                throw new BadRequestException("Cannot create user: there is already a repository user with the login principal name (username) \"" + username + "\"");
            }
            result = new User(vf.createURI(DataRepository.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString()), username);
            rc.add((Resource)result.uri, RDF.TYPE, (Value)REPO.PERSON, new Resource[]{USER_GRAPH});
            rc.add((Resource)result.uri, RDFS.LABEL, (Value)lpname, new Resource[]{USER_GRAPH});
            rc.add((Resource)result.uri, REPO.HAS_PRINCIPAL_NAME, (Value)lpname, new Resource[]{REPO.NG_INTERNAL});
            for (URI ruri : implicitRoles) {
                rc.add((Resource)result.uri, REPO.HAS_ROLE, (Value)ruri, new Resource[]{REPO.NG_INTERNAL});
            }
            log.debug((Object)("create: created new User instance, username=" + username + ", uri=" + result.uri));
            result.dirty = true;
            return result;
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed creating user URI: ", (Throwable)e);
            throw new ServletException("Failed creating user URI: ", (Throwable)e);
        }
    }

    public void setFirstName(HttpServletRequest request, String name) throws ServletException {
        this.firstName = name;
        this.setMetadataInternal(request, FOAF.FIRST_NAME, name);
    }

    public void setLastName(HttpServletRequest request, String name) throws ServletException {
        this.lastName = name;
        this.setMetadataInternal(request, FOAF.SURNAME, name);
    }

    public void setMbox(HttpServletRequest request, String mbox) throws ServletException {
        this.mbox = mbox;
        this.setMetadataInternal(request, FOAF.MBOX, mbox);
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, String newVal) throws ServletException {
        if (!Access.hasPermissionOnUser((HttpServletRequest)request, (String)this.username)) {
            throw new ForbiddenException("Not allowed to modify user: " + this.username);
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            boolean hasProp = rc.hasStatement((Resource)this.uri, property, null, false, new Resource[]{USER_GRAPH});
            boolean hasLabel = rc.hasStatement((Resource)this.uri, RDFS.LABEL, null, false, new Resource[]{USER_GRAPH});
            ValueFactory vf = rc.getValueFactory();
            if (hasProp) {
                rc.remove((Resource)this.uri, property, null, new Resource[]{USER_GRAPH});
            }
            if (newVal != null) {
                rc.add((Resource)this.uri, property, (Value)vf.createLiteral(newVal), new Resource[]{USER_GRAPH});
            }
            String label = this.getTitle();
            log.debug((Object)("Setting User label, uri=" + this.uri + ", label=" + label));
            if (hasLabel) {
                rc.remove((Resource)this.uri, RDFS.LABEL, null, new Resource[]{USER_GRAPH});
            }
            rc.add((Resource)this.uri, RDFS.LABEL, (Value)vf.createLiteral(label), new Resource[]{USER_GRAPH});
            this.dirty = true;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void addRole(HttpServletRequest request, URI ru) throws ServletException {
        this.addRole(request, Role.find((HttpServletRequest)request, (URI)ru));
    }

    public void addRole(HttpServletRequest request, Role r) throws ServletException {
        this.addRoleInternal(request, r, false);
    }

    public void addRoleAsAdministrator(HttpServletRequest request, Role r) throws ServletException {
        this.addRoleInternal(request, r, true);
    }

    private void addRoleInternal(HttpServletRequest request, Role r, boolean skipAccessCheck) throws ServletException {
        if (!skipAccessCheck && !Access.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Only the administrator is allowed to modify user roles.");
        }
        if (this.hasRoleP(r)) {
            return;
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            if (this.roles.add(r.getURI())) {
                rc.add((Resource)this.uri, REPO.HAS_ROLE, (Value)r.getURI(), new Resource[]{REPO.NG_INTERNAL});
                if (r.isSuperuser()) {
                    this.newIsSuperuser = Boolean.TRUE;
                }
                this.dirty = true;
                log.debug((Object)("Added role: " + r));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed adding role ", (Throwable)e);
            throw new ServletException("Failed adding role ", (Throwable)e);
        }
    }

    public void removeRole(HttpServletRequest request, URI ru) throws ServletException {
        this.removeRole(request, Role.find((HttpServletRequest)request, (URI)ru));
    }

    public void removeRole(HttpServletRequest request, Role r) throws ServletException {
        if (!Access.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Only the administrator is allowed to modify user roles.");
        }
        if (!this.hasRoleP(r)) {
            return;
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            rc.remove((Resource)this.uri, REPO.HAS_ROLE, (Value)r.getURI(), new Resource[0]);
            this.roles.remove(r.getURI());
            if (r.isSuperuser()) {
                this.newIsSuperuser = Boolean.FALSE;
            }
            this.dirty = true;
            log.debug((Object)("Removed role: " + r));
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed adding role ", (Throwable)e);
            throw new ServletException("Failed removing role ", (Throwable)e);
        }
    }

    public boolean setRoles(HttpServletRequest request, Role[] newRoles) throws ServletException {
        ArrayList<Role> addRoles = new ArrayList<Role>();
        HashSet<Role> deleteRoles = new HashSet<Role>();
        for (Role r : this.getRoles(request)) {
            if (r.isImplicit()) continue;
            deleteRoles.add(r);
        }
        for (Role r : newRoles) {
            if (deleteRoles.contains(r)) {
                deleteRoles.remove(r);
                continue;
            }
            addRoles.add(r);
        }
        if (deleteRoles.isEmpty() && addRoles.isEmpty()) {
            return false;
        }
        for (Role r : deleteRoles) {
            this.removeRole(request, r);
        }
        for (Role r : addRoles) {
            this.addRole(request, r);
        }
        return true;
    }

    public void update(HttpServletRequest request) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            if (this.dirty) {
                AuthUser au;
                Access.decacheAuthentication((HttpServletRequest)request, (User)this);
                rc.commit();
                if (this.newIsSuperuser != null && (au = AuthUser.find((String)this.username)) != null) {
                    au.setIsSuperuser(this.newIsSuperuser.booleanValue());
                    log.debug((Object)("update(): Setting AuthUser isSuperuser = " + this.newIsSuperuser));
                    au.update();
                }
            }
            this.dirty = false;
        }
        catch (SQLException e) {
            log.error((Object)("Failed updating user, URI=" + this.uri), (Throwable)e);
            throw new ServletException("Failed updating user, URI=" + this.uri, (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)("Failed updating user, URI=" + this.uri), (Throwable)e);
            throw new ServletException("Failed updating user, URI=" + this.uri, (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error((Object)("Failed updating user, URI=" + this.uri), (Throwable)e);
            throw new ServletException("Failed updating user, URI=" + this.uri, (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.dirty) {
            log.error((Object)("finalize: about to destroy a User with dirty flag set, CHANGES WILL BE LOST.  Current state: " + this.toString()));
        }
        super.finalize();
    }

    public String toString() {
        String rs = this.roles == null ? "{null}" : Arrays.deepToString(this.roles.toArray(new URI[this.roles.size()]));
        String uu = this.uri == null ? "(not set)" : this.uri.toString();
        return "<#User: uri=" + uu + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", mbox=" + this.mbox + ", roles=" + rs + ">";
    }

    public boolean equals(Object o) {
        return o instanceof User && this.uri != null && this.uri.equals(((User)o).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doImportUsers(HttpServletRequest request, HttpServletResponse response, RepositoryConnection content, Set<String> includes, Set<String> excludes, ImportExport.DuplicateArg duplicate, boolean transform) throws ServletException, IOException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            try {
                TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, importUserGetAuthUsers);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SPARQL query PASS1 against internal memory repo = " + importUserGetAuthUsers));
                }
                q.setDataset(User.getUserDataset());
                q.setIncludeInferred(false);
                Connection c = AuthUser.startTransaction();
                authUserPass1Handler ah = new authUserPass1Handler(c, rc, transform, duplicate, includes, excludes);
                try {
                    q.evaluate((TupleQueryResultHandler)ah);
                    q = content.prepareTupleQuery(QueryLanguage.SPARQL, importUserGetStatements);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SPARQL query PASS2 against internal memory repo = " + importUserGetStatements));
                    }
                    q.setDataset(User.getUserDataset());
                    q.setIncludeInferred(false);
                    q.evaluate((TupleQueryResultHandler)new authUserPass2Handler(ah));
                    AuthUser.commitTransaction((Connection)c);
                    rc.commit();
                    c = null;
                }
                finally {
                    if (c != null) {
                        AuthUser.abortTransaction((Connection)c);
                        c = null;
                    }
                }
            }
            catch (HandlerBadRequest e) {
                throw new BadRequestException(e.getMessage());
            }
            catch (NamingException e) {
                log.error((Object)"Failed in IMPORT USER: ", (Throwable)e);
                throw new InternalServerErrorException((Throwable)e);
            }
            catch (SQLException e) {
                log.error((Object)"Failed in IMPORT USER: ", (Throwable)e);
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static void doExportUsers(HttpServletRequest request, HttpServletResponse response, RDFFormat format, Set<String> includes, Set<String> excludes) throws ServletException, IOException {
        try {
            RDFWriter realOut = Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            mergeHandler out = new mergeHandler((RDFHandler)realOut, null);
            realOut.startRDF();
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            Map authUsers = AuthUser.findAllAsMap();
            for (User u : User.findAll((HttpServletRequest)request)) {
                URI uu = u.getURI();
                String uus = uu.toString();
                String un = u.getUsername();
                AuthUser au = (AuthUser)authUsers.remove(un);
                if (excludes.contains(un) || excludes.contains(uus)) {
                    log.debug((Object)("SKIP USER because of exclude: " + u));
                    continue;
                }
                if (includes.isEmpty() || includes.contains(un) || includes.contains(uus)) {
                    log.debug((Object)("EXPORT USER: " + uu));
                    rc.exportStatements((Resource)uu, null, null, false, (RDFHandler)out, new Resource[]{REPO.NG_USERS, REPO.NG_INTERNAL});
                    if (au == null) {
                        log.warn((Object)("User is NOT IN RDBMS, so no password: username=" + un));
                        continue;
                    }
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)uu, EXPORT_AUTH_TYPE, (Value)EXPORT_AUTH_TYPE_BUILTIN, (Resource)REPO.NG_INTERNAL));
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)uu, EXPORT_AUTH_PASSWORD, (Value)new LiteralImpl(au.getPassword(), XMLSchema.STRING), (Resource)REPO.NG_INTERNAL));
                    continue;
                }
                log.debug((Object)("SKIP USER because of include: " + u));
            }
            for (AuthUser au : authUsers.values()) {
                String un = au.getUsername();
                if (excludes.contains(un)) {
                    log.debug((Object)("SKIP UNDOCUMENTED USER because of exclude: \"" + un + "\""));
                    continue;
                }
                if (includes.isEmpty() || includes.contains(un)) {
                    log.debug((Object)("EXPORT UNDOCUMENTED USER: \"" + un + "\""));
                    BNode subject = vf.createBNode();
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, EXPORT_AUTH_TYPE, (Value)EXPORT_AUTH_TYPE_BUILTIN, (Resource)REPO.NG_INTERNAL));
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, REPO.HAS_PRINCIPAL_NAME, (Value)new LiteralImpl(au.getUsername(), XMLSchema.STRING), (Resource)REPO.NG_INTERNAL));
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, EXPORT_AUTH_PASSWORD, (Value)new LiteralImpl(au.getPassword(), XMLSchema.STRING), (Resource)REPO.NG_INTERNAL));
                    continue;
                }
                log.debug((Object)("SKIP UNDOCUMENTED USER because of include: \"" + un + "\""));
            }
            realOut.endRDF();
        }
        catch (NamingException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (SQLException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ String access$302(User x0, String x1) {
        x0.firstName = x1;
        return x0.firstName;
    }

    static /* synthetic */ String access$402(User x0, String x1) {
        x0.lastName = x1;
        return x0.lastName;
    }

    static /* synthetic */ String access$502(User x0, String x1) {
        x0.mbox = x1;
        return x0.mbox;
    }

    static /* synthetic */ String access$600(User x0) {
        return x0.username;
    }

    static /* synthetic */ Set access$700(User x0) {
        return x0.roles;
    }

    static /* synthetic */ URI[] access$1400() {
        return implicitRoles;
    }

    static {
        SPARQL.addGraph((DatasetImpl)userDataset, (URI)USER_GRAPH);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User Dataset = " + Utils.prettyPrint((Dataset)userDataset)));
        }
        EXPORT_AUTH_PASSWORD = new URIImpl("http://eagle-i.org/ont/repo/1.0/exportAuthPassword");
        EXPORT_AUTH_TYPE = new URIImpl("http://eagle-i.org/ont/repo/1.0/exportAuthType");
        EXPORT_AUTH_TYPE_BUILTIN = new URIImpl("http://eagle-i.org/ont/repo/1.0/exportAuthType_Builtin");
        importUserGetAuthUsers = "SELECT * WHERE { \nGRAPH <" + REPO.NG_INTERNAL + "> { " + " ?authUser <" + EXPORT_AUTH_TYPE + "> <" + EXPORT_AUTH_TYPE_BUILTIN + ">; " + " <" + REPO.HAS_PRINCIPAL_NAME + "> ?username; " + " <" + EXPORT_AUTH_PASSWORD + "> ?password " + " OPTIONAL { ?authUser <" + REPO.HAS_ROLE + "> ?su " + "   FILTER(?su = <" + REPO.ROLE_SUPERUSER + ">)}}}";
        importUserGetStatements = "SELECT ?g ?s ?p ?v ?username WHERE { \nGRAPH <" + REPO.NG_USERS + "> { ?s a <" + REPO.PERSON + "> }\n" + "OPTIONAL { GRAPH <" + REPO.NG_INTERNAL + "> { " + "    ?s <" + REPO.HAS_PRINCIPAL_NAME + "> ?username}}\n" + "GRAPH ?g {?s ?p ?v \n" + "  FILTER((?g = <" + REPO.NG_INTERNAL + "> && isURI(?s) &&\n" + "         (?p = <" + REPO.HAS_ROLE + "> || ?p = <" + REPO.HAS_PRINCIPAL_NAME + ">)) ||\n" + "        (?g = <" + REPO.NG_USERS + ">))}}";
        implicitRoles = new URI[]{REPO.ROLE_AUTHENTICATED, REPO.ROLE_ANONYMOUS};
        userForURIQuery = "SELECT * WHERE { ?uri a <" + REPO.PERSON + "> ; \n" + "<" + REPO.HAS_PRINCIPAL_NAME + "> ?hasPrincipalName .\n" + "  OPTIONAL { ?uri <" + FOAF.FIRST_NAME + "> ?firstName }\n" + "  OPTIONAL { ?uri <" + FOAF.SURNAME + "> ?surname }\n" + "  OPTIONAL { ?uri <" + FOAF.MBOX + "> ?mbox }\n" + "  OPTIONAL { ?uri <" + REPO.HAS_ROLE + "> ?hasRole . ?hasRole <" + RDFS.LABEL + "> ?roleLabel }\n" + " } ORDER BY ?hasPrincipalName";
    }
}

