/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.View;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public enum View {
    ALL("all"),
    METADATA("metadata"),
    METADATA_ONTOLOGY("metadata+ontology"),
    ONTOLOGY("ontology"),
    PUBLIC("public"),
    PUBLISHED("published"),
    PUBLISHED_RESOURCES("published-resources"),
    USER("user"),
    USER_RESOURCES("user-resources"),
    NULL("null");

    private String label = null;
    private static DatasetImpl viewDataset;
    private static Logger log;
    private static final String wksQuery;

    private View(String l) {
        this.label = l;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTitle() {
        return String.format("%C%s", Character.valueOf(this.label.charAt(0)), this.label.substring(1));
    }

    public static View parseView(String v) {
        for (View result : View.values()) {
            if (!result.label.equals(v)) continue;
            return result;
        }
        return null;
    }

    public static void addGraphs(HttpServletRequest request, DatasetImpl ds, View vw) {
        boolean filterByPermission = false;
        boolean filterByPublic = false;
        boolean addInferred = false;
        StringBuilder pattern = new StringBuilder("{ ?name <").append(RDF.TYPE).append("> <").append(REPO.NAMED_GRAPH).append("> ");
        switch (1.$SwitchMap$org$eaglei$repository$View[vw.ordinal()]) {
            case 1: {
                pattern.append("; <").append(REPO.NG_TYPE).append("> <").append(REPO.NGTYPE_METADATA).append(">");
                filterByPermission = true;
                break;
            }
            case 2: {
                pattern.append("; <").append(REPO.NG_TYPE).append("> <").append(REPO.NGTYPE_ONTOLOGY).append(">");
                filterByPermission = true;
                break;
            }
            case 3: {
                pattern.append("; <").append(REPO.NG_TYPE).append("> ?ngt . ").append("filter(?ngt = <").append(REPO.NGTYPE_ONTOLOGY).append("> || ").append(" ?ngt = <").append(REPO.NGTYPE_METADATA).append(">) ");
                filterByPermission = true;
                break;
            }
            case 4: {
                filterByPermission = true;
                addInferred = true;
                break;
            }
            case 5: {
                pattern.append("; <").append(REPO.NG_TYPE).append("> ?ngt . ").append("filter(?name != <").append(REPO.NG_USERS).append("> && ").append("(?ngt = <").append(REPO.NGTYPE_WORKSPACE).append("> || ").append("?ngt = <").append(REPO.NGTYPE_PUBLISHED).append("> || ").append("?ngt = <").append(REPO.NGTYPE_ONTOLOGY).append("> || ").append("?ngt = <").append(REPO.NGTYPE_METADATA).append(">)) ");
                filterByPermission = true;
                addInferred = true;
                break;
            }
            case 6: {
                pattern.append("; <").append(REPO.NG_TYPE).append("> ?ngt . ").append("filter( ?ngt = <").append(REPO.NGTYPE_ONTOLOGY).append("> || ").append("?ngt = <").append(REPO.NGTYPE_METADATA).append("> || ").append("?ngt = <").append(REPO.NGTYPE_PUBLISHED).append("> )");
                filterByPermission = true;
                addInferred = true;
                break;
            }
            case 7: {
                pattern.append("; <").append(REPO.NG_TYPE).append("> ?ngt . ").append("filter(?name != <").append(REPO.NG_USERS).append("> && ").append("(?ngt = <").append(REPO.NGTYPE_ONTOLOGY).append("> || ").append(" ?ngt = <").append(REPO.NGTYPE_METADATA).append("> || ").append(" ?ngt = <").append(REPO.NGTYPE_PUBLISHED).append("> ))");
                filterByPermission = true;
                addInferred = true;
                break;
            }
            case 8: {
                filterByPublic = true;
                addInferred = true;
                break;
            }
            case 9: {
                if (Access.isSuperuser((HttpServletRequest)request)) break;
                throw new ForbiddenException("This view is only available to administrators.");
            }
            case 10: {
                if (!Access.isSuperuser((HttpServletRequest)request)) {
                    throw new ForbiddenException("This view is only available to administrators.");
                }
                ds.addDefaultGraph(null);
                return;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented view: " + vw);
            }
        }
        pattern.append(" . }");
        String groupString = pattern.toString();
        if (filterByPublic) {
            log.debug((Object)("SPARQL query pattern group to get public (view=" + vw + ") graphs = " + groupString));
            Access.filterByPermission((HttpServletRequest)request, (URI)REPO.ROLE_ANONYMOUS, (String)"name", (String)"?name", (String)groupString, (Access)Access.READ, (Dataset)viewDataset, null, (TupleQueryResultHandler)new datasetHandler("name", ds));
        } else if (filterByPermission && !Access.isSuperuser((HttpServletRequest)request)) {
            log.debug((Object)("SPARQL query pattern group to get " + vw + " graphs = " + groupString));
            Access.filterByPermission((HttpServletRequest)request, null, (String)"name", (String)"?name", (String)groupString, (Access)Access.READ, (Dataset)viewDataset, null, (TupleQueryResultHandler)new datasetHandler("name", ds));
        } else {
            try {
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                String queryString = "SELECT ?name WHERE " + groupString;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SPARQL query to get " + vw + " graphs =\n" + queryString));
                }
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
                q.setIncludeInferred(true);
                q.setDataset((Dataset)SPARQL.InternalGraphs);
                q.evaluate((TupleQueryResultHandler)new datasetHandler("name", ds));
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new InternalServerErrorException("Failed in query to generate view: ", (Throwable)e);
            }
        }
        if (addInferred && !ds.getDefaultGraphs().isEmpty()) {
            SPARQL.addGraph((DatasetImpl)ds, (URI)REPO.NG_INFERRED);
        }
    }

    public static void addWorkspaceGraphs(HttpServletRequest request, DatasetImpl ds, URI graphName) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (rc.hasStatement((Resource)graphName, REPO.NG_TYPE, (Value)REPO.NGTYPE_PUBLISHED, false, new Resource[0]) || rc.hasStatement((Resource)graphName, REPO.NG_TYPE, (Value)REPO.NGTYPE_WORKSPACE, false, new Resource[0])) {
                log.debug((Object)("Adding Workspace graphs for WS graph=" + graphName));
                if (!Access.hasPermission((HttpServletRequest)request, (Resource)graphName, (Access)Access.READ)) {
                    throw new ForbiddenException("User does not have permission to read this workspace.");
                }
            } else {
                throw new BadRequestException("Not a workspace graph: " + graphName);
            }
            SPARQL.addGraph((DatasetImpl)ds, (URI)graphName);
            View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)METADATA_ONTOLOGY);
            SPARQL.addGraph((DatasetImpl)ds, (URI)REPO.NG_USERS);
            SPARQL.addGraph((DatasetImpl)ds, (URI)REPO.NG_INFERRED);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in query to generate view: ", (Throwable)e);
        }
    }

    public static Map<String, URI> getAllWorkspaceGraphs(HttpServletRequest request) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            log.debug((Object)("SPARQL query to get ALL WORKSPACE graphs =\n" + wksQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, wksQuery);
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            workspaceHandler h = new workspaceHandler();
            q.evaluate((TupleQueryResultHandler)h);
            return workspaceHandler.access$000((workspaceHandler)h);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in query to get all workspaces: ", (Throwable)e);
        }
    }

    static {
        viewDataset = SPARQL.copyDataset((Dataset)SPARQL.InternalGraphs);
        viewDataset.addDefaultGraph(REPO.NG_USERS);
        log = LogManager.getLogger(View.class);
        wksQuery = "SELECT * WHERE { ?name a <" + REPO.NAMED_GRAPH + "> . \n" + " {{ ?name <" + REPO.NG_TYPE + "> <" + REPO.NGTYPE_PUBLISHED + "> } UNION \n" + "  { ?name <" + REPO.NG_TYPE + "> <" + REPO.NGTYPE_WORKSPACE + "> }} \n" + " OPTIONAL { ?name <" + RDFS.LABEL + "> ?label }}";
    }
}

