/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.format;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.DataRepository;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class SPARQLHTMLWriter
implements TupleQueryResultWriter {
    private static Logger log = LogManager.getLogger(SPARQLHTMLWriter.class);
    private static final String[] mimeTypes = new String[]{"text/html", "application/xhtml+xml"};
    private static final String[] fileExts = new String[]{".html"};
    public static final TupleQueryResultFormat theFormat = new TupleQueryResultFormat("Plain Old HTML", Arrays.asList(mimeTypes), Charset.defaultCharset(), Arrays.asList(fileExts));
    private PrintStream out = null;
    private static final String localPrefix = DataRepository.getInstance().getDefaultNamespace();
    public static final String Prologue = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\"><head>  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />  <title>SPARQL Query Results</title> <link rel=\"stylesheet\" type=\"text/css\" href=\"/repository/styles/sparql.css\" /> <script type=\"text/javascript\">\r\n     var firstSheet = document.styleSheets[0]\r\n     var tuRule = null; \r\n     // Firefox/NS has cssRules, MSIE has rules \r\n     if (firstSheet.cssRules) { \r\n         firstSheet.insertRule('.typeURI { display: none; }', 0); \r\n         tuRule = firstSheet.cssRules[0]; \r\n     } else { \r\n         firstSheet.addRule('.typeURI', 'display: none', 0); \r\n         tuRule = firstSheet.rules[0]; \r\n     } \r\n </script> \r\n</head><body> \r\n<button type=\"button\" onClick=\" if (tuRule.style.display == 'none') { \r\n     tuRule.style.display = 'inline';  \r\n     textContent = 'Less Detail';            \r\n } else {                              \r\n     tuRule.style.display = 'none'     \r\n     textContent = 'More Detail';            \r\n } \">More Detail</button> \r\n<div><table>\r\n";
    public static final String Postlogue = "</table></div></body></html>\r\n";
    private List<String> columns = null;

    public SPARQLHTMLWriter(OutputStream out) {
        try {
            this.out = new PrintStream(out, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Failed opening PrintStream: ", (Throwable)e);
        }
    }

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return theFormat;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\"><head>  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />  <title>SPARQL Query Results</title> <link rel=\"stylesheet\" type=\"text/css\" href=\"/repository/styles/sparql.css\" /> <script type=\"text/javascript\">\r\n     var firstSheet = document.styleSheets[0]\r\n     var tuRule = null; \r\n     // Firefox/NS has cssRules, MSIE has rules \r\n     if (firstSheet.cssRules) { \r\n         firstSheet.insertRule('.typeURI { display: none; }', 0); \r\n         tuRule = firstSheet.cssRules[0]; \r\n     } else { \r\n         firstSheet.addRule('.typeURI', 'display: none', 0); \r\n         tuRule = firstSheet.rules[0]; \r\n     } \r\n </script> \r\n</head><body> \r\n<button type=\"button\" onClick=\" if (tuRule.style.display == 'none') { \r\n     tuRule.style.display = 'inline';  \r\n     textContent = 'Less Detail';            \r\n } else {                              \r\n     tuRule.style.display = 'none'     \r\n     textContent = 'More Detail';            \r\n } \">More Detail</button> \r\n<div><table>\r\n");
        this.out.print("<tr>");
        this.columns = bindingNames;
        for (String bn : bindingNames) {
            this.out.print("<th>" + StringEscapeUtils.escapeHtml((String)bn) + "</th>");
        }
        this.out.println("</tr>");
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        this.out.println("</table></div></body></html>\r\n");
    }

    public void handleSolution(BindingSet bs) throws TupleQueryResultHandlerException {
        try {
            this.out.println("<tr>");
            for (String bn : this.columns) {
                this.out.print("<td>");
                SPARQLHTMLWriter.printValue((Appendable)this.out, bs.hasBinding(bn) ? bs.getValue(bn) : null);
                this.out.println("</td>");
            }
            this.out.println("</tr>");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public static void printValue(Appendable out, Value v) throws IOException {
        if (v == null) {
            out.append("&nbsp;");
        } else if (v instanceof URI) {
            out.append(SPARQLHTMLWriter.renderLinkedURI((URI)((URI)v)));
        } else if (v instanceof Literal) {
            URI dt = ((Literal)v).getDatatype();
            String label = ((Literal)v).getLabel();
            if (XMLSchema.ANYURI.equals(dt)) {
                out.append("<a href=\"" + label + "\">" + StringEscapeUtils.escapeHtml((String)label) + "</a>");
            } else {
                out.append("<span>\"");
                String ls = StringEscapeUtils.escapeHtml((String)label);
                Matcher m = Pattern.compile("[\n\r]").matcher(ls);
                int lastEnd = 0;
                while (m.find()) {
                    char c;
                    int len1 = m.start() - lastEnd;
                    if (len1 > 0) {
                        out.append(ls, lastEnd, lastEnd + len1);
                    }
                    if ((c = ls.charAt(m.start())) == '\n') {
                        out.append("<br/>\n");
                    }
                    lastEnd = m.end();
                }
                if (lastEnd < ls.length()) {
                    out.append(ls, lastEnd, ls.length());
                }
                out.append("\"</span>");
                if (dt != null) {
                    out.append("<span class=\"typeURI\">^^&lt;" + StringEscapeUtils.escapeHtml((String)dt.stringValue()) + "&gt;</span>");
                }
            }
        } else {
            out.append(StringEscapeUtils.escapeHtml((String)v.toString()));
        }
    }

    protected static String renderLinkedURI(URI uri) {
        if (uri.getNamespace().equals(localPrefix)) {
            return "<a href=\"" + uri + "\">" + StringEscapeUtils.escapeHtml((String)uri.toString()) + "</a>";
        }
        return StringEscapeUtils.escapeHtml((String)uri.toString());
    }
}

