/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.View;
import org.eaglei.repository.servlet.EmailContact;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DATAMODEL;
import org.openrdf.OpenRDFException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmailContact
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(EmailContact.class);
    private static final String CONFIG_POSTMASTER = "eaglei.repository.postmaster";
    private static final String CONFIG_MTA_HOST = "eaglei.repository.mail.host";
    private static final String CONFIG_MTA_PORT = "eaglei.repository.mail.port";
    private static final String CONFIG_MTA_SSL = "eaglei.repository.mail.ssl";
    private static final String CONFIG_MTA_USERNAME = "eaglei.repository.mail.username";
    private static final String CONFIG_MTA_PASSWORD = "eaglei.repository.mail.password";
    private static final String emailQuery = "SELECT ?label ?type ?email WHERE { ?uri <" + RDF.TYPE + "> ?type; <" + RDFS.LABEL + "> ?label . \n" + "  OPTIONAL { ?uri ?p ?email . ?p <" + DATAMODEL.IN_PROPERTY_GROUP + "> <" + DATAMODEL.PROPERTY_GROUP_EMAIL_CONTACT + "> }}";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean testMode;
        URI uri = Utils.parseURI((String)request.getParameter("uri"), (String)"uri", (boolean)true);
        String clientIP = request.getParameter("client_ip");
        String fromName = request.getParameter("from_name");
        String fromEmail = request.getParameter("from_email");
        String subject = request.getParameter("subject");
        String message = request.getParameter("message");
        boolean bl = testMode = request.getParameter("test_mode") != null;
        if (clientIP == null || clientIP.trim().length() == 0) {
            throw new BadRequestException("No value for the required arg 'client_ip'.");
        }
        if (fromName == null || fromName.trim().length() == 0) {
            throw new BadRequestException("No value for the required arg 'from_name'.");
        }
        if (fromEmail == null || fromEmail.trim().length() == 0) {
            throw new BadRequestException("No value for the required arg 'from_email'.");
        }
        int at = fromEmail.indexOf(64);
        if (at < 0 || fromEmail.indexOf(46, at) < 0) {
            throw new BadRequestException("Bad value for the required arg 'from_email', must be a valid email address.");
        }
        DataRepository dr = DataRepository.getInstance();
        String postmaster = dr.getConfigurationProperty("eaglei.repository.postmaster");
        String mtaHost = dr.getConfigurationProperty("eaglei.repository.mail.host", "localhost");
        String mtaPort = dr.getConfigurationProperty("eaglei.repository.mail.port");
        String mtaUsername = dr.getConfigurationProperty("eaglei.repository.mail.username");
        String mtaPassword = dr.getConfigurationProperty("eaglei.repository.mail.password");
        boolean mtaSSL = Boolean.parseBoolean(dr.getConfigurationProperty("eaglei.repository.mail.ssl"));
        if (postmaster == null) {
            throw new InternalServerErrorException("Repository configuration is missing the required property: eaglei.repository.postmaster");
        }
        String referrer = request.getHeader("Referer");
        if (referrer == null) {
            throw new BadRequestException("This service may only be called from another page (to set the referer).");
        }
        URL backLink = new URL(referrer);
        log.debug((Object)("Got Referer = " + referrer));
        try {
            String sendTo;
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            emailHandler eh = EmailContact.doQuery((HttpServletRequest)request, (RepositoryConnection)rc, (URI)uri);
            if (emailHandler.access$000((emailHandler)eh) == null) {
                throw new NotFoundException("Resource instance not found in this repository: " + uri);
            }
            String myHost = request.getServerName();
            StringBuilder body = new StringBuilder();
            body.append("This message was generated by the eagle-i server on ").append(myHost).append("\n");
            body.append("An eagle-i visitor, ").append(fromName).append(", wishes to contact the owner of this resource:\n").append("  Label: ").append(emailHandler.access$100((emailHandler)eh) == null ? "" : emailHandler.access$100((emailHandler)eh)).append("\n    URI: ").append(uri.stringValue()).append("\n");
            body.append("\nClient remote IP address = ").append(clientIP).append("\n");
            body.append("\nMessage from ").append(fromName).append(":\n--------------------------------------------------\n").append(message == null ? "(no message)" : message);
            body.append("\n--------------------------------------------------\n");
            SimpleEmail msg = new SimpleEmail();
            msg.setCharset("UTF-8");
            msg.setMsg(body.toString());
            msg.setFrom(fromEmail, fromName);
            msg.addReplyTo(fromEmail, fromName);
            msg.setBounceAddress(postmaster);
            String string = sendTo = emailHandler.access$200((emailHandler)eh) == null ? postmaster : emailHandler.access$200((emailHandler)eh);
            if (testMode) {
                msg.addHeader("X-TESTING-Would-Have-Gone-To", sendTo);
                msg.addTo(postmaster, "Repository Postmaster");
            } else {
                msg.addTo(sendTo);
            }
            msg.setSubject(subject == null ? "Inquiry from eagle-i" : subject);
            msg.setHostName(mtaHost);
            if (mtaSSL) {
                msg.setSSL(true);
                if (mtaUsername != null && mtaPassword == null || mtaUsername == null && mtaPassword != null) {
                    throw new InternalServerErrorException("Bad configuraiton, must have BOTH username and password for mail server.");
                }
                if (mtaUsername != null && mtaPassword != null) {
                    msg.setAuthentication(mtaUsername, mtaPassword);
                }
                if (mtaPort != null) {
                    msg.setSslSmtpPort(mtaPort);
                }
            } else if (mtaPort != null) {
                try {
                    int p = Integer.parseInt(mtaPort);
                    msg.setSmtpPort(p);
                }
                catch (NumberFormatException e) {
                    throw new BadRequestException(e.toString());
                }
            }
            if (log.isDebugEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                msg.buildMimeMessage();
                MimeMessage mm = msg.getMimeMessage();
                if (mm == null) {
                    log.error((Object)"Failed getMimeMessage!");
                } else {
                    mm.writeTo((OutputStream)baos);
                    log.debug((Object)("Msg = " + baos.toString()));
                }
            }
            msg.send();
            String redir = backLink.getProtocol() + "://" + backLink.getHost() + (backLink.getPort() < 0 ? "" : ":" + String.valueOf(backLink.getPort())) + backLink.getPath() + "?sent=true&uri=" + URLEncoder.encode(uri.stringValue(), Charset.defaultCharset().name()) + "&test_mode=" + String.valueOf(testMode);
            log.debug((Object)("Redirecting to: " + redir));
            response.sendRedirect(redir);
        }
        catch (MessagingException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (EmailException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    private static emailHandler doQuery(HttpServletRequest request, RepositoryConnection rc, URI uri) throws OpenRDFException {
        DatasetImpl ds = new DatasetImpl();
        View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)View.USER_RESOURCES);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dataset for SPARQL query = " + Utils.prettyPrint((Dataset)ds)));
            log.debug((Object)("EMAIL QUERY = \n" + emailQuery));
        }
        TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, emailQuery);
        q.setDataset((Dataset)ds);
        q.setIncludeInferred(false);
        q.clearBindings();
        q.setBinding("uri", (Value)uri);
        emailHandler eh = new emailHandler();
        q.evaluate((TupleQueryResultHandler)eh);
        return eh;
    }

    public static String getContactEmail(HttpServletRequest request, RepositoryConnection rc, URI uri) throws OpenRDFException {
        return emailHandler.access$200((emailHandler)EmailContact.doQuery((HttpServletRequest)request, (RepositoryConnection)rc, (URI)uri));
    }
}

