/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.Formats;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.inferencer.TBoxInferencer;
import org.eaglei.repository.servlet.Graph;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.util.RDFRemover;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public class Graph
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Graph.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = null;
        String action = null;
        String format = null;
        String contentType = null;
        String remoteURI = null;
        String source = null;
        String sourceModified = null;
        String label = null;
        String type = null;
        InputStream content = null;
        String contentString = null;
        boolean all = false;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir")));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("name")) {
                        name = item.getString();
                        continue;
                    }
                    if (ifn.equals("all")) {
                        all = true;
                        continue;
                    }
                    if (ifn.equals("action")) {
                        action = item.getString();
                        continue;
                    }
                    if (ifn.equals("format")) {
                        format = item.getString();
                        continue;
                    }
                    if (ifn.equals("type")) {
                        type = item.getString();
                        continue;
                    }
                    if (ifn.equals("label")) {
                        label = item.getString();
                        continue;
                    }
                    if (ifn.equals("uri")) {
                        remoteURI = item.getString();
                        continue;
                    }
                    if (ifn.equals("content")) {
                        FileItemHeaders hd;
                        content = item.getInputStream();
                        contentType = item.getContentType();
                        if (source == null) {
                            source = item.getName();
                        }
                        if ((hd = item.getHeaders()) != null && sourceModified == null) {
                            sourceModified = hd.getHeader("Last-Modified");
                        }
                        log.debug((Object)("Got content stream, MIME type = " + contentType));
                        continue;
                    }
                    if (ifn.equals("source")) {
                        source = item.getString();
                        continue;
                    }
                    if (ifn.equals("sourceModified")) {
                        sourceModified = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request");
            }
        } else {
            request.setCharacterEncoding("UTF-8");
            name = request.getParameter("name");
            all = request.getParameter("all") != null;
            action = request.getParameter("action");
            format = request.getParameter("format");
            type = request.getParameter("type");
            label = request.getParameter("label");
            remoteURI = request.getParameter("uri");
            contentString = request.getParameter("content");
            source = request.getParameter("source");
            sourceModified = request.getParameter("sourceModified");
        }
        if (format == null || format.length() == 0) {
            format = contentType;
        }
        this.putGraphInternal(request, response, name, all, action, format, remoteURI, content, contentString, source, sourceModified, type, label);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        String action = request.getParameter("action");
        String format = request.getParameter("format");
        if (format == null || format.length() == 0) {
            format = request.getContentType();
        }
        String remoteURI = request.getParameter("uri");
        boolean all = request.getParameter("all") != null;
        String source = request.getParameter("source");
        String type = request.getParameter("type");
        String label = request.getParameter("label");
        String sourceModified = request.getParameter("sourceModified");
        if (sourceModified == null) {
            sourceModified = request.getHeader("Last-Modified");
        }
        this.putGraphInternal(request, response, name, all, action, format, remoteURI, (InputStream)request.getInputStream(), null, source, sourceModified, type, label);
    }

    private void putGraphInternal(HttpServletRequest request, HttpServletResponse response, String name, boolean all, String rawAction, String rawFormat, String remoteURI, InputStream contentStream, String contentString, String source, String sourceModified, String type, String label) throws ServletException, IOException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        Action action = null;
        if (rawAction == null) {
            throw new BadRequestException("Missing required argument: action");
        }
        try {
            action = Action.valueOf((String)rawAction);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Illegal value for 'action', must be one of: " + Arrays.deepToString(Action.values()));
        }
        log.debug((Object)("Argument action = " + action));
        if (rawFormat == null) {
            throw new BadRequestException("Missing required argument: format (or content-type)");
        }
        if (all && name != null) {
            throw new BadRequestException("You may not specify both a named graph and the 'all' keyword");
        }
        if (!all && name == null) {
            throw new BadRequestException("Missing required argument: name");
        }
        URI graphName = null;
        if (name != null) {
            try {
                graphName = vf.createURI(name);
                log.debug((Object)("Argument graph name = " + graphName));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Graph name URI was badly formed: " + e.toString());
            }
        }
        if (remoteURI == null && contentStream == null && contentString == null) {
            throw new BadRequestException("No input source, either remote URI or content must be specified");
        }
        if (remoteURI != null) {
            throw new HttpStatusException(501, "Not accepting graphs from remote URLs yet.");
        }
        URI ngType = null;
        if (!all && type != null) {
            NamedGraph.Type t = NamedGraph.Type.parse((String)type);
            if (t == null) {
                throw new BadRequestException("Named graph type \"" + type + "\" does not match any of the defined types: " + Arrays.deepToString(NamedGraph.Type.values()));
            }
            ngType = t.getURI();
        }
        Reader content = null;
        if (contentStream != null) {
            try {
                String csn = Utils.contentTypeGetCharset((String)rawFormat, (String)"UTF-8");
                log.debug((Object)("Reading serialized RDF from stream with format=" + rawFormat + ", charset=" + csn));
                content = new InputStreamReader(contentStream, Charset.forName(csn));
            }
            catch (IllegalCharsetNameException e) {
                throw new BadRequestException("Illegal character set name in content-type spec: " + e);
            }
            catch (UnsupportedCharsetException e) {
                throw new BadRequestException("Unsupported character set name in content-type spec: " + e);
            }
        } else if (contentString != null) {
            content = new StringReader(contentString);
        } else {
            throw new BadRequestException("Missing value for required arg 'content'");
        }
        String mime = Utils.contentTypeGetMIMEType((String)rawFormat);
        RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)mime);
        if (format == null) {
            throw new HttpStatusException(415, "MIME type of serialized RDF is not supported: \"" + mime + "\"");
        }
        log.debug((Object)("RDF format derived from arg (" + rawFormat + ") = " + format));
        if (all && !format.supportsContexts()) {
            throw new BadRequestException("'All' may not be specified with a format that does not support quads");
        }
        if (all && Access.isSuperuser((HttpServletRequest)request) || graphName != null && (action != Action.add && action != Action.replace || Access.hasPermission((HttpServletRequest)request, (Resource)graphName, (Access)Access.ADD)) && (action != Action.delete && action != Action.replace || Access.hasPermission((HttpServletRequest)request, (Resource)graphName, (Access)Access.REMOVE))) {
            try {
                boolean created;
                boolean bl = created = action == Action.replace || action == Action.add && !all && rc.size(new Resource[]{graphName}) == 0L;
                if (action == Action.add || action == Action.replace) {
                    long before;
                    if (action == Action.replace) {
                        if (all) {
                            rc.clear(new Resource[0]);
                        } else {
                            rc.clear(new Resource[]{graphName});
                        }
                    }
                    if (all) {
                        before = rc.size(new Resource[0]);
                        rc.add(content, "", format, new Resource[0]);
                        log.info((Object)("Added " + String.valueOf(rc.size(new Resource[0]) - before) + " statements to all graphs."));
                        DataRepository.getInstance().notifyDataReplaced();
                    } else {
                        before = rc.size(new Resource[]{graphName});
                        rc.add(content, "", format, new Resource[]{graphName});
                        log.info((Object)("Added " + String.valueOf(rc.size(new Resource[]{graphName}) - before) + " statements to graph:" + graphName.toString()));
                    }
                    if (!all && !rc.hasStatement((Resource)graphName, RDF.TYPE, (Value)REPO.NAMED_GRAPH, true, new Resource[0])) {
                        rc.add((Resource)graphName, RDF.TYPE, (Value)REPO.NAMED_GRAPH, new Resource[]{REPO.NG_INTERNAL});
                        log.debug((Object)("Declaring rdf:type of named graph URI = " + graphName));
                    }
                    if (!(all || ngType == null && label == null)) {
                        NamedGraph ng = NamedGraph.find((HttpServletRequest)request, (URI)graphName);
                        if (ngType != null) {
                            ng.setType(request, ngType);
                        }
                        if (label != null) {
                            ng.setLabel(request, label);
                        }
                    }
                } else if (action == Action.delete) {
                    long before = rc.size(new Resource[]{graphName});
                    RDFParser parser = Rio.createParser((RDFFormat)format, (ValueFactory)vf);
                    RDFRemover rr = new RDFRemover(rc);
                    if (!all) {
                        rr.enforceContext((Resource)graphName);
                    }
                    parser.setRDFHandler((RDFHandler)rr);
                    parser.parse(content, "");
                    log.info((Object)("Deleted " + String.valueOf(before - rc.size(new Resource[]{graphName})) + " statements to graph:" + graphName.toString()));
                }
                if (!all) {
                    Date now = new Date();
                    Provenance p = new Provenance(graphName);
                    if (created) {
                        p.setCreated(request, now);
                    }
                    p.setModified(request, now);
                    if (source != null) {
                        Date smDate = null;
                        if (sourceModified != null) {
                            smDate = Utils.parseXMLDate((String)sourceModified).toGregorianCalendar().getTime();
                            log.debug((Object)("Got sourceModified date, parsed date = " + smDate));
                        }
                        p.setSource(request, source, smDate);
                    }
                }
                rc.commit();
                response.setStatus(created ? 201 : 200);
            }
            catch (OpenRDFException e) {
                log.error((Object)"Failed parsing user-supplied graph content: ", (Throwable)e);
                throw new BadRequestException((Throwable)e);
            }
        } else {
            throw new ForbiddenException("User is not permitted to " + action + " this graph");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block21: {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            String mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)request.getParameter("format"));
            RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)mimeType);
            if (format == null) {
                throw new BadRequestException("Unrecognized MIME type for serialized RDF format: \"" + mimeType + "\"");
            }
            log.debug((Object)("Negotiated output format = " + format));
            boolean force = request.getParameter("force") != null;
            boolean inferred = request.getParameter("inferred") != null;
            String name = request.getParameter("name");
            boolean all = request.getParameter("all") != null;
            URI graphName = null;
            if (all) {
                if (name != null) {
                    throw new BadRequestException("You may not specify both a named graph and the 'all' keyword");
                }
                if (!format.supportsContexts() && !force) {
                    throw new BadRequestException("'All' may not be specified with a format that does not support quads");
                }
            } else {
                graphName = Utils.parseURI((String)name, (String)"name", (boolean)true);
            }
            try {
                if (all) {
                    ArrayList<Object> graphs = new ArrayList<Object>();
                    ArrayList<Resource> later = new ArrayList<Resource>();
                    RepositoryResult rr = null;
                    Set tboxGraphs = TBoxInferencer.getInstance().getTBoxGraphs();
                    try {
                        rr = rc.getContextIDs();
                        while (rr.hasNext()) {
                            Resource ctx = (Resource)rr.next();
                            if (ctx instanceof URI && tboxGraphs.contains((URI)ctx)) {
                                graphs.add(ctx);
                                continue;
                            }
                            later.add(ctx);
                        }
                    }
                    finally {
                        rr.close();
                    }
                    graphs.addAll(later);
                    for (Resource resource : graphs) {
                        if (resource instanceof URI && Access.hasPermission((HttpServletRequest)request, (Resource)resource, (Access)Access.READ)) continue;
                        throw new ForbiddenException("You are not allowed to read graph " + resource.stringValue());
                    }
                    response.setContentType(Utils.makeContentType((String)format.getDefaultMIMEType(), (String)"UTF-8"));
                    MultiWriter writer = new MultiWriter(this, (RDFHandler)Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")), null);
                    try {
                        for (Resource resource : graphs) {
                            rc.exportStatements(null, null, null, inferred, (RDFHandler)writer, new Resource[]{resource});
                        }
                        break block21;
                    }
                    finally {
                        writer.close();
                    }
                }
                if (!Access.hasPermission((HttpServletRequest)request, (Resource)graphName, (Access)Access.READ)) {
                    throw new ForbiddenException("You are not allowed to read this graph: " + graphName.stringValue());
                }
                if (rc.hasStatement((Resource)graphName, RDF.TYPE, (Value)REPO.NAMED_GRAPH, true, new Resource[0])) {
                    response.setContentType(Utils.makeContentType((String)format.getDefaultMIMEType(), (String)"UTF-8"));
                    rc.exportStatements(null, null, null, inferred, (RDFHandler)Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")), new Resource[]{graphName});
                    break block21;
                }
                throw new NotFoundException("This URI is not a named graph: " + graphName);
            }
            catch (OpenRDFException e) {
                log.error((Object)"Failed exporting graph content: ", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }
}

