<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  Admin - display and edit the properties of a single Transition
   -  REQUIRED ARGS:
   -   uri - OR - create
   -  ARGS TO CHANGE PROPERTIES:
   -   label = textual label for the graph
   -   comment = description
   -   submit
  --%>
<%@ page import="java.io.IOException" %>
<%@ page import="java.util.Arrays" %>
<%@ page import="java.util.Set" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.Collection" %>
<%@ page import="javax.servlet.http.HttpServletResponse" %>
<%@ page import="javax.servlet.jsp.JspWriter" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>

<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.openrdf.model.Literal" %>
<%@ page import="org.openrdf.model.Value" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.model.impl.URIImpl" %>

<%@ page import="org.eaglei.repository.NamedGraph" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.AccessGrant" %>
<%@ page import="org.eaglei.repository.View" %>
<%@ page import="org.eaglei.repository.workflow.WorkflowTransition" %>
<%@ page import="org.eaglei.repository.workflow.WorkflowState" %>
<%@ page import="org.eaglei.repository.workflow.WorkflowAction" %>
<%@ page import="org.eaglei.repository.Provenance" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>
<%@ page import="org.eaglei.repository.status.NotFoundException" %>

<%!
    private void makeStateSelector(HttpServletRequest request,  JspWriter out, String name, URI val)
        throws IOException, ServletException
    {
        out.append("<select name=\"").append(name).append("\" id=\"id_").append(name).append("\">\n");
        out.append("<option value=\"\"> --choose one-- </option>");
        for (WorkflowState s : WorkflowState.findAll(request)) {
            URI suri = s.getURI();
            out.append("<option ").append(suri.equals(val) ? "selected" : "")
               .append(" value=\"").append(suri.stringValue()).append("\">").append(s.getLabel()).append("</option>\n");
        }
        out.append("</select>\n");
    }
%>

  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <title>Eagle-I Data Repository Admin - Edit Workflow Transition</title>
    <style type="text/css">
        .ei_required { color: red; }
    </style>
  </head>

<%
    try {
        if (!Access.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");

        // feedback message about status of any chosen operation
        String message = null;
        boolean messageSuccess = false;

        request.setCharacterEncoding("UTF-8");
        boolean createp = request.getParameter("create") != null;
        URI uri = Utils.parseURI(request.getParameter("uri"), "uri", !createp);
        String label = request.getParameter("label");
        if (label == null)
            label = "";
        String comment = request.getParameter("comment");
        if (comment != null && comment.trim().length() == 0)
            comment = null;
        URI workspace = Utils.parseURI(request.getParameter("workspace"), "workspace", false);
        URI initialState = Utils.parseURI(request.getParameter("initial"), "initial", false);
        URI finalState = Utils.parseURI(request.getParameter("final"), "final", false);
        String action = request.getParameter("action");
        String actionParameter = request.getParameter("actionParameter");
        String order = request.getParameter("order");
        if (order == null || order.trim().length() == 0)
            order = null;

        // cleanup: 'action' must be fully-qualified Java class name
        // and parameter is meaningless without it.
        if (action == null || action.trim().length() == 0) {
            action = null;
            actionParameter = null;
        } else if (actionParameter != null && actionParameter.trim().length() == 0) {
            actionParameter = null;
        }

        // required-style - only turn on 'red' on when creating new Transition
        String reqStyle = createp ? "class=\"ei_required\"" : "";

        // execute request if 'submit' set
        if (request.getParameter("submit") != null) {
            if (label == null || label.length() == 0) {
                response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'label'");
                return;
            }
            WorkflowTransition result = null;
            if (createp) {
                result = WorkflowTransition.create(request, uri, label, comment, initialState, finalState);
                messageSuccess = true;
                message = "Transition has been created.";
                uri = result.getURI();
                createp = false;
            } else {
                result = WorkflowTransition.find(request, uri);
                result.setLabel(request, label);
                result.setComment(request, comment);
                result.setInitial(request, initialState);
                result.setFinal(request, finalState);
                messageSuccess = true;
                message = "Transition has been modified.";
            }
            result.setOrder(request, order);
            result.setWorkspace(request, workspace);
            result.setAction(request, action);
            result.setActionParameter(request, actionParameter);
            result.commit(request);

        // if this is the first load of the page, initialize values from instance
        } else if (!createp) {
            WorkflowTransition r = WorkflowTransition.find(request, uri);
            label = r.getLabel();
            comment = r.getComment();
            workspace = r.getWorkspace();
            order = r.getOrder();
            initialState = r.getInitial();
            finalState = r.getFinal();
            WorkflowAction ao = r.getAction();
            action = (ao == null) ? "" : ao.getClass().getName();
            Value ap = r.getActionParameter();
            actionParameter = ap == null ? "" : ap.stringValue();
        }
        String verb = createp ? "Create" : "Edit";
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2 align="center"><%= verb %> Workflow Transition</h2>
<%
    if (uri != null) {
%>
    <h3 align="center"><tt><%= StringEscapeUtils.escapeHtml(uri.stringValue()) %></tt></h3>
<%
    }
    if (message != null) {
%>
      <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
     </h3>
<%
    }
%>

    <form action="">
      <fieldset style="width: 80%; align: center;">
       <legend><b>Enter Transition Properties</b></legend>
<%
    if (createp) {
%>
       <input type="hidden" name="create" value="true"/>
       <i>Input fields labelled in <span class="ei_required"><b>RED</b></span>  are <b>required.</b></i>
       <br/>
       <p><label for="id_uri"><b>URI:</b> </label>
       <input type="text" id="id_uri" name="uri" size="50" value=""/>
       <br><i>This is <b>optional</b>, only fill in if you want a specific URI for the Role.
            It must not be used for any other object.</i>
       </p>
<%
    } else {
%>
       <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(uri.stringValue()) %>"/>
<%
    }
%>
       <p>
        <label for="id_label"><span <%= reqStyle %>><b>Label:</b> </span></label>
        <input type="text" id="id_label" name="label" size="50" value="<%= Utils.escapeHTMLAttribute(label) %>"/>
       </p>

       <p>
        <label for="id_comment"><b>Description:</b></label>
        <input type="text" id="id_comment" name="comment" size="80" value="<%= comment == null ? "" : Utils.escapeHTMLAttribute(comment) %>"/>
       </p>

       <p>
        <label for="id_initial"><span <%= reqStyle %>><b>Initial State:</b> </span></label>
        <% makeStateSelector(request, out, "initial", initialState); %>
       </p>

       <p>
        <label for="id_final"><span <%= reqStyle %>><b>Final State:</b> </span></label>
        <% makeStateSelector(request, out, "final", finalState); %>
       </p>

       <p>
        <label for="id_workspace"><b>Workspace:</b></label>
        <select id="id_workspace" name="workspace">
          <option selected value="">-- applies to all workspaces --</option>
<%
    Set<Map.Entry<String,URI>> ws = View.getAllWorkspaceGraphs(request).entrySet();
    for (Map.Entry<String,URI> we : ws) {
%>
          <option value="<%= Utils.escapeHTMLAttribute(we.getValue().stringValue()) %>"
            <%= we.getValue().equals(workspace) ? "selected" : "" %>>
            <%= StringEscapeUtils.escapeHtml(we.getKey()) %> (<%= StringEscapeUtils.escapeHtml(we.getValue().getLocalName()) %>)
          </option>
<%
    }
%>
        </select>
       </p>

       <p>
        <label for="id_action"><b>Action class:</b></label>
        <input type="text" id="id_action" name="action" size="80" value="<%= action == null ? "" : Utils.escapeHTMLAttribute(action) %>"/>
        <br/><i>Must be fully-qualified Java class name of WorkflowAction implementation.</i>
       </p>

       <p>
        <label for="id_actionParameter"><b>Action Parameter:</b></label>
        <input type="text" id="id_actionParameter" name="actionParameter" size="80" value="<%= actionParameter == null ? "" : Utils.escapeHTMLAttribute(actionParameter) %>"/>
        <br/><i>URI or literal value to pass to action as optional parameter.</i>
       </p>

       <p>
        <label for="id_order"><b>Order:</b></label>
        <input type="text" id="id_order" name="order" size="20" value="<%= order == null ? "" : Utils.escapeHTMLAttribute(order) %>"/>
        <br/><i>This is only used as sort key to determine ordering of Transitions in list view.</i>
       </p>

       <div width="50%" align="left">
         <div width="50%" align="center">
           <button type="reset">Reset Form</button>
           &nbsp;&nbsp;&nbsp;&nbsp;
           <button name="submit" value="submit" type="submit">Submit</button>
         </div>
       </div>
      </fieldset>
    </form>
<%
    // don't show or edit ACLs when creating, since no URI yet..
    if (!createp) {
%>
    <br/>
    <table border="1" width="30%">
      <caption align="top"><b>Current Access Grants:</b></caption>
      <tr><th>Agent</th><th>Delete</th></tr>
<%
    for (AccessGrant g : Access.getGrants(request, uri)) {
        if (Access.READ.getURI().equals(g.access.uri)) {
%>
      <tr>
        <td>
        <%= StringEscapeUtils.escapeHtml(g.agent.label) %>
        [<%= StringEscapeUtils.escapeHtml(g.agentType.label) %>]
        </td>
        <td>
<%          if (g.builtin) { %>
          <i>Built-In</i>
<%          } else { %>
          <form  method="post" action="/repository/admin/editGrants.jsp" style="margin: 0pt;">
          <input type="hidden" name="lock_access" value="<%= Utils.escapeHTMLAttribute(Access.READ.getURI().stringValue()) %>"/>
          <input type="hidden" name="type" value="Workflow Transition"/>
          <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(uri.stringValue()) %>"/>
          <input type="hidden" name="action" value="remove"/>
          <input type="hidden" name="agent" value="<%= Utils.escapeHTMLAttribute(g.agent.toString()) %>"/>
          <input type="hidden" name="access" value="<%= Utils.escapeHTMLAttribute(g.access.toString()) %>"/>
          <button type="submit">Delete!</button>
          </form>
<%          } %>
        </td>
      </tr>
<%
        }
    }
%>
    </table>
    <br/>

    <form  action="/repository/admin/editGrants.jsp">
      <fieldset style="width: 80%; align: center;">
       <legend><b>Change Access on Workflow Transition</b></legend>
      <input type="hidden" name="lock_access" value="<%= Utils.escapeHTMLAttribute(Access.READ.getURI().stringValue()) %>"/>
      <input type="hidden" name="type" value="Workflow Transition" />
      <input type="hidden" name="label" value="<%= Utils.escapeHTMLAttribute(label) %>"/>
      <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(uri.stringValue()) %>"/>
      <button type="submit">Edit ACL</button><i> (Leaves this page)</i>
     </fieldset>
    </form>
<%
    }
%>
    <p></p>
    <p>
    <a href="/repository/admin/transitions.jsp">Return to list of Workflow Transitions</a>
    </p>
    <p>
    <a href="/repository/admin/editTransition.jsp?create">Create a New Workflow Transition</a>
    </p>
    <p>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
    </p>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
