/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.workflow.WorkflowTransition;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.query.impl.MapBindingSet;

public class WorkflowTransitions
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WorkflowTransitions.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String format = null;
        String rawWorkspace = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                File tmp = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
                if (tmp == null) {
                    throw new InternalServerErrorException("Cannot find servlet context attr = \"javax.servlet.context.tempdir\"");
                }
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, tmp));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("workspace")) {
                        rawWorkspace = item.getString();
                        continue;
                    }
                    if (ifn.equals("format")) {
                        format = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request", (Throwable)e);
            }
        } else {
            format = request.getParameter("format");
            rawWorkspace = request.getParameter("workspace");
        }
        URI workspace = Utils.parseURI((String)rawWorkspace, (String)"workspace", (boolean)false);
        log.debug((Object)("workspace parameter = " + workspace));
        ArrayList<MapBindingSet> result = new ArrayList<MapBindingSet>();
        for (WorkflowTransition t : WorkflowTransition.findAll((HttpServletRequest)request)) {
            URI tw = t.getWorkspace();
            if (workspace == null || tw == null || tw.equals(workspace)) {
                URI subject = t.getURI();
                boolean allowed = Access.hasPermission((HttpServletRequest)request, (Resource)subject, (Access)Access.READ);
                MapBindingSet nbs = new MapBindingSet(10);
                nbs.addBinding("subject", (Value)subject);
                nbs.addBinding("label", (Value)new LiteralImpl(t.getLabel()));
                nbs.addBinding("initial", (Value)t.getInitial());
                nbs.addBinding("initialLabel", (Value)new LiteralImpl(t.getInitialLabel()));
                nbs.addBinding("final", (Value)t.getFinal());
                nbs.addBinding("finalLabel", (Value)new LiteralImpl(t.getFinalLabel()));
                String comment = t.getComment();
                nbs.addBinding("description", (Value)(comment == null ? null : new LiteralImpl(comment)));
                nbs.addBinding("workspace", (Value)tw);
                String wl = t.getWorkspaceLabel();
                nbs.addBinding("workspaceLabel", (Value)(wl == null ? null : new LiteralImpl(wl)));
                nbs.addBinding("allowed", (Value)BooleanLiteralImpl.valueOf((boolean)allowed));
                result.add(nbs);
                continue;
            }
            log.debug((Object)("Skipping because of WORKSPACE restriction: " + t));
        }
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, result);
    }
}

