<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<%@ page contentType="text/html;charset=utf-8" pageEncoding="UTF-8" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.eaglei.repository.User" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<!--
  - Parameters:
  -  1. When sending mail:
  -     uri
  -     label
  -     safe=true - ONLY when it is "safe" to send mail for testing
  -  2. Having SENT mail, this page ALSO reports success:
  -     sent=true  - REQUIRED, this is how to invoke sent mode
  -     uri
  -     test_mode = true when running in test mode..
  -     to - ONLY FOR DEBUG, NOT in production (it would reveal the hidden contact)
  -->
<html>
  <head>
     <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Eagle-I Repository - Contact Owner</title>
    <link href="/repository/styles/i.css" rel="stylesheet" type="text/css" />
        <script language="javascript" type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.4.1/jquery.min.js"></script>
    <script language="javascript" type="text/javascript" src="/repository/styles/i.js"></script>

  </head>
  <body bgcolor=white>
<%
    request.setCharacterEncoding("utf-8");
    String uri = request.getParameter("uri");
    String sent = request.getParameter("sent");
    boolean testMode = Boolean.parseBoolean(request.getParameter("test_mode"));
    if (sent != null) {
%>
        <h2>Message sent.</h2>
<%
        String to = request.getParameter("to");
        if (to != null) {
%>
         <h3>DEBUG: Sent to: <%= testMode ? "Postmaster, in lieu of: ":"" %><tt><%= StringEscapeUtils.escapeHtml(to) %></tt></h3>
<%
        }
        if (uri != null) {
%>
         <p/>
         <p>
         Return to <a href="<%= Utils.escapeHTMLAttribute(uri) %>"><%= StringEscapeUtils.escapeHtml(uri) %></a>.
<%
        }
%>
        <p/>
        <button type="button" class="cancel" title="Close window">Close Window</button>
<%
    } else {
        String label = request.getParameter("label");
        String remoteIP = request.getRemoteAddr();
        if (uri == null) {
            response.sendError(response.SC_BAD_REQUEST, "missing required parameter 'uri'");
            return;
        }
        String name = "";
        String email = "";
        try {
            User uu = Authentication.getPrincipalUser(request);
            if (uu != null) {
                String firstName = uu.getFirstName();
                String lastName = uu.getLastName();
                String mbox = uu.getMbox();
                if (firstName != null || lastName != null)
                    name = (firstName == null) ? lastName :
                                           (lastName == null) ? firstName : firstName+" "+lastName;
                if (mbox != null)
                    email = mbox;
            }
        } catch (ErrorSendingException e) {
            response.sendError(e.getStatus(), e.getMessage());
        }
%>
        <blockquote>
<%
        if (label == null) {
%>
        <strong class="contacttitle">Contact the Owner of this Resource</strong><br />
        <strong>URI: <tt><%= StringEscapeUtils.escapeHtml(uri) %></tt></strong>
<%
        } else {
%>
        <strong class="contacttitle">Contact <%= StringEscapeUtils.escapeHtml(label) %></strong><br />
        <strong>URI: <tt><%= StringEscapeUtils.escapeHtml(uri) %></tt></strong>
<%
        }
%>
        </blockquote>
        <p/>
        <form method="POST" action="/repository/emailContact">
          <table width="490" border="0" cellspacing="5" cellpadding="0">
            <tr>
              <td width="140" align="left" valign="middle"><b>Your Name: </b><span class="red">*</span></td>
              <td colspan="2" align="left" valign="middle"><input type="text" name="from_name" id="id_name" size="40" value="<%= Utils.escapeHTMLAttribute(name) %>"/>
                <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(uri) %>"/>
              <input type="hidden" name="client_ip" value="<%= Utils.escapeHTMLAttribute(remoteIP) %>"/></td>
            </tr>
            <tr>
              <td align="left" valign="middle"><b>Your Email: </b><span class="red">*</span></td>
              <td colspan="2" align="left" valign="middle"><input type="text" name="from_email" id="id_email" size="40" value="<%= Utils.escapeHTMLAttribute(email) %>"/></td>
            </tr>
            <tr>
              <td align="left" valign="middle"><b>Subject:</b></td>
              <td colspan="2" align="left" valign="middle"><input type="text" name="subject" id="id_subj" size="50" /></td>
            </tr>
            <tr>
              <td align="left" valign="middle"><b>Test Mode:</b></td>
              <td width="20" align="left" valign="middle"><%
        boolean safe = Boolean.parseBoolean(request.getParameter("safe"));
%>
                <br/>
                <input type="checkbox" name="test_mode" id="id_test" checked="true"/>
              <!-- <%= safe ? "" : "checked" %> --></td>
              <td width="310" align="left" valign="middle"><b><i><small><%= safe ? "<u>UN</u>Checking this box sends REAL EMAIL, but at least it is going to someone with an \"@eagle-i.org\" address." :
                           "<font color=\"red\">ONLY uncheck this box if you don't mind sending email to some random researcher at an eagle-i site.</font>" %></small></i></b></td>
            </tr>
            <tr>
              <td align="left" valign="middle"><label for="id_msg"><b>Message:</b></label></td>
              <td colspan="2" align="left" valign="middle">&nbsp;</td>
            </tr>
            <tr>
              <td colspan="3" align="left" valign="middle"><textarea id="id_msg" name="message" cols="70" rows="10"></textarea></td>
            </tr>
          </table>
          <i>Note: CAPCHA or security question will be needed for proof of humanity</i>
          <br/>
          <input type="button" value="Cancel" class="cancel" onclick=""/>
          <input type="submit" value="Send" name="submit"/>
        </form>
<%
    }
%>
  </body>
</html>
