package jsp.repository.query;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.Set;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerBase;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.OpenRDFException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.View;
import org.eaglei.repository.vocabulary.REPO;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.util.Utils;

public final class index_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

 private static Logger log = LogManager.getLogger("org.eaglei.repository.query.index.jsp"); 

    /** handler to print an <option> tag for each result */
    private static class queryHandler extends TupleQueryResultHandlerBase
    {
        private RepositoryConnection rc = null;
        private int count = 0;
        private StringBuilder w = new StringBuilder();

        public queryHandler(RepositoryConnection rc)
        {
            super();
            queryHandler.this.rc = rc;
        }
        // columns: label text
        public void handleSolution(BindingSet bs)
            throws TupleQueryResultHandlerException
        {
            Value label = bs.getValue("label");
            Value text = bs.getValue("text");
            if (label == null || text == null ||
                  !((text instanceof Literal) && (label instanceof Literal)))
                log.warn("Skipping incorrect query definition (label and query are not literals): label="+label+", text="+text);
            else {
                ++count;
                w.append("<option value=\"").append(StringEscapeUtils.escapeHtml(((Literal)text).getLabel())).
                  append("\">").append(StringEscapeUtils.escapeHtml(((Literal)label).getLabel())).
                  append("</option>\n");
            }
        }
        public int size() { return count; }
        public String toString() { return w.toString(); }
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");

    // allow this page to be cached, so field selections don't get reset
    // when you use the "Back" button on the browser:
    response.setHeader("Cache-Control", "max-age="+String.valueOf(12*60*60)+
                ", public");
    response.setHeader("Pragma", "none");

      out.write("\n <head>\n  <title>SPARQL Protocol Query Workbench</title>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n <script type=\"text/javascript\" src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js\"></script>\n <script type=\"text/javascript\">\n\n function addQueryHandlers() {\n                                                \n   $(\"#MacroSelect\").change(function() {\n           $(\"#QueryTextbox\").text($(\"#QueryTextbox\").val() + \"\\n\" + $(\"#MacroSelect\").val() + \"\\n\");\n           $(\"#MacroSelect\").val(\"\");\n           $(\"#QueryTextbox\").focus();\n        });\n\n   $(\"#view\").change(function() {\n           $(\"#workspace\").val(\"\");\n           $(\"#default-graph-uri\").val(\"\");\n           $(\"#named-graph-uri\").val(\"\");\n   });\n\n   $(\"#workspace\").change(function() {\n           $(\"#view\").val(\"\");\n           $(\"#default-graph-uri\").val(\"\");\n           $(\"#named-graph-uri\").val(\"\");\n   });\n\n   $(\"#default-graph-uri\").change(function() {\n           $(\"#view\").val(\"\");\n           $(\"#workspace\").val(\"\");\n");
      out.write("\n   });\n\n   $(\"#named-graph-uri\").change(function() {\n           $(\"#view\").val(\"\");\n           $(\"#workspace\").val(\"\");\n\n   });\n   \n }\n\n   $(document).ready(addQueryHandlers);\n                                      \n </script>\n\n </head>\n");

    try {

      out.write("\n <body>\n   <h2>SPARQL Query Workbench</h2>\n   <h3>");
      out.print( StringEscapeUtils.escapeHtml(DataRepository.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property eaglei.repository.title needs to be set)")) );
      out.write("\n   </h3>\n   <hr>\n\n   <form accept-charset=\"UTF-8\" action=\"/repository/sparql\" method=\"POST\">\n\n");
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write("\n<b>&nbsp;&nbsp;Query:</b>(<i><a href=\"http://www.w3.org/TR/rdf-sparql-query/\">Click for SPARQL help</a></i>)\n&nbsp;&nbsp;&nbsp;&nbsp; <select id=\"MacroSelect\" name=\"macro\">\n");

    String query =
      "SELECT DISTINCT ?label ?text WHERE { "+
      "?s a <"+REPO.QUERY_MACRO+">; <"+RDFS.LABEL+"> ?label; <"+REPO.QUERY+"> ?text }";
    RepositoryConnection rc = WithRepositoryConnection.get(request);
    queryHandler qh = new queryHandler(rc);
    try {
        TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query);
        DatasetImpl ds = new DatasetImpl();
        ds.addDefaultGraph(REPO.NG_QUERY);
        q.setDataset(ds);
        q.evaluate(qh);
    } catch (MalformedQueryException e) {
        log.info("Rejecting malformed query: "+e);
        response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "Malformed query was generated internally: "+e.toString());
    } catch (OpenRDFException e) {
        log.error(e);
        throw new ServletException(e);
    }
    if (qh.size() > 0) {

      out.write("\n  <option selected value=\"\"> Add Query Macro </option>\n  ");
      out.print( StringEscapeUtils.escapeHtml(qh.toString()) );
      out.write('\n');

    } else {

      out.write("\n <option selected value=\"\"> (No Query Macros Defined) </option>\n");

    }

      out.write("\n</select>\n<br/>\n<textarea name=\"query\" id=\"QueryTextbox\" cols=\"80\" rows=\"8\">PREFIX rdf: &lt;http://www.w3.org/1999/02/22-rdf-syntax-ns#&gt;\nPREFIX rdfs: &lt;http://www.w3.org/2000/01/rdf-schema#&gt;\nPREFIX owl: &lt;http://www.w3.org/2002/07/owl#&gt;\nPREFIX dcterms: &lt;http://purl.org/dc/terms/&gt;\nPREFIX : <http://eagle-i.org/ont/repo/1.0/>\n</textarea>\n\n<fieldset>\n<legend><b>Choose Dataset</b></legend>\n<i>You must make a choice in <b>ONLY ONE</b> of the Default Graph,\nNamed Graph, View <u>or</u> Workspace selectors.</i>\n\n<br><b>View:</b> <select id=\"view\" name=\"view\">\n<option selected value=\"\">--none--</option>\n");

    for (View vw : View.values()) {

      out.write("\n        <option value=\"");
      out.print( Utils.escapeHTMLAttribute(vw.getLabel()) );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(vw.getTitle()) );
      out.write("</option>\n");

    }

      out.write("\n</select>\n<br><b>Workspace:</b> <select id=\"workspace\" name=\"workspace\">\n<option selected value=\"\">--none--</option>\n");

    Set<Map.Entry<String,URI>> ws = View.getAllWorkspaceGraphs(request).entrySet();
    for (Map.Entry<String,URI> we : ws) {

      out.write("\n        <option value=\"");
      out.print( Utils.escapeHTMLAttribute(we.getValue().toString()) );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(we.getKey()) );
      out.write(' ');
      out.write('(');
      out.print( StringEscapeUtils.escapeHtml(we.getValue().getLocalName()) );
      out.write(")</option>\n");

    }

      out.write("\n</select>\n\n<table>\n <tr><th align=\"left\" width=\"50%\">Default Graph:</th>\n     <th align=\"left\" width=\"50%\">Named Graph:</th></tr>\n<tr><td>\n  <select name=\"default-graph-uri\" id=\"default-graph-uri\" multiple=\"true\" size=\"6\">\n  <option selected value=\"\">--none--</option>\n  ");

      Iterable<NamedGraph> namedGraphs = NamedGraph.findAll(request);
      for (NamedGraph ng : namedGraphs) {
  
      out.write("\n  <option value=\"");
      out.print( Utils.escapeHTMLAttribute(ng.getName().toString()) );
      out.write("\">\n   ");
      out.print( StringEscapeUtils.escapeHtml(ng.getName().getLocalName())+" ("+StringEscapeUtils.escapeHtml(ng.getLabel())+")" );
      out.write("\n  </option>\n  ");

      }
  
      out.write("\n</td><td>\n  </select>\n   \n  <select name=\"named-graph-uri\" id=\"named-graph-uri\" multiple=\"true\" size=\"6\">\n  <option selected value=\"\">--none--</option>\n  ");

      for (NamedGraph ng : namedGraphs) {
  
      out.write("\n  <option value=\"");
      out.print( Utils.escapeHTMLAttribute(ng.getName().toString()) );
      out.write("\">\n   ");
      out.print( StringEscapeUtils.escapeHtml(ng.getName().getLocalName())+" ("+StringEscapeUtils.escapeHtml(ng.getLabel())+")" );
      out.write("\n  </option>\n  ");

      }
  
      out.write("\n  </select>\n</td></tr>\n <tr><td colspan=\"2\"><i>You may select multiple graphs\n       multiple graphs from one or both of these columns.</i></td></tr>\n</table>\n</fieldset>\n\n<br><b>Output Format:</b>\n<select name=\"format\">\n<option selected=\"selected\" value=\"text/html\">HTML</option>\n<option value=\"application/xml\">XML</option>\n<option value=\"text/plain\">Plain Text (TSV or N-Triples)</option>\n<optgroup label=\"SELECT queries only:\">\n <option value=\"application/sparql-results+json\">JSON</option>\n <option value=\"application/sparql-results+xml\">XML SPARQL Result</option>\n</optgroup>\n<optgroup label=\"CONSTRUCT/DESCRIBE queries only:\">\n <option value=\"application/rdf+xml\">RDF/XML</option>\n <option value=\"text/rdf+n3\">RDF/N3</option>\n <option value=\"application/x-turtle\">RDF/TURTLE</option>\n <option value=\"application/x-trig\">TriG</option>\n <option value=\"application/trix\">TriX (silly rabbit)</option>\n <option value=\"text/rdf+nquads\">RDF/NQuads (write-only, non-standard)</option>\n</optgroup>\n<optgroup label=\"ASK queries only:\">\n");
      out.write(" <option value=\"text/boolean\">Boolean in Plain Text</option>\n</optgroup>\n</select>\n&nbsp;&nbsp;<b>No Inferred:</b> <input name=\"inferred\" type=\"checkbox\" value=\"false\"/>\n&nbsp;&nbsp;<b>Time Limit:</b> <input name=\"time\" type=\"text\" size=\"4\"/>\n <i>(Sec) <b>(Not Impl.)</b></i>\n<br>\n<br>\n<input value=\"Clear Form!\" type=\"reset\">\n&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\n<input value=\"Get Results\" type=\"submit\">\n\n      </form>\n<br/>\n<a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n</body>\n");

    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
