package org.eaglei.repository.inferencer;

import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.NotifyingSailWrapper;
import org.openrdf.sail.inferencer.InferencerConnection;

/**
 * Sesame RDF Database extension to add:
 * Custom minimalist inferencing SAIL layer for
 * eagle-i Data Repoository.  This just wraps a Sesame Repository object;
 * the implementation is all in MinimalInferencerConnection.
 *
 * @see MinimalInferencerConnection
 * @author Larry Stone
 * Started May 30 2010
 * @version $Id: $
 */
public class MinimalInferencer extends NotifyingSailWrapper
{
    /**
     * <p>Constructor for MinimalInferencer.</p>
     */
    public MinimalInferencer()
    {
        super();
    }

    /**
     * <p>Constructor for MinimalInferencer.</p>
     *
     * @param baseSail a {@link org.openrdf.sail.NotifyingSail} object.
     */
    public MinimalInferencer(NotifyingSail baseSail)
    {
        super(baseSail);
    }

    /** {@inheritDoc} */
    @Override
    public MinimalInferencerConnection getConnection()
        throws SailException
    {
        try {
            InferencerConnection con = (InferencerConnection)super.getConnection();
            return new MinimalInferencerConnection(con);
        } catch (ClassCastException e) {
            throw new SailException(e.getMessage(), e);
        }
    }
}
