package org.eaglei.repository.servlet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.BindingSet;
import org.openrdf.model.impl.URIImpl;

import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.rid.RIDGenerator;

/**
 * <p>New class.</p>
 *
 * @author lcs
 * @version $Id: $
 */
public class New extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(New.class);

    private static String columnNames[] = { "new" };

    /** {@inheritDoc} */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        int count = 1;
        String rawcount = null;
        String format = null;

        // if POST with multipart, grovel through args
        request.setCharacterEncoding("UTF-8");
        if (ServletFileUpload.isMultipartContent(request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                upload.setFileItemFactory(new DiskFileItemFactory(100000,
                  (File)getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir")));
                for (DiskFileItem item : (List<DiskFileItem>)upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("count"))
                        rawcount = item.getString();
                    else if (ifn.equals("format"))
                        format = item.getString();
                    else
                        log.warn("Unrecoginized request argument: "+ifn);
                }
            } catch  (FileUploadException e) {
                log.error(e);
                throw new BadRequestException("failed parsing multipart request", e);
            }

        // gather args from input params instead
        } else {
            rawcount = request.getParameter("count");
            format = request.getParameter("format");
        }

        // sanity checks - count must be > 0 or defaulted to 1
        if (rawcount != null) {
            try {
                count = Integer.parseInt(rawcount);
            } catch (NumberFormatException e) {
                throw new BadRequestException("The 'count' argument was not an integer: "+count, e);
            }
        }
        if (count <= 0)
            throw new BadRequestException("The 'count' argument was not an integer greater than 0: "+count);

        log.debug("Got /new GET request, count="+count);
        UUID uuids[] = RIDGenerator.getInstance().newIDs(count);

        // XXX FIXME: need access check, ideally find a graph
        //  that this user can write, but maybe it's enough to just
        //  be an authenticated user?? (which is done by servlet container)

        ArrayList<BindingSet> results = new ArrayList<BindingSet>(uuids.length);
        for (UUID uuid : uuids) {
            MapBindingSet bs = new MapBindingSet(1);
            bs.addBinding(columnNames[0],
              new URIImpl(DataRepository.getInstance().getDefaultNamespace() + uuid.toString()));
            results.add(bs);
        }
        SPARQL.sendTupleQueryResults(request, response, format, results);
    }
}
