/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.Role;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.HandlerBadRequest;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
@HasContentCache
public class Role
implements Comparable {
    private static Logger log = LogManager.getLogger(Role.class);
    private URI uri;
    private String label = null;
    private String comment = null;
    private boolean implicit = false;
    private boolean dirty = false;
    private static volatile Map<URI, Role> cacheInternal = null;
    private static final String roleQuery = "SELECT DISTINCT ?uri ?label ?comment ?implicit WHERE {\n ?uri a <" + REPO.ROLE + "> ; <" + RDFS.LABEL + "> ?label .\n" + "  OPTIONAL { ?uri <" + REPO.IS_IMPLICIT + "> ?implicit }\n" + "  OPTIONAL { ?uri <" + RDFS.COMMENT + "> ?comment }}";

    private Role(URI uri, String label, String comment, boolean implicit) {
        this.uri = uri;
        this.label = label;
        this.comment = comment;
        this.implicit = implicit;
    }

    public static Role find(HttpServletRequest request, URI uri) throws ServletException {
        Map cache = Role.getCache((HttpServletRequest)request);
        if (cache.containsKey(uri)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("find(" + uri.stringValue() + ") => " + cache.get(uri)));
            }
            return (Role)cache.get(uri);
        }
        throw new NotFoundException("There is no Role of URI=" + uri);
    }

    public static List<Role> findAll(HttpServletRequest request) throws ServletException {
        Map cache = Role.getCache((HttpServletRequest)request);
        return new ArrayList<Role>(cache.values());
    }

    public static List<Role> findAllGrantable(HttpServletRequest request) throws ServletException {
        Map cache = Role.getCache((HttpServletRequest)request);
        ArrayList<Role> result = new ArrayList<Role>(cache.values());
        result.remove(Role.find((HttpServletRequest)request, (URI)REPO.ROLE_SUPERUSER));
        Collections.sort(result);
        return result;
    }

    public static List<Role> findAllUserRoles(HttpServletRequest request) throws ServletException {
        Map cache = Role.getCache((HttpServletRequest)request);
        ArrayList<Role> result = new ArrayList<Role>();
        for (Role r : cache.values()) {
            if (r.implicit) continue;
            result.add(r);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decache() {
        Class<Role> clazz = Role.class;
        synchronized (Role.class) {
            cacheInternal = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<URI, Role> getCache(HttpServletRequest request) throws ServletException {
        Class<Role> clazz = Role.class;
        synchronized (Role.class) {
            if (cacheInternal != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return cacheInternal;
            }
            cacheInternal = new HashMap();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                log.debug((Object)("All role SPARQL query = " + roleQuery));
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, roleQuery);
                q.setDataset((Dataset)SPARQL.InternalGraphs);
                q.setIncludeInferred(true);
                q.evaluate((TupleQueryResultHandler)new allRoleHandler(cacheInternal));
            }
            catch (MalformedQueryException e) {
                log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
                throw new ServletException((Throwable)e);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            return cacheInternal;
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isSuperuser() {
        return this.uri.equals(REPO.ROLE_SUPERUSER);
    }

    public String getLabel() {
        return this.label;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object other) {
        return other instanceof Role && this.uri.equals(((Role)other).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "<#Role: uri=" + this.uri.toString() + ", label=" + this.label + ">";
    }

    public int compareTo(Object o) {
        return this.label.compareTo(((Role)o).label);
    }

    public boolean isBuiltin() {
        return this.implicit || REPO.ROLE_SUPERUSER.equals(this.uri);
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public static Role create(HttpServletRequest request, URI asubject, String label, String comment) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to create a new Role.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            if (label == null || label.length() == 0) {
                throw new BadRequestException("Label is required when creating a new Role.");
            }
            URI subject = asubject;
            if (subject == null) {
                subject = vf.createURI(DataRepository.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString());
            }
            rc.add((Resource)subject, RDF.TYPE, (Value)REPO.ROLE, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)subject, RDFS.LABEL, (Value)vf.createLiteral(label), new Resource[]{REPO.NG_INTERNAL});
            if (comment != null && comment.length() > 0) {
                rc.add((Resource)subject, RDFS.COMMENT, (Value)vf.createLiteral(comment), new Resource[]{REPO.NG_INTERNAL});
            }
            Role result = new Role(subject, label, comment, false);
            result.dirty = true;
            Role.decache();
            log.debug((Object)("Created Role uri=" + subject.stringValue() + ", label=" + label));
            return result;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void delete(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to delete a Role.");
        }
        if (this.isBuiltin()) {
            throw new ForbiddenException("Built-in Roles may not be deleted.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.uri, null, null, new Resource[]{REPO.NG_INTERNAL});
            this.dirty = true;
            Role.decache();
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setLabel(HttpServletRequest request, String label) throws ServletException {
        if (label == null || label.length() == 0) {
            throw new BadRequestException("Label must be a non-empty string.");
        }
        this.setMetadataInternal(request, RDFS.LABEL, label);
    }

    public void setComment(HttpServletRequest request, String newVal) throws ServletException {
        this.setMetadataInternal(request, RDFS.COMMENT, newVal);
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, String newVal) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to modify Roles.");
        }
        if (this.isBuiltin()) {
            throw new ForbiddenException("Builtin Roles may not be modified.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            rc.remove((Resource)this.uri, property, null, new Resource[]{REPO.NG_INTERNAL});
            if (newVal != null) {
                rc.add((Resource)this.uri, property, (Value)vf.createLiteral(newVal), new Resource[]{REPO.NG_INTERNAL});
                log.debug((Object)("Setting Role uri=" + this.uri + ", property=" + property + " to value=" + newVal));
            } else {
                log.debug((Object)("Clearing Role uri=" + this.uri + ", property=" + property));
            }
            this.dirty = true;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void commit(HttpServletRequest request) throws ServletException {
        try {
            if (this.dirty) {
                WithRepositoryConnection.get((ServletRequest)request).commit();
                Role.decache();
            }
            this.dirty = false;
        }
        catch (OpenRDFException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static void doExportRoles(HttpServletRequest request, HttpServletResponse response, RDFFormat format, Set<String> includes, Set<String> excludes) throws ServletException, IOException {
        try {
            RDFWriter out = Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            out.startRDF();
            for (Role r : Role.findAll((HttpServletRequest)request)) {
                if (r.isBuiltin()) continue;
                URI ru = r.getURI();
                String rus = ru.stringValue();
                String rc = r.getComment();
                String rl = r.getLabel();
                if (excludes.contains(rl) || excludes.contains(rus)) {
                    log.debug((Object)("SKIP ROLE because of exclude: " + r));
                    continue;
                }
                if (includes.isEmpty() || includes.contains(rl) || includes.contains(rus)) {
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)ru, RDF.TYPE, (Value)REPO.ROLE, (Resource)REPO.NG_INTERNAL));
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)ru, RDFS.LABEL, (Value)new LiteralImpl(r.getLabel()), (Resource)REPO.NG_INTERNAL));
                    if (rc == null) continue;
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)ru, RDFS.COMMENT, (Value)new LiteralImpl(rc), (Resource)REPO.NG_INTERNAL));
                    continue;
                }
                log.debug((Object)("SKIP ROLE because of include: " + r));
            }
            out.endRDF();
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static void doImportRoles(HttpServletRequest request, HttpServletResponse response, RepositoryConnection content, Set<String> includes, Set<String> excludes, ImportExport.DuplicateArg duplicate, boolean transform) throws ServletException, IOException {
        try {
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, roleQuery);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL query to get IMPORTED ROLES (against internal memory repo) =\n\t" + roleQuery));
            }
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            q.setIncludeInferred(false);
            importRoleHandler ih = new importRoleHandler(request, includes, excludes, duplicate, transform);
            q.evaluate((TupleQueryResultHandler)ih);
            if (importRoleHandler.access$200((importRoleHandler)ih) == 0 && content.size(new Resource[0]) > 0L) {
                throw new BadRequestException("Invalid input: None of the statements in the input data are valid Role representations.");
            }
        }
        catch (HandlerBadRequest e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ boolean access$302(Role x0, boolean x1) {
        x0.implicit = x1;
        return x0.implicit;
    }
}

