/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.Formats;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.View;
import org.eaglei.repository.servlet.Harvest;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DATAMODEL;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.repository.RepositoryConnection;

public class Harvest
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Harvest.class);
    private static final String DELETED_PREFIX = "info:/deleted#";
    private static final String[] column = new String[]{"subject", "predicate", "object"};
    private static List<String> columnNames = null;
    private static final String detailIdNoTimeQuery;
    private static final String detailIdNoTimeEmbedsQuery;
    private static final String detailFullNoTimeQueryStart;
    private static final String detailFullNoTimeQueryEnd;
    private static final String detailFullNoTimeQueryNoInferred;
    private static final String detailFullNoTimeQueryWithInferred;
    private static final String detailFullNoTimeQueryEmbedsStart;
    private static final String detailFullNoTimeQueryEmbedsNoInferred;
    private static final String detailFullNoTimeQueryEmbedsWithInferred;
    private static final String deletedFromTimeQueryProlog;
    private static final String deletedAndWithdrawnFromTimeQuery;
    private static final String deletedNotWithdrawnFromTimeQuery;
    private static final String identifierFromTimeQuery;
    private static final String fullFromTimeQueryStart;
    private static final String fullFromTimeQueryEnd;
    private static final String fullFromTimeWithInferredQuery;
    private static final String fullFromTimeNoInferredQuery;
    private static final String fullEIsFromTimeQueryStart;
    private static final String fullEIsFromTimeNoInferredQuery;
    private static final String fullEIsFromTimeWithInferredQuery;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String format = request.getParameter("format");
        String rawview = request.getParameter("view");
        String rawws = request.getParameter("workspace");
        boolean inferred = Utils.parseBooleanParameter((String)request.getParameter("inferred"), (String)"inferred", (boolean)false, (boolean)false);
        boolean embedded = Utils.parseBooleanParameter((String)request.getParameter("embedded"), (String)"embedded", (boolean)false, (boolean)true);
        String rawfrom = request.getParameter("from");
        String rawafter = request.getParameter("after");
        String rawdetail = request.getParameter("detail");
        View view = null;
        if (request.getParameter("until") != null) {
            throw new HttpStatusException(501, "The 'until' arg is not implemented yet.");
        }
        DetailArg detail = (DetailArg)Utils.parseKeywordArg(DetailArg.class, (String)rawdetail, (String)"detail", (boolean)true, null);
        if (rawafter != null && rawfrom != null) {
            throw new BadRequestException("The 'from' and 'after' args are mutually exclusive.");
        }
        XMLGregorianCalendar from = null;
        if (rawfrom != null) {
            from = Utils.parseXMLDate((String)rawfrom);
        } else if (rawafter != null) {
            try {
                from = Utils.parseXMLDate((String)rawafter);
                from.add(DatatypeFactory.newInstance().newDuration(1L));
            }
            catch (DatatypeConfigurationException e) {
                throw new BadRequestException("Failed converting 'after' arg: ", (Throwable)e);
            }
        }
        if (detail == DetailArg.identifier && inferred) {
            throw new BadRequestException("The 'inferred' arg is not allowed when detail = identifier.");
        }
        if (rawws != null && rawview != null) {
            throw new BadRequestException("The 'view' and 'workspace' arguments are mutually exclusive.  Choose only one.");
        }
        URI workspace = Utils.parseURI((String)rawws, (String)"workspace", (boolean)false);
        if (rawview == null) {
            view = View.PUBLISHED_RESOURCES;
        } else {
            view = View.parseView((String)rawview);
            if (view == null) {
                throw new BadRequestException("Unknown view: " + rawview);
            }
        }
        long startMs = System.currentTimeMillis();
        try {
            String mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format);
            TupleQueryResultFormat tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
            if (tqf == null) {
                throw new InternalServerErrorException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
            }
            response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
            TupleQueryResultWriter out = QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream());
            Date lm = DataRepository.getInstance().getLastModified();
            response.addDateHeader("Last-Modified", lm.getTime());
            response.addHeader("X-Precise-Last-Modified", Utils.makePreciseHTTPDate((Date)lm));
            if (from != null) {
                if (lm.before(from.toGregorianCalendar().getTime())) {
                    log.debug((Object)("Optimizing result since last-modified mark is earlier than from: last-mod = " + lm));
                    out.startQueryResult(columnNames);
                    out.endQueryResult();
                    return;
                }
                log.debug((Object)("Going ahead with query, last-modified mark is after 'from': last-mod = " + lm));
            }
            this.harvest(request, response, detail, from, inferred, embedded, view, workspace, (TupleQueryResultHandler)out);
            log.info((Object)("SPARQL query for /harvest request completed in " + String.format("%,d mSec.", System.currentTimeMillis() - startMs)));
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void harvest(HttpServletRequest request, HttpServletResponse response, DetailArg detail, XMLGregorianCalendar from, boolean inferred, boolean embedded, View view, URI workspace, TupleQueryResultHandler out) throws OpenRDFException, ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        DatasetImpl ds = new DatasetImpl();
        if (workspace != null) {
            View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)ds, (URI)workspace);
        } else {
            View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)view);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dataset derived from initial 'view' or 'workspace' args = " + Utils.prettyPrint((Dataset)ds)));
        }
        HashSet<URI> resGraphs = new HashSet<URI>();
        DatasetImpl resDS = ds;
        for (URI g : ds.getDefaultGraphs()) {
            if (REPO.NG_USERS.equals(g)) continue;
            NamedGraph ng = NamedGraph.find((HttpServletRequest)request, (URI)g);
            if (ng == null) {
                throw new InternalServerErrorException("Failed to resolve named graph = " + g);
            }
            NamedGraph.Type ngt = ng.getType();
            if (ngt != NamedGraph.Type.published && ngt != NamedGraph.Type.workspace) continue;
            resGraphs.add(g);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Base (View/Workspace) Dataset ds = " + Utils.prettyPrint((Dataset)ds)));
            log.debug((Object)("Resource Dataset resDS = " + Utils.prettyPrint((Dataset)resDS)));
        }
        if (from == null) {
            TupleQuery q = null;
            TupleQuery qe = null;
            if (detail == DetailArg.identifier) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SPARQL QUERY (ALL times, detail=" + detail + ") = \n" + detailIdNoTimeQuery));
                    log.debug((Object)("SPARQL QUERY (ALL times, detail=" + detail + ", embedded instances) = \n" + detailIdNoTimeEmbedsQuery));
                }
                q = rc.prepareTupleQuery(QueryLanguage.SPARQL, detailIdNoTimeQuery);
                if (embedded) {
                    qe = rc.prepareTupleQuery(QueryLanguage.SPARQL, detailIdNoTimeEmbedsQuery);
                }
            } else {
                String qsEmbeds;
                String qs = inferred ? detailFullNoTimeQueryWithInferred : detailFullNoTimeQueryNoInferred;
                String string = qsEmbeds = inferred ? detailFullNoTimeQueryEmbedsWithInferred : detailFullNoTimeQueryEmbedsNoInferred;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SPARQL QUERY for TOPLEVEL RESOURCES (ALL times, detail=full, inferred=" + inferred + ") = \n" + qs));
                    log.debug((Object)("SPARQL QUERY for EMBEDDED INSTANCES (ALL times, detail=full, inferred=" + inferred + ") = \n" + qsEmbeds));
                }
                q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
                qe = rc.prepareTupleQuery(QueryLanguage.SPARQL, qsEmbeds);
            }
            q.setIncludeInferred(true);
            q.setDataset((Dataset)resDS);
            if (qe != null) {
                qe.setIncludeInferred(true);
                qe.setDataset((Dataset)resDS);
            }
            out.startQueryResult(detail == DetailArg.identifier ? columnNames.subList(0, 1) : columnNames);
            for (URI graph : resGraphs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Querying Resource Instances from graph=" + graph));
                }
                q.clearBindings();
                q.setBinding("graph", (Value)graph);
                q.evaluate((TupleQueryResultHandler)new StatementsOnlyWrapper(out));
                if (qe == null) continue;
                qe.clearBindings();
                qe.setBinding("graph", (Value)graph);
                qe.evaluate((TupleQueryResultHandler)new StatementsOnlyWrapper(out));
            }
            out.endQueryResult();
        } else {
            String qs;
            String string = qs = resGraphs.contains(REPO.NG_WITHDRAWN) ? deletedNotWithdrawnFromTimeQuery : deletedAndWithdrawnFromTimeQuery;
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL QUERY DELETED and WITHDRAWN (detail=" + detail + ", ?from=" + from + ") = \n" + qs));
            }
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
            q.setDataset((Dataset)resDS);
            q.setIncludeInferred(false);
            q.setBinding("from", (Value)vf.createLiteral(from));
            out.startQueryResult(detail == DetailArg.identifier ? columnNames.subList(0, 1) : columnNames);
            q.evaluate((TupleQueryResultHandler)new DeletedHandler(out, detail));
            String string2 = detail == DetailArg.identifier ? identifierFromTimeQuery : (qs = inferred ? fullFromTimeWithInferredQuery : fullFromTimeNoInferredQuery);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL QUERY top-level instances (detail=" + detail + ", ?from=" + from + ", inferred=" + inferred + ") = \n" + qs));
            }
            q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
            q.setDataset((Dataset)resDS);
            q.setIncludeInferred(true);
            TupleQuery qe = null;
            if (detail == DetailArg.full) {
                String qes;
                String string3 = qes = inferred ? fullEIsFromTimeWithInferredQuery : fullEIsFromTimeNoInferredQuery;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SPARQL QUERY Embedded Instances (detail=" + detail + ", ?from=" + from + ", inferred=" + inferred + ") = \n" + qes));
                }
                qe = rc.prepareTupleQuery(QueryLanguage.SPARQL, qes);
                qe.setDataset((Dataset)resDS);
                qe.setIncludeInferred(true);
            }
            Literal lfrom = vf.createLiteral(from);
            for (URI graph : resGraphs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Getting non-deleted Resource Instances mod. since=" + from + ", from graph=" + graph));
                }
                q.clearBindings();
                q.setBinding("from", (Value)lfrom);
                q.setBinding("graph", (Value)graph);
                q.evaluate((TupleQueryResultHandler)new StatementsOnlyWrapper(out));
                if (qe == null) continue;
                qe.clearBindings();
                qe.setBinding("from", (Value)lfrom);
                qe.setBinding("graph", (Value)graph);
                qe.evaluate((TupleQueryResultHandler)new StatementsOnlyWrapper(out));
            }
            out.endQueryResult();
        }
    }

    static /* synthetic */ List access$000() {
        return columnNames;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ String[] access$200() {
        return column;
    }

    static {
        columnNames = Arrays.asList(column);
        detailIdNoTimeQuery = "SELECT DISTINCT ?subject WHERE {\n GRAPH ?graph {?subject a ?typ}\n GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}}";
        detailIdNoTimeEmbedsQuery = "SELECT DISTINCT ?subject WHERE {\n GRAPH ?graph {?parent a ?typ ; ?pp ?subject }\n GRAPH <" + REPO.NG_METADATA + "> { ?parent <" + DCTERMS.MODIFIED + "> ?mod}\n" + " ?subject a ?eit . ?eit <" + DATAMODEL.IN_CLASS_GROUP + "> <" + DATAMODEL.CLASS_GROUP_EMBEDDED_CLASS + ">}";
        detailFullNoTimeQueryStart = "SELECT ?subject ?predicate ?object WHERE { \n GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n";
        detailFullNoTimeQueryEnd = " OPTIONAL { ?predicate <" + DATAMODEL.IN_PROPERTY_GROUP + "> ?pgad \n" + "    FILTER(?pgad = <" + DATAMODEL.PROPERTY_GROUP_ADMIN_DATA + "> ||\n" + "           ?pgad = <" + DATAMODEL.PROPERTY_GROUP_CONTACT_LOCATION + ">)}\n" + " FILTER(!(BOUND(?pgad))) } ORDER BY ?subject";
        detailFullNoTimeQueryNoInferred = detailFullNoTimeQueryStart + " GRAPH ?graph {?subject a ?typ; ?predicate ?object} \n" + detailFullNoTimeQueryEnd;
        detailFullNoTimeQueryWithInferred = detailFullNoTimeQueryStart + " {GRAPH ?graph {?subject a ?typ; ?predicate ?object}} \n" + " UNION \n" + " {GRAPH ?graph {?subject a ?typ}\n" + "  GRAPH <" + REPO.NG_INFERRED + "> {?subject ?predicate ?object}}\n" + detailFullNoTimeQueryEnd;
        detailFullNoTimeQueryEmbedsStart = "SELECT ?subject ?predicate ?object WHERE { \n GRAPH <" + REPO.NG_METADATA + "> { ?parent <" + DCTERMS.MODIFIED + "> ?mod}\n" + " GRAPH ?graph {?parent a ?ptyp; ?eip ?subject . ?subject a ?typ }\n" + " ?subject a ?eit . ?eit <" + DATAMODEL.IN_CLASS_GROUP + "> <" + DATAMODEL.CLASS_GROUP_EMBEDDED_CLASS + ">\n";
        detailFullNoTimeQueryEmbedsNoInferred = detailFullNoTimeQueryEmbedsStart + " GRAPH ?graph {?subject a ?typ; ?predicate ?object} \n" + detailFullNoTimeQueryEnd;
        detailFullNoTimeQueryEmbedsWithInferred = detailFullNoTimeQueryEmbedsStart + " {GRAPH ?graph {?subject a ?typ; ?predicate ?object}} \n" + " UNION \n" + " {GRAPH ?graph {?subject a ?typ}\n" + "  GRAPH <" + REPO.NG_INFERRED + "> {?subject ?predicate ?object}}\n" + detailFullNoTimeQueryEnd;
        deletedFromTimeQueryProlog = "SELECT DISTINCT ?subject WHERE {\n GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n" + " FILTER(?mod >= ?from)\n" + " OPTIONAL{ GRAPH ?g {?subject a ?t}} \n";
        deletedAndWithdrawnFromTimeQuery = deletedFromTimeQueryProlog + "  FILTER(!bound(?t) || ?g = <" + REPO.NG_WITHDRAWN + ">) }\n" + "ORDER BY ?subject";
        deletedNotWithdrawnFromTimeQuery = deletedFromTimeQueryProlog + "  FILTER(!bound(?t)) }\n" + "ORDER BY ?subject";
        identifierFromTimeQuery = "SELECT DISTINCT ?subject WHERE \n{ GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n" + " FILTER( ?mod >= ?from )" + " GRAPH ?graph {?subject a ?type}} ORDER BY ?mod";
        fullFromTimeQueryStart = "SELECT DISTINCT ?subject ?predicate ?object WHERE {\n GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n";
        fullFromTimeQueryEnd = " OPTIONAL { ?predicate <" + DATAMODEL.IN_PROPERTY_GROUP + "> ?pgad \n" + "     FILTER(?pgad = <" + DATAMODEL.PROPERTY_GROUP_ADMIN_DATA + "> ||\n" + "            ?pgad = <" + DATAMODEL.PROPERTY_GROUP_CONTACT_LOCATION + ">)}\n" + " FILTER(?mod >= ?from && !(BOUND(?pgad))) } ORDER BY ?subject ?mod";
        fullFromTimeWithInferredQuery = fullFromTimeQueryStart + " {{GRAPH <" + REPO.NG_INFERRED + "> {?subject ?predicate ?object}}\n" + "   UNION\n" + "  {GRAPH ?graph {?subject a ?type; ?predicate ?object}}} \n" + fullFromTimeQueryEnd;
        fullFromTimeNoInferredQuery = fullFromTimeQueryStart + " GRAPH ?graph {?subject a ?type; ?predicate ?object} \n" + fullFromTimeQueryEnd;
        fullEIsFromTimeQueryStart = "SELECT DISTINCT ?subject ?predicate ?object WHERE {\n GRAPH <" + REPO.NG_METADATA + "> { ?parent <" + DCTERMS.MODIFIED + "> ?mod}\n" + " GRAPH ?graph {?parent a ?parentType; ?ppred ?subject . \n" + "                ?subject ?predicate ?object} \n" + " ?subject a ?eit . ?eit <" + DATAMODEL.IN_CLASS_GROUP + "> <" + DATAMODEL.CLASS_GROUP_EMBEDDED_CLASS + ">\n";
        fullEIsFromTimeNoInferredQuery = fullEIsFromTimeQueryStart + " GRAPH ?graph {?subject a ?type; ?predicate ?object}\n" + fullFromTimeQueryEnd;
        fullEIsFromTimeWithInferredQuery = fullEIsFromTimeQueryStart + " {{GRAPH <" + REPO.NG_INFERRED + "> {?subject ?predicate ?object}}\n" + "   UNION\n" + "  {GRAPH ?graph {?subject a ?type; ?predicate ?object}}} \n" + fullFromTimeQueryEnd;
    }
}

