/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.workflow.Workflow;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryException;

public class WorkflowClaim
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WorkflowClaim.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String rawURI = null;
        String rawUser = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                File tmp = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
                if (tmp == null) {
                    throw new InternalServerErrorException("Cannot find servlet context attr = \"javax.servlet.context.tempdir\"");
                }
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, tmp));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("user")) {
                        rawUser = item.getString();
                        continue;
                    }
                    if (ifn.equals("uri")) {
                        rawURI = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request", (Throwable)e);
            }
        } else {
            rawUser = request.getParameter("user");
            rawURI = request.getParameter("uri");
        }
        URI uri = Utils.parseURI((String)rawURI, (String)"uri", (boolean)true);
        URI userURI = Utils.parseURI((String)rawUser, (String)"user", (boolean)false);
        URI myself = Authentication.getPrincipalURI((HttpServletRequest)request);
        if (userURI == null) {
            userURI = myself;
        } else if (!myself.equals(userURI) && !Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Claiming on behalf of another user requires administrator access.");
        }
        Workflow wf = Workflow.find((HttpServletRequest)request, (URI)uri);
        if (log.isDebugEnabled()) {
            log.debug((Object)("CLAIM PARAMETERS:\nresource=" + uri + "\nowner=" + userURI + "\nstate=" + wf.getState() + "\nhome graph=" + wf.getHomeGraph()));
        }
        wf.assertClaim(request, userURI);
        try {
            WithRepositoryConnection.get((ServletRequest)request).commit();
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

