/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.View;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WorkflowResources;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;

public class WorkflowResources
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WorkflowResources.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String rawState = null;
        String rawType = null;
        String rawOwner = null;
        String rawUnclaimed = null;
        String rawWorkspace = null;
        String format = null;
        String rawDetail = null;
        String addPattern = null;
        String addResults = null;
        String addModifiers = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                File tmp = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
                if (tmp == null) {
                    throw new InternalServerErrorException("Cannot find servlet context attr = \"javax.servlet.context.tempdir\"");
                }
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, tmp));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("state")) {
                        rawState = item.getString();
                        continue;
                    }
                    if (ifn.equals("type")) {
                        rawType = item.getString();
                        continue;
                    }
                    if (ifn.equals("owner")) {
                        rawOwner = item.getString();
                        continue;
                    }
                    if (ifn.equals("unclaimed")) {
                        rawUnclaimed = item.getString();
                        continue;
                    }
                    if (ifn.equals("workspace")) {
                        rawWorkspace = item.getString();
                        continue;
                    }
                    if (ifn.equals("format")) {
                        format = item.getString();
                        continue;
                    }
                    if (ifn.equals("detail")) {
                        rawDetail = item.getString();
                        continue;
                    }
                    if (ifn.equals("addPattern")) {
                        addPattern = item.getString();
                        continue;
                    }
                    if (ifn.equals("addResults")) {
                        addResults = item.getString();
                        continue;
                    }
                    if (ifn.equals("addModifiers")) {
                        addModifiers = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request", (Throwable)e);
            }
        } else {
            rawState = request.getParameter("state");
            rawType = request.getParameter("type");
            rawOwner = request.getParameter("owner");
            rawUnclaimed = request.getParameter("unclaimed");
            rawWorkspace = request.getParameter("workspace");
            format = request.getParameter("format");
            rawDetail = request.getParameter("detail");
            addPattern = request.getParameter("addPattern");
            addResults = request.getParameter("addResults");
            addModifiers = request.getParameter("addModifiers");
        }
        URI state = null;
        state = rawState == null || rawState.equals("all") ? null : Utils.parseURI((String)rawState, (String)"state", (boolean)false);
        URI type = Utils.parseURI((String)rawType, (String)"type", (boolean)false);
        OwnerArg owner = (OwnerArg)Utils.parseKeywordArg(OwnerArg.class, (String)rawOwner, (String)"owner", (boolean)false, (Enum)OwnerArg.self);
        boolean unclaimed = Utils.parseBooleanParameter((String)rawUnclaimed, (String)"unclaimed", (boolean)false, (boolean)true);
        URI workspace = Utils.parseURI((String)rawWorkspace, (String)"workspace", (boolean)false);
        DetailArg detail = (DetailArg)Utils.parseKeywordArg(DetailArg.class, (String)rawDetail, (String)"detail", (boolean)false, (Enum)DetailArg.full);
        StringBuilder qb = new StringBuilder();
        qb.append("SELECT ?r_subject ?r_label ?r_type ");
        if (detail == DetailArg.full) {
            qb.append("?r_created ?r_owner ?r_ownerLabel ?r_state ");
        }
        if (addResults != null) {
            qb.append(addResults);
        }
        qb.append(" WHERE {\n");
        qb.append("  ?r_subject <").append(REPO.HAS_WORKFLOW_STATE).append("> ?r_state .\n");
        if (state != null) {
            qb.append("  FILTER (?r_state = <").append(state).append(">)\n");
        }
        qb.append(" GRAPH ?atg {?r_subject a ?r_type }\n").append(" FILTER (?atg != <").append(REPO.NG_INFERRED).append(">)\n");
        if (type != null) {
            qb.append(" ?r_subject a <").append(type).append("> .\n");
        }
        qb.append("  OPTIONAL{ ?r_subject <").append(RDFS.LABEL).append("> ?r_label}\n");
        qb.append("  OPTIONAL{ ?r_subject <").append(DCTERMS.CREATED).append("> ?r_created }\n");
        qb.append("  OPTIONAL{ ?r_subject <").append(REPO.HAS_WORKFLOW_OWNER).append("> ?r_owner .\n");
        qb.append("    OPTIONAL{ ?r_owner <").append(RDFS.LABEL).append("> ?r_ownerLabel }} \n");
        if (unclaimed && owner != OwnerArg.all) {
            qb.append("  FILTER (!BOUND(?r_owner)");
            if (owner == OwnerArg.self) {
                qb.append(" || ?r_owner = <").append(Authentication.getPrincipalURI((HttpServletRequest)request)).append(">\n");
            }
            qb.append(")\n");
        } else if (!unclaimed) {
            qb.append("  FILTER (");
            if (owner == OwnerArg.self) {
                qb.append("?r_owner = <").append(Authentication.getPrincipalURI((HttpServletRequest)request)).append(">\n");
            } else if (owner == OwnerArg.all) {
                qb.append("BOUND(?r_owner)");
            } else {
                throw new BadRequestException("Illegal combination of options: specifying unclaimed=false and owner=none would never produce any results.");
            }
            qb.append(")\n");
        }
        if (addPattern != null) {
            qb.append(addPattern);
        }
        qb.append("}");
        if (addModifiers != null) {
            qb.append(" ").append(addModifiers);
        }
        String query = qb.toString();
        log.debug((Object)("SPARQL QUERY to gather WORKFLOW RESOURCES = \n" + query));
        DatasetImpl ds = new DatasetImpl();
        if (workspace != null) {
            View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)ds, (URI)workspace);
        } else {
            View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)View.USER);
        }
        SPARQL.tupleQueryRequest((HttpServletRequest)request, (HttpServletResponse)response, (String)query, (String)format, (Dataset)ds);
    }
}

