<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  Admin - display and edit the properties of a single Role
   -  REQUIRED ARGS:
   -   uri - OR - create
   -  ARGS TO CHANGE PROPERTIES:
   -   label = textual label for the graph
   -   comment = description
   -   submit
  --%>
<%@ page import="java.io.IOException" %>
<%@ page import="java.util.Arrays" %>
<%@ page import="java.util.Collection" %>
<%@ page import="javax.servlet.http.HttpServletResponse" %>

<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>

<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.openrdf.model.Literal" %>
<%@ page import="org.openrdf.model.Value" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.model.impl.URIImpl" %>

<%@ page import="org.eaglei.repository.NamedGraph" %>
<%@ page import="org.eaglei.repository.Role" %>
<%@ page import="org.eaglei.repository.Provenance" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>
<%@ page import="org.eaglei.repository.status.NotFoundException" %>
<%@ page import="org.eaglei.repository.util.Utils" %>

  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <title>Eagle-I Data Repository Admin - Edit Access Role</title>
    <style type="text/css">
        .ei_required { color: red; }
    </style>
  </head>

<%
    try {
        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");

        // feedback message about status of any chosen operation
        String message = null;
        boolean messageSuccess = false;

        request.setCharacterEncoding("UTF-8");
        boolean createp = request.getParameter("create") != null;
        String uri = request.getParameter("uri");
        if (uri != null && uri.trim().length() == 0)
            uri = null;
        String label = request.getParameter("label");
        if (label == null)
            label = "";
        String comment = request.getParameter("comment");
        if (comment == null)
            comment = "";

        // required-style - only turn on 'red' on when creating new Role
        String reqStyle = createp ? "class=\"ei_required\"" : "";

        // sanity-check args
        if (!createp && (uri == null || uri.length() == 0)) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'uri'");
            return;
        }

        // execute request if 'submit' set
        if (request.getParameter("submit") != null) {
            if (label == null || label.length() == 0) {
                response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'label'");
                return;
            }
            Role result = null;

            if (createp) {
                result = Role.create(request, uri == null ? null : new URIImpl(uri),
                                     label, comment);
                messageSuccess = true;
                message = "Role has been created.";
                uri = result.getURI().stringValue();
                createp = false;
            } else {
                result = Role.find(request, new URIImpl(uri));
                if (result == null)
                    throw new NotFoundException("No such role, uri="+uri);
                result.setLabel(request, label);
                result.setComment(request, comment);
                messageSuccess = true;
                message = "Role has been modified.";
            }
            result.commit(request);

        // if this is the first load of the page, initialize values
        } else if (!createp) {
            Role r = Role.find(request, new URIImpl(uri));
            label = r.getLabel();
            comment = r.getComment();
            if (comment == null)
                comment = "";
        }
        String verb = createp ? "Create" : "Edit";
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2 align="center"><%= verb %> Access Role</h2>
<%
    if (uri != null) {
%>
    <h3 align="center"><tt><%= StringEscapeUtils.escapeHtml(uri) %></tt></h3>
<%
    }
    if (message != null) {
%>
      <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
     </h3>
<%
    }
%>

    <form action="">
      <fieldset style="width: 80%; align: center;">
       <legend><b>Enter Role Properties</b></legend>
<%
    if (createp) {
%>
       <input type="hidden" name="create" value="true"/>
       <p><b>URI:</b> <input type="text" name="uri" size="50" value=""/>
       <br><i>This is <b>optional</b>, only fill in if you want a specific URI for the Role.
            It must not be used for any other object.</i>
       </p>
<%
    } else {
%>
       <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(uri) %>"/>
<%
    }
%>
       <p><span <%= reqStyle %>><b>Label:</b></span> <input type="text" name="label" size="50" value="<%= Utils.escapeHTMLAttribute(label) %>"/>
<%
    if (createp) {
%>
       <br><i>REQUIRED when creating a new Role.</i>
<%
    }
%>
       </p>
       <p><b>Description:</b> <input type="text" name="comment" size="80" value="<%= Utils.escapeHTMLAttribute(comment) %>"/>
       </p>
        <div width="50%" align="left">
          <div width="50%" align="center">
            <button type="reset">Reset Form</button>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <button name="submit" value="submit" type="submit">Submit</button>
          </div>
        </div>
      </fieldset>
    </form>

    <p></p>
    <p>
    <a href="/repository/admin/roles.jsp">Return to list of Access Roles</a>
    </p>
    <p>
    <a href="/repository/admin/editRole.jsp?create">Create a New Role</a>
    </p>
    <p>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
    </p>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
