<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%@ page import="java.util.Set" %>
<%@ page import="java.util.Map" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.openrdf.query.Dataset" %>
<%@ page import="org.openrdf.query.impl.DatasetImpl" %>
<%@ page import="org.openrdf.model.Literal" %>
<%@ page import="org.openrdf.model.Value" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.model.vocabulary.RDFS" %>
<%@ page import="org.openrdf.query.BindingSet" %>
<%@ page import="org.openrdf.query.TupleQuery" %>
<%@ page import="org.openrdf.query.TupleQueryResultHandler" %>
<%@ page import="org.openrdf.query.TupleQueryResultHandlerBase" %>
<%@ page import="org.openrdf.query.TupleQueryResultHandlerException" %>
<%@ page import="org.openrdf.query.QueryLanguage" %>
<%@ page import="org.openrdf.query.MalformedQueryException" %>
<%@ page import="org.openrdf.OpenRDFException" %>
<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.openrdf.repository.RepositoryException" %>
<%@ page import="org.eaglei.repository.DataRepository" %>
<%@ page import="org.eaglei.repository.NamedGraph" %>
<%@ page import="org.eaglei.repository.View" %>
<%@ page import="org.eaglei.repository.vocabulary.REPO" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<%
    // allow this page to be cached, so field selections don't get reset
    // when you use the "Back" button on the browser:
    response.setHeader("Cache-Control", "max-age="+String.valueOf(12*60*60)+
                ", public");
    response.setHeader("Pragma", "none");
%>
 <head>
  <title>SPARQL Protocol Query Workbench</title>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
 <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js"></script>
 <script type="text/javascript">

 function addQueryHandlers() {
                                                
   $("#MacroSelect").change(function() {
           $("#QueryTextbox").text($("#QueryTextbox").val() + "\n" + $("#MacroSelect").val() + "\n");
           $("#MacroSelect").val("");
           $("#QueryTextbox").focus();
        });

   $("#view").change(function() {
           $("#workspace").val("");
           $("#default-graph-uri").val("");
           $("#named-graph-uri").val("");
   });

   $("#workspace").change(function() {
           $("#view").val("");
           $("#default-graph-uri").val("");
           $("#named-graph-uri").val("");
   });

   $("#default-graph-uri").change(function() {
           $("#view").val("");
           $("#workspace").val("");

   });

   $("#named-graph-uri").change(function() {
           $("#view").val("");
           $("#workspace").val("");

   });
   
 }

   $(document).ready(addQueryHandlers);
                                      
 </script>

 </head>
<%
    try {
%>
 <body>
   <h2>SPARQL Query Workbench</h2>
   <h3><%= StringEscapeUtils.escapeHtml(DataRepository.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property eaglei.repository.title needs to be set)")) %>
   </h3>
   <hr>

   <form accept-charset="UTF-8" action="/repository/sparql" method="POST">

<%! private static Logger log = LogManager.getLogger("org.eaglei.repository.query.index.jsp"); %>
<%!
    /** handler to print an <option> tag for each result */
    private static class queryHandler extends TupleQueryResultHandlerBase
    {
        private RepositoryConnection rc = null;
        private int count = 0;
        private StringBuilder w = new StringBuilder();

        public queryHandler(RepositoryConnection rc)
        {
            super();
            queryHandler.this.rc = rc;
        }
        // columns: label text
        public void handleSolution(BindingSet bs)
            throws TupleQueryResultHandlerException
        {
            Value label = bs.getValue("label");
            Value text = bs.getValue("text");
            if (label == null || text == null ||
                  !((text instanceof Literal) && (label instanceof Literal)))
                log.warn("Skipping incorrect query definition (label and query are not literals): label="+label+", text="+text);
            else {
                ++count;
                w.append("<option value=\"").append(StringEscapeUtils.escapeHtml(((Literal)text).getLabel())).
                  append("\">").append(StringEscapeUtils.escapeHtml(((Literal)label).getLabel())).
                  append("</option>\n");
            }
        }
        public int size() { return count; }
        public String toString() { return w.toString(); }
    }
%>

<%-- Query that picks up the macro definitions:
  -
  - SELECT ?l ?t FROM :NG_Query WHERE { ?s a :QueryMacro; rdfs:label ?l; :query ?t }
  -
  - Example macros defined (in n3):
  -
  - :macros
  -   rdf:_1 [
  -     a :QueryMacro;
  -     rdfs:label "first macro";
  -     :query "text of query macro string here" ];
  -   rdf:_2 [
  -     a :QueryMacro;
  -     rdfs:label "second macro";
  -     :query "more macro here, don't forget to escape quotes" ].
  --%>
<b>&nbsp;&nbsp;Query:</b>(<i><a href="http://www.w3.org/TR/rdf-sparql-query/">Click for SPARQL help</a></i>)
&nbsp;&nbsp;&nbsp;&nbsp; <select id="MacroSelect" name="macro">
<%
    String query =
      "SELECT DISTINCT ?label ?text WHERE { "+
      "?s a <"+REPO.QUERY_MACRO+">; <"+RDFS.LABEL+"> ?label; <"+REPO.QUERY+"> ?text }";
    RepositoryConnection rc = WithRepositoryConnection.get(request);
    queryHandler qh = new queryHandler(rc);
    try {
        TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query);
        DatasetImpl ds = new DatasetImpl();
        ds.addDefaultGraph(REPO.NG_QUERY);
        q.setDataset(ds);
        q.evaluate(qh);
    } catch (MalformedQueryException e) {
        log.info("Rejecting malformed query: "+e);
        response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "Malformed query was generated internally: "+e.toString());
    } catch (OpenRDFException e) {
        log.error(e);
        throw new ServletException(e);
    }
    if (qh.size() > 0) {
%>
  <option selected value=""> Add Query Macro </option>
  <%= StringEscapeUtils.escapeHtml(qh.toString()) %>
<%
    } else {
%>
 <option selected value=""> (No Query Macros Defined) </option>
<%
    }
%>
</select>
<br/>
<textarea name="query" id="QueryTextbox" cols="80" rows="8">PREFIX rdf: &lt;http://www.w3.org/1999/02/22-rdf-syntax-ns#&gt;
PREFIX rdfs: &lt;http://www.w3.org/2000/01/rdf-schema#&gt;
PREFIX owl: &lt;http://www.w3.org/2002/07/owl#&gt;
PREFIX dcterms: &lt;http://purl.org/dc/terms/&gt;
PREFIX : <http://eagle-i.org/ont/repo/1.0/>
</textarea>

<fieldset>
<legend><b>Choose Dataset</b></legend>
<i>You must make a choice in <b>ONLY ONE</b> of the Default Graph,
Named Graph, View <u>or</u> Workspace selectors.</i>

<br><b>View:</b> <select id="view" name="view">
<option selected value="">--none--</option>
<%
    for (View vw : View.values()) {
%>
        <option value="<%= Utils.escapeHTMLAttribute(vw.getLabel()) %>"><%= StringEscapeUtils.escapeHtml(vw.getTitle()) %></option>
<%
    }
%>
</select>
<br><b>Workspace:</b> <select id="workspace" name="workspace">
<option selected value="">--none--</option>
<%
    Set<Map.Entry<String,URI>> ws = View.getAllWorkspaceGraphs(request).entrySet();
    for (Map.Entry<String,URI> we : ws) {
%>
        <option value="<%= Utils.escapeHTMLAttribute(we.getValue().toString()) %>"><%= StringEscapeUtils.escapeHtml(we.getKey()) %> (<%= StringEscapeUtils.escapeHtml(we.getValue().getLocalName()) %>)</option>
<%
    }
%>
</select>

<table>
 <tr><th align="left" width="50%">Default Graph:</th>
     <th align="left" width="50%">Named Graph:</th></tr>
<tr><td>
  <select name="default-graph-uri" id="default-graph-uri" multiple="true" size="6">
  <option selected value="">--none--</option>
  <%
      Iterable<NamedGraph> namedGraphs = NamedGraph.findAll(request);
      for (NamedGraph ng : namedGraphs) {
  %>
  <option value="<%= Utils.escapeHTMLAttribute(ng.getName().toString()) %>">
   <%= StringEscapeUtils.escapeHtml(ng.getName().getLocalName())+" ("+StringEscapeUtils.escapeHtml(ng.getLabel())+")" %>
  </option>
  <%
      }
  %>
</td><td>
  </select>
   
  <select name="named-graph-uri" id="named-graph-uri" multiple="true" size="6">
  <option selected value="">--none--</option>
  <%
      for (NamedGraph ng : namedGraphs) {
  %>
  <option value="<%= Utils.escapeHTMLAttribute(ng.getName().toString()) %>">
   <%= StringEscapeUtils.escapeHtml(ng.getName().getLocalName())+" ("+StringEscapeUtils.escapeHtml(ng.getLabel())+")" %>
  </option>
  <%
      }
  %>
  </select>
</td></tr>
 <tr><td colspan="2"><i>You may select multiple graphs
       multiple graphs from one or both of these columns.</i></td></tr>
</table>
</fieldset>

<br><b>Output Format:</b>
<select name="format">
<option selected="selected" value="text/html">HTML</option>
<option value="application/xml">XML</option>
<option value="text/plain">Plain Text (TSV or N-Triples)</option>
<optgroup label="SELECT queries only:">
 <option value="application/sparql-results+json">JSON</option>
 <option value="application/sparql-results+xml">XML SPARQL Result</option>
</optgroup>
<optgroup label="CONSTRUCT/DESCRIBE queries only:">
 <option value="application/rdf+xml">RDF/XML</option>
 <option value="text/rdf+n3">RDF/N3</option>
 <option value="application/x-turtle">RDF/TURTLE</option>
 <option value="application/x-trig">TriG</option>
 <option value="application/trix">TriX (silly rabbit)</option>
 <option value="text/rdf+nquads">RDF/NQuads (write-only, non-standard)</option>
</optgroup>
<optgroup label="ASK queries only:">
 <option value="text/boolean">Boolean in Plain Text</option>
</optgroup>
</select>
&nbsp;&nbsp;<b>No Inferred:</b> <input name="inferred" type="checkbox" value="false"/>
&nbsp;&nbsp;<b>Time Limit:</b> <input name="time" type="text" size="4"/>
 <i>(Sec) <b>(Not Impl.)</b></i>
<br>
<br>
<input value="Clear Form!" type="reset">
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
<input value="Get Results" type="submit">

      </form>
<br/>
<a href="/repository/admin/index.jsp">Return to Admin top level</a>
</body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>

</html>
