package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.Role;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.DataRepository;
import org.apache.commons.lang.StringEscapeUtils;

public final class editRole_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  <head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n    <title>Eagle-I Data Repository Admin - Edit Access Role</title>\n    <style type=\"text/css\">\n        .ei_required { color: red; }\n    </style>\n  </head>\n\n");

    try {
        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");

        // feedback message about status of any chosen operation
        String message = null;
        boolean messageSuccess = false;

        request.setCharacterEncoding("UTF-8");
        boolean createp = request.getParameter("create") != null;
        String uri = request.getParameter("uri");
        if (uri != null && uri.trim().length() == 0)
            uri = null;
        String label = request.getParameter("label");
        if (label == null)
            label = "";
        String comment = request.getParameter("comment");
        if (comment == null)
            comment = "";

        // required-style - only turn on 'red' on when creating new Role
        String reqStyle = createp ? "class=\"ei_required\"" : "";

        // sanity-check args
        if (!createp && (uri == null || uri.length() == 0)) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'uri'");
            return;
        }

        // execute request if 'submit' set
        if (request.getParameter("submit") != null) {
            if (label == null || label.length() == 0) {
                response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'label'");
                return;
            }
            Role result = null;

            if (createp) {
                result = Role.create(request, uri == null ? null : new URIImpl(uri),
                                     label, comment);
                messageSuccess = true;
                message = "Role has been created.";
                uri = result.getURI().stringValue();
                createp = false;
            } else {
                result = Role.find(request, new URIImpl(uri));
                if (result == null)
                    throw new NotFoundException("No such role, uri="+uri);
                result.setLabel(request, label);
                result.setComment(request, comment);
                messageSuccess = true;
                message = "Role has been modified.";
            }
            result.commit(request);

        // if this is the first load of the page, initialize values
        } else if (!createp) {
            Role r = Role.find(request, new URIImpl(uri));
            label = r.getLabel();
            comment = r.getComment();
            if (comment == null)
                comment = "";
        }
        String verb = createp ? "Create" : "Edit";

      out.write("\n  <body>\n    ");
      out.write('\n');
      out.write("\n\n\n<hr/>\n  <table border=\"0\" width=\"100%\" >\n    <tr>\n      <td width=\"30%\">\n        <a href=\"/repository/admin/\">\n          <img border=\"0\" alt=\"Institutional Logo\" align=\"right\" src=\"");
      out.print( DataRepository.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" />\n        </a>\n      </td>\n      <td width=\"70%\"><div align=\"center\">\n            <font size=\"+1\" color=\"black\">\n              ");
      out.print( StringEscapeUtils.escapeHtml(DataRepository.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)")) );
      out.write("</p>\n            </font>\n        </div>\n        <div align=\"center\" style=\"margin-top: 0.5em;\">Data Repository Administration</div>\n      </td>\n    </tr>\n  </table>\n<hr/>\n");
      out.write("\n    <h2 align=\"center\">");
      out.print( verb );
      out.write(" Access Role</h2>\n");

    if (uri != null) {

      out.write("\n    <h3 align=\"center\"><tt>");
      out.print( StringEscapeUtils.escapeHtml(uri) );
      out.write("</tt></h3>\n");

    }
    if (message != null) {

      out.write("\n      <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n          ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("\n          </font>\n     </h3>\n");

    }

      out.write("\n\n    <form action=\"\">\n      <fieldset style=\"width: 80%; align: center;\">\n       <legend><b>Enter Role Properties</b></legend>\n");

    if (createp) {

      out.write("\n       <input type=\"hidden\" name=\"create\" value=\"true\"/>\n       <p><b>URI:</b> <input type=\"text\" name=\"uri\" size=\"50\" value=\"\"/>\n       <br><i>This is <b>optional</b>, only fill in if you want a specific URI for the Role.\n            It must not be used for any other object.</i>\n       </p>\n");

    } else {

      out.write("\n       <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute(uri) );
      out.write("\"/>\n");

    }

      out.write("\n       <p><span ");
      out.print( reqStyle );
      out.write("><b>Label:</b></span> <input type=\"text\" name=\"label\" size=\"50\" value=\"");
      out.print( Utils.escapeHTMLAttribute(label) );
      out.write("\"/>\n");

    if (createp) {

      out.write("\n       <br><i>REQUIRED when creating a new Role.</i>\n");

    }

      out.write("\n       </p>\n       <p><b>Description:</b> <input type=\"text\" name=\"comment\" size=\"80\" value=\"");
      out.print( Utils.escapeHTMLAttribute(comment) );
      out.write("\"/>\n       </p>\n        <div width=\"50%\" align=\"left\">\n          <div width=\"50%\" align=\"center\">\n            <button type=\"reset\">Reset Form</button>\n            &nbsp;&nbsp;&nbsp;&nbsp;\n            <button name=\"submit\" value=\"submit\" type=\"submit\">Submit</button>\n          </div>\n        </div>\n      </fieldset>\n    </form>\n\n    <p></p>\n    <p>\n    <a href=\"/repository/admin/roles.jsp\">Return to list of Access Roles</a>\n    </p>\n    <p>\n    <a href=\"/repository/admin/editRole.jsp?create\">Create a New Role</a>\n    </p>\n    <p>\n    <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n    </p>\n  </body>\n");

    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
