package org.eaglei.repository.servlet;

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.repository.RepositoryException;

import org.eaglei.repository.status.ErrorSendingException;

/**
 *
 *
 *
 * XXX TODO: doc to explain how this interoperates with runtime excep.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class RepositoryServlet extends HttpServlet {

    private static Logger log = LogManager.getLogger(RepositoryServlet.class);

    /** {@inheritDoc} */
    protected void service(HttpServletRequest req, HttpServletResponse resp)
        throws ServletException, IOException
    {
        String reqURI = req.getRequestURI();
        boolean finished = false;
        long startMs = System.currentTimeMillis();
        try {
            // make log files easier to trace
            if (log.isDebugEnabled())
                log.debug("============== Starting Request "+reqURI);
            super.service(req, resp);
            finished = true;

        // Servlets can throw BadRequetException to elicit a
        // 400 response, since ServletException results in 500..
        // Same mechanism for ForbiddenEx. and NotFoundEx.
        } catch (ErrorSendingException e) {
            // pass this exception to error.jsp through attribute
            req.setAttribute("org.eaglei.repository.error.exception", e);
            if (resp.isCommitted()) {
                log.fatal("Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
            }
            try {
                resp.sendError(e.getStatus(), e.getMessage());
            } catch (IllegalStateException ie) {
                log.error("Cannot convert Status Exception to appropriate status because response is in wrong state.  Original exception="+e.toString(), ie);
            }
        } catch (ServletException e) {
            if (resp.isCommitted()) {
                log.fatal("Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
            }
            throw e;
        } catch (RuntimeException e) {
            if (resp.isCommitted()) {
                log.fatal("Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
            }
            throw e;
        } finally {
            // rollback now, prevents Sesame from logging errors at rc close.
            if (!finished) {
                try {
                    WithRepositoryConnection.get(req).rollback();
                } catch (RepositoryException re) {
                    log.warn("Failed in rollback after error: "+re);
                }
            }
            if (log.isDebugEnabled())
                log.debug(String.format("============== Ending Request %s (%,d mSec elapsed)",reqURI, System.currentTimeMillis()-startMs));
        }
    }
}
