/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.ErrorSendingException;
import org.openrdf.repository.RepositoryException;

public class RepositoryServlet
extends HttpServlet {
    private static Logger log = LogManager.getLogger(RepositoryServlet.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long startMs;
        boolean finished;
        String reqURI;
        block18: {
            reqURI = req.getRequestURI();
            finished = false;
            startMs = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("============== Starting Request " + reqURI));
            }
            super.service(req, resp);
            finished = true;
            if (finished) break block18;
            try {
                WithRepositoryConnection.get((ServletRequest)req).rollback();
            }
            catch (RepositoryException re) {
                log.warn((Object)("Failed in rollback after error: " + (Object)((Object)re)));
            }
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)String.format("============== Ending Request %s (%,d mSec elapsed)", reqURI, System.currentTimeMillis() - startMs));
        return;
        catch (ErrorSendingException e) {
            block19: {
                req.setAttribute("org.eaglei.repository.error.exception", (Object)e);
                if (resp.isCommitted()) {
                    log.fatal((Object)"Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
                }
                try {
                    resp.sendError(e.getStatus(), e.getMessage());
                }
                catch (IllegalStateException ie) {
                    log.error((Object)("Cannot convert Status Exception to appropriate status because response is in wrong state.  Original exception=" + e.toString()), (Throwable)ie);
                }
                if (finished) break block19;
                {
                    catch (Throwable throwable) {
                        if (!finished) {
                            try {
                                WithRepositoryConnection.get((ServletRequest)req).rollback();
                            }
                            catch (RepositoryException re) {
                                log.warn((Object)("Failed in rollback after error: " + (Object)((Object)re)));
                            }
                        }
                        if (!log.isDebugEnabled()) throw throwable;
                        log.debug((Object)String.format("============== Ending Request %s (%,d mSec elapsed)", reqURI, System.currentTimeMillis() - startMs));
                        throw throwable;
                    }
                }
                try {
                    WithRepositoryConnection.get((ServletRequest)req).rollback();
                }
                catch (RepositoryException re) {
                    log.warn((Object)("Failed in rollback after error: " + (Object)((Object)re)));
                }
            }
            if (!log.isDebugEnabled()) return;
            log.debug((Object)String.format("============== Ending Request %s (%,d mSec elapsed)", reqURI, System.currentTimeMillis() - startMs));
            return;
            catch (ServletException e2) {
                if (!resp.isCommitted()) throw e2;
                log.fatal((Object)"Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
                throw e2;
                catch (RuntimeException e3) {
                    if (!resp.isCommitted()) throw e3;
                    log.fatal((Object)"Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
                    throw e3;
                }
            }
        }
    }
}

