/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.auth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthUser {
    private static Logger log = LogManager.getLogger(AuthUser.class);
    private static final String AUTH_DATASOURCE = "jdbc/eaglei";
    private String username;
    private String password;
    private boolean isSuperuser;
    private String oldPassword;
    private boolean oldIsSuperuser;
    public static final String SUPERUSER_ROLE_NAME = "superuser";

    private AuthUser(String u, String p, boolean s) {
        this.username = u;
        this.oldPassword = this.password = p;
        this.oldIsSuperuser = this.isSuperuser = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthUser find(String targetUsername) throws NamingException, SQLException {
        Connection c = null;
        PreparedStatement s = null;
        try {
            c = AuthUser.getConnection();
            s = c.prepareStatement("SELECT Users.Username,Users.Password,Roles.Rolename  FROM Users LEFT OUTER JOIN Roles  ON Users.Username = Roles.Username     AND Roles.Rolename = 'superuser' WHERE Users.Username = ?");
            s.setString(1, targetUsername);
            ResultSet r = s.executeQuery();
            int count = 0;
            AuthUser result = null;
            while (r.next()) {
                boolean isAdmin;
                String dusername = r.getString(1);
                String dpassword = r.getString(2);
                String role = r.getString(3);
                boolean bl = isAdmin = role != null && "superuser".equalsIgnoreCase(role);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got row, user=" + dusername + ", passwd=" + dpassword + ", role=" + role));
                }
                ++count;
                if (result == null) {
                    result = new AuthUser(dusername, dpassword, isAdmin);
                    continue;
                }
                log.error((Object)("Got extra results from single user query: user=" + dusername + ", pw=" + dpassword + ", role=" + role));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed " + String.valueOf(count) + " rows of results."));
            }
            AuthUser authUser = result;
            return authUser;
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, AuthUser> findAllAsMap() throws NamingException, SQLException {
        HashMap<String, AuthUser> result = new HashMap<String, AuthUser>();
        Connection c = null;
        PreparedStatement s = null;
        try {
            c = AuthUser.getConnection();
            s = c.prepareStatement("SELECT Users.Username,Users.Password,Roles.Rolename  FROM Users LEFT OUTER JOIN Roles  ON Users.Username = Roles.Username AND Roles.Rolename = 'superuser'");
            ResultSet r = s.executeQuery();
            while (r.next()) {
                boolean isAdmin;
                String dusername = r.getString(1);
                String role = r.getString(3);
                boolean bl = isAdmin = role != null && "superuser".equalsIgnoreCase(role);
                if (result.containsKey(dusername)) {
                    log.error((Object)("Got duplicate SQL result for user=" + dusername + ", role=" + role));
                    continue;
                }
                String dpassword = r.getString(2);
                result.put(dusername, new AuthUser(dusername, dpassword, isAdmin));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Got new user, user=" + dusername + ", passwd=" + dpassword + ", role=" + role));
            }
            HashMap<String, AuthUser> hashMap = result;
            return hashMap;
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAllUsernames() throws NamingException, SQLException {
        Connection c = null;
        PreparedStatement s = null;
        HashSet<String> result = new HashSet<String>();
        try {
            c = AuthUser.getConnection();
            s = c.prepareStatement("SELECT DISTINCT Username FROM Users");
            ResultSet r = s.executeQuery();
            while (r.next()) {
                result.add(r.getString(1));
            }
            log.debug((Object)("getAllUsernames found  count=" + result.size()));
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    public static Connection startTransaction() throws NamingException, SQLException {
        Connection c = AuthUser.getConnection();
        c.setAutoCommit(false);
        return c;
    }

    public static void commitTransaction(Connection c) throws NamingException, SQLException {
        log.debug((Object)"Committing current transaction..");
        c.commit();
        c.close();
    }

    public static void abortTransaction(Connection c) throws NamingException, SQLException {
        c.rollback();
        c.close();
    }

    private static void nameCheck(String s, String field) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) && c < '\u0100' || c == '~' || c == '@' || c == '#' || c == '$' || c == '%' || c == '_' || c == '-' || c == '.') continue;
            throw new IllegalArgumentException(field + " contains an illegal character: '" + c + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(Connection c, String ausername, String apassword, boolean aisSuperuser) throws NamingException, SQLException {
        AuthUser.nameCheck((String)ausername, (String)"Username");
        AuthUser.nameCheck((String)apassword, (String)"Password");
        if (ausername.length() == 0) {
            throw new IllegalArgumentException("Username may not be empty.");
        }
        PreparedStatement iu = null;
        Statement ia = null;
        Statement ir = null;
        try {
            iu = c.prepareStatement("INSERT INTO Users (Username, Password) VALUES (?, ?)");
            iu.setString(1, ausername);
            iu.setString(2, apassword);
            if (iu.executeUpdate() != 1) {
                throw new SQLException("INSERT INTO Users failed, row count incorrect.");
            }
            ia = c.prepareStatement("INSERT INTO Roles (RoleName, Username) VALUES ('authenticated', ?)");
            ia.setString(1, ausername);
            if (ia.executeUpdate() != 1) {
                throw new SQLException("INSERT INTO Roles failed, row count incorrect.");
            }
            if (aisSuperuser) {
                ir = c.prepareStatement("INSERT INTO Roles (RoleName, Username) VALUES (?, ?)");
                ir.setString(1, "superuser");
                ir.setString(2, ausername);
                if (ir.executeUpdate() != 1) {
                    throw new SQLException("INSERT INTO Roles failed, row count incorrect.");
                }
            }
            log.debug((Object)("Created Auth DB entries for user=" + ausername));
        }
        finally {
            if (iu != null) {
                iu.close();
            }
            if (ia != null) {
                ia.close();
            }
            if (ir != null) {
                ir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws NamingException, SQLException {
        if (this.password.equals(this.oldPassword) && this.isSuperuser == this.oldIsSuperuser) {
            return;
        }
        Connection c = null;
        try {
            c = AuthUser.getConnection();
            c.setAutoCommit(false);
            this.update(c);
            c.commit();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection c) throws NamingException, SQLException {
        if (this.password.equals(this.oldPassword) && this.isSuperuser == this.oldIsSuperuser) {
            return;
        }
        Statement iu = null;
        Statement ir = null;
        try {
            if (!this.password.equals(this.oldPassword)) {
                iu = c.prepareStatement("UPDATE Users SET Password = ? WHERE Username = ?");
                iu.setString(1, this.password);
                iu.setString(2, this.username);
                if (iu.executeUpdate() != 1) {
                    throw new SQLException("UPDATE Users failed, row count incorrect.");
                }
            }
            if (this.isSuperuser != this.oldIsSuperuser) {
                ir = c.prepareStatement(this.isSuperuser ? "INSERT INTO Roles (Username, RoleName) VALUES (?, ?)" : "DELETE FROM Roles WHERE (Username = ?) AND (rolename = ?)");
                ir.setString(1, this.username);
                ir.setString(2, "superuser");
                if (ir.executeUpdate() != 1) {
                    throw new SQLException("Update: Modification of Roles failed, row count incorrect.");
                }
            }
            log.debug((Object)("Updated Auth DB entries for user=" + this.username));
        }
        finally {
            if (iu != null) {
                iu.close();
            }
            if (ir != null) {
                ir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Connection c) throws NamingException, SQLException {
        Statement du = null;
        PreparedStatement dr = null;
        try {
            dr = c.prepareStatement("DELETE FROM Roles WHERE Username = ?");
            du = c.prepareStatement("DELETE FROM Users WHERE Username = ?");
            du.setString(1, this.username);
            dr.setString(1, this.username);
            dr.executeUpdate();
            if (du.executeUpdate() != 1) {
                throw new SQLException("Update: Modification of Users failed, row count incorrect.");
            }
        }
        finally {
            if (du != null) {
                du.close();
            }
            if (dr != null) {
                dr.close();
            }
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSuperuser() {
        return this.isSuperuser;
    }

    public void setPassword(String pw) {
        AuthUser.nameCheck((String)pw, (String)"Password");
        this.password = pw;
    }

    public boolean authenticate(String pw) {
        return this.password != null && this.password.equals(pw);
    }

    public void setIsSuperuser(boolean su) {
        this.isSuperuser = su;
    }

    private static Connection getConnection() throws NamingException, SQLException {
        InitialContext initContext = new InitialContext();
        Context envContext = (Context)initContext.lookup("java:/comp/env");
        DataSource ds = (DataSource)envContext.lookup("jdbc/eaglei");
        return ds.getConnection();
    }
}

