/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.rid;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.rid.RIDSequence;
import org.eaglei.repository.rid.SystemTimeProvider;
import org.eaglei.repository.rid.TimeProvider;

public final class RIDGenerator {
    private static Logger logger = LogManager.getLogger(RIDGenerator.class);
    private static final RIDGenerator singleton = new RIDGenerator();
    private long previousTime;
    private int clockID = 0;
    private int sequence = Integer.MIN_VALUE;
    private TimeProvider tp = null;
    public boolean flag = false;

    private RIDGenerator() {
        if (singleton != null) {
            throw new RuntimeException("Encountered RIDGenerator singleton contract violation attempt!");
        }
        this.tp = new SystemTimeProvider();
        this.init();
    }

    protected RIDGenerator(TimeProvider testTP) {
        this.tp = testTP;
        this.init();
    }

    public static RIDGenerator getInstance() {
        return singleton;
    }

    private void init() {
        byte[] bytes = new byte[4];
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn((Object)"RIDGenerator: Falling back to default random generator...");
            secureRandom = new SecureRandom();
        }
        secureRandom.nextBytes(bytes);
        this.clockID = 0;
        this.clockID |= bytes[0] & 0xFF;
        this.clockID <<= 8;
        this.clockID |= bytes[1] & 0xFF;
        this.clockID <<= 8;
        this.clockID |= bytes[2] & 0xFF;
        this.clockID <<= 8;
        this.clockID |= bytes[3] & 0xFF;
        logger.info((Object)("Initialized RID clock-id to:" + this.clockID));
    }

    private void resetSequence() {
        this.sequence = Integer.MIN_VALUE;
    }

    private void resetClockID() {
        this.clockID = Integer.MIN_VALUE;
    }

    private void setPreviousTime(long value) {
        this.previousTime = value;
    }

    private long getPreviousTime() {
        return this.previousTime;
    }

    private int getSequence() {
        return this.sequence;
    }

    private void incrementSequence() {
        ++this.sequence;
    }

    private int getClockID() {
        return this.clockID;
    }

    private void incrementClockID() {
        if (this.clockID < Integer.MAX_VALUE) {
            ++this.clockID;
        } else {
            this.resetClockID();
        }
        logger.info((Object)("Incremented clock-id, value now:" + this.clockID));
    }

    private long getTime() {
        return this.tp.timeNow();
    }

    private void increaseSequenceBy(int anAmount) {
        this.sequence += anAmount;
    }

    private boolean hasSequencesLeft(int anAmount) {
        return Integer.MAX_VALUE - anAmount >= this.sequence;
    }

    public boolean isUUID() {
        return false;
    }

    public synchronized UUID newID() {
        long time = this.getTime();
        if (time != this.previousTime) {
            this.setPreviousTime(time);
            this.resetSequence();
            if (time < this.previousTime) {
                this.incrementClockID();
            }
        }
        int s = this.getSequence();
        long least = this.composeLeast(this.getClockID(), s);
        UUID result = new UUID(time, least);
        if (s < Integer.MAX_VALUE) {
            this.incrementSequence();
        } else {
            this.incrementClockID();
            this.resetSequence();
        }
        return result;
    }

    private long composeLeast(int clock, int sequence) {
        return this.composeLeast((long)clock << 32, sequence);
    }

    private long composeLeast(long clock, int sequence) {
        return clock | (long)sequence & 0xFFFFFFFFL;
    }

    public synchronized UUID[] newIDs(int amount) {
        this.prepareForBulkAllocation(amount);
        int start = this.getSequence();
        this.increaseSequenceBy(amount);
        UUID[] results = new UUID[amount];
        long clockid = this.getClockID();
        clockid <<= 32;
        long time = this.getPreviousTime();
        long least = 0L;
        for (int i = 0; i < amount; ++i) {
            least = this.composeLeast(clockid, start + i);
            results[i] = new UUID(time, least);
        }
        return results;
    }

    private void prepareForBulkAllocation(int amount) {
        if (amount <= 0) {
            throw new RuntimeException("Invalid sequence range!");
        }
        long time = this.getTime();
        if (time > this.previousTime) {
            this.setPreviousTime(time);
            this.resetSequence();
            return;
        }
        if (time == this.getPreviousTime() && this.hasSequencesLeft(amount)) {
            return;
        }
        this.incrementClockID();
        this.resetSequence();
    }

    public synchronized RIDSequence getIDSequence(int amount) {
        this.prepareForBulkAllocation(amount);
        int start = this.getSequence();
        this.increaseSequenceBy(amount);
        return new RIDSequence(this.getPreviousTime(), (long)this.getClockID(), start, amount);
    }
}

