package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.io.IOException;
import java.util.Set;
import java.util.Map;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.model.View;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.workflow.WorkflowTransition;
import org.eaglei.repository.model.workflow.WorkflowState;
import org.eaglei.repository.model.workflow.WorkflowAction;
import org.openrdf.model.URI;
import org.eaglei.repository.model.workflow.ErrorAction;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.status.ForbiddenException;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.Configuration;
import org.apache.commons.lang.StringEscapeUtils;

public final class editTransition_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    // render the WorkflowState chooser.  Only offer the "nothing" setting
    // when there is no value yet, e.g. when creating, since an existing
    // transition requires valeus here so we shouldn't have option to "clear" them
    private void makeStateSelector(HttpServletRequest request,  JspWriter out, String name, URI val)
        throws IOException, ServletException
    {
        out.append("<select name=\"").append(name).append("\" id=\"id_").append(name).append("\">\n");
        if (val == null)
            out.append("<option value=\"\"> --choose one-- </option>");
        for (WorkflowState s : WorkflowState.findAll(request)) {
            URI suri = s.getURI();
            out.append("<option ").append(suri.equals(val) ? "selected" : "")
               .append(" value=\"").append(suri.stringValue()).append("\">").append(s.getLabel()).append("</option>\n");
        }
        out.append("</select>\n");
    }


  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/repository/admin/../head.jsp");
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
      out.write("\n\n  <head>\n    ");
      out.write("\n\n\n<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n<style type=\"text/css\">\n BODY { background-color: ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.admin.backgroundColor", "lightyellow")) );
      out.write("; }\n .ei_required { color: red; }\n</style>\n");
      out.write("\n    <title>Eagle-I Data Repository Admin - Edit Workflow Transition</title>\n  </head>\n\n");

    try {
        request.setCharacterEncoding("UTF-8");
        // feedback message about status of any chosen operation
        String message = request.getParameter("message");
        boolean messageSuccess = true;
        boolean createp = request.getParameter("create") != null;

        // required-style - only turn on 'red' on when creating new Transition
        String reqStyle = createp ? "class=\"ei_required\"" : "";

        String verb = createp ? "Create" : "Edit";
        String submitAction = createp ? "create" : "update";
        URI uri = Utils.parseURI(request.getParameter("uri"), "uri", !createp);
        String label = "";
        String comment = "";
        String order = "";
        URI workspace = null;
        URI initialState = null;
        URI finalState = null;
        String action = null;
        String actionParameter = null;
        String actionErrorMsg = null;

        if (!createp) {
            WorkflowTransition r = WorkflowTransition.find(request, uri);
            label = r.getLabel();
            comment = r.getComment();
            workspace = r.getWorkspace();
            order = r.getOrder();
            initialState = r.getInitial();
            finalState = r.getFinal();
            WorkflowAction ao = r.getAction();
            if (r.isErrorAction()) {
                action = "";
                actionErrorMsg = ((ErrorAction)ao).getMessage();
            } else {
                action = ao == null ? "" : ao.getClass().getName();
            }
            Value ap = r.getActionParameter();
            actionParameter = ap == null ? "" : Utils.valueAsString(ap);
        }

      out.write("\n  <body>\n    ");
      out.write('\n');
      out.write("\n\n\n<hr/>\n  <table border=\"0\" width=\"100%\" >\n    <tr>\n      <td width=\"30%\">\n        <a href=\"/repository/admin/\">\n          <img border=\"0\" alt=\"Institutional Logo\" align=\"right\" src=\"");
      out.print( Configuration.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" />\n        </a>\n      </td>\n      <td width=\"70%\"><div align=\"center\">\n            <font size=\"+1\" color=\"black\">\n              ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)")) );
      out.write("</p>\n            </font>\n        </div>\n        <div align=\"center\" style=\"margin-top: 0.5em;\">Data Repository Administration</div>\n      </td>\n    </tr>\n  </table>\n<hr/>\n");
      out.write("\n    <h2 align=\"center\">");
      out.print( verb );
      out.write(" Workflow Transition</h2>\n");

    if (uri != null) {

      out.write("\n    <h3 align=\"center\"><tt>");
      out.print( StringEscapeUtils.escapeHtml(uri.stringValue()) );
      out.write("</tt></h3>\n");

    }
    if (message != null) {

      out.write("\n      <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n          ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("\n          </font>\n     </h3>\n");

    }

      out.write("\n\n    <form accept-charset=\"UTF-8\" method=\"POST\" action=\"/repository/admin/updateTransition\">\n      <input type=\"hidden\" name=\"action\" value=\"");
      out.print( submitAction );
      out.write("\"/>\n      <fieldset style=\"width: 80%; align: center;\">\n       <legend><b>Enter Transition Properties</b></legend>\n");

    if (createp) {

      out.write("\n       <input type=\"hidden\" name=\"create\" value=\"true\"/>\n       <i>Input fields labelled in <span class=\"ei_required\"><b>RED</b></span>  are <b>required.</b></i>\n       <br/>\n       <p><label for=\"id_uri\"><b>URI:</b> </label>\n       <input type=\"text\" id=\"id_uri\" name=\"uri\" size=\"50\" value=\"\"/>\n       <br><i>This is <b>optional</b>, only fill in if you want a specific URI for the Role.\n            It must not be used for any other object.</i>\n       </p>\n");

    } else {

      out.write("\n       <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute(uri.stringValue()) );
      out.write("\"/>\n");

    }

      out.write("\n       <p>\n        <label for=\"id_label\"><span ");
      out.print( reqStyle );
      out.write("><b>Label:</b> </span></label>\n        <input type=\"text\" id=\"id_label\" name=\"label\" size=\"50\" value=\"");
      out.print( Utils.escapeHTMLAttribute(label) );
      out.write("\"/>\n       </p>\n\n       <p>\n        <label for=\"id_comment\"><b>Description:</b></label>\n        <input type=\"text\" id=\"id_comment\" name=\"comment\" size=\"80\" value=\"");
      out.print( comment == null ? "" : Utils.escapeHTMLAttribute(comment) );
      out.write("\"/>\n       </p>\n\n       <p>\n        <label for=\"id_initial\"><span ");
      out.print( reqStyle );
      out.write("><b>Initial State:</b> </span></label>\n        ");
 makeStateSelector(request, out, "initial", initialState); 
      out.write("\n       </p>\n\n       <p>\n        <label for=\"id_final\"><span ");
      out.print( reqStyle );
      out.write("><b>Final State:</b> </span></label>\n        ");
 makeStateSelector(request, out, "final", finalState); 
      out.write("\n       </p>\n\n       <p>\n        <label for=\"id_workspace\"><b>Workspace:</b></label>\n        <select id=\"id_workspace\" name=\"workspace\">\n          <option selected value=\"\">-- applies to all workspaces --</option>\n");

    Set<Map.Entry<String,URI>> ws = View.getAllWorkspaceGraphs(request).entrySet();
    for (Map.Entry<String,URI> we : ws) {

      out.write("\n          <option value=\"");
      out.print( Utils.escapeHTMLAttribute(we.getValue().stringValue()) );
      out.write("\"\n            ");
      out.print( we.getValue().equals(workspace) ? "selected" : "" );
      out.write(">\n            ");
      out.print( StringEscapeUtils.escapeHtml(we.getKey()) );
      out.write(' ');
      out.write('(');
      out.print( StringEscapeUtils.escapeHtml(we.getValue().getLocalName()) );
      out.write(")\n          </option>\n");

    }

      out.write("\n        </select>\n       </p>\n\n       <p>\n        <label for=\"id_action\"><b>Action class:</b></label>\n        <input type=\"text\" id=\"id_action\" name=\"tAction\" size=\"80\" value=\"");
      out.print( action == null ? "" : Utils.escapeHTMLAttribute(action) );
      out.write("\"/>\n");

    if (actionErrorMsg != null) {

      out.write("\n        <br/><span style=\"color: red; font-size: 80%; font-style: italic;\">");
      out.print( actionErrorMsg );
      out.write("</span>\n");

    }

      out.write("\n        <br/><i>Must be fully-qualified Java class name of WorkflowAction implementation.</i>\n       </p>\n\n       <p>\n        <label for=\"id_actionParameter\"><b>Action Parameter:</b></label>\n        <input type=\"text\" id=\"id_actionParameter\" name=\"tActionParameter\" size=\"80\" value=\"");
      out.print( actionParameter == null ? "" : Utils.escapeHTMLAttribute(actionParameter) );
      out.write("\"/>\n        <br/><i>URI or literal value to pass to action as optional parameter.</i>\n       </p>\n\n       <p>\n        <label for=\"id_order\"><b>Order:</b></label>\n        <input type=\"text\" id=\"id_order\" name=\"order\" size=\"20\" value=\"");
      out.print( order == null ? "" : Utils.escapeHTMLAttribute(order) );
      out.write("\"/>\n        <br/><i>This is only used as sort key to determine ordering of Transitions in list view.</i>\n       </p>\n\n       <div width=\"50%\" align=\"left\">\n         <div width=\"50%\" align=\"center\">\n           <button type=\"reset\">Reset Form</button>\n           &nbsp;&nbsp;&nbsp;&nbsp;\n           <button name=\"submit\" value=\"submit\" type=\"submit\">Submit</button>\n         </div>\n       </div>\n      </fieldset>\n    </form>\n");

    // don't show or edit ACLs when creating, since no URI yet..
    if (!createp) {

      out.write("\n    <br/>\n    <table border=\"1\" width=\"30%\">\n      <caption align=\"top\"><b>Current Access Grants:</b></caption>\n      <tr><th>Agent</th><th>Delete</th></tr>\n");

    for (AccessGrant g : AccessGrant.getGrants(request, uri)) {
        if (Access.READ.getURI().equals(g.getAccessURI())) {

      out.write("\n      <tr>\n        <td>\n        ");
      out.print( StringEscapeUtils.escapeHtml(g.getAgentLabel()) );
      out.write("\n        [");
      out.print( StringEscapeUtils.escapeHtml(g.getAgentTypeLabel()) );
      out.write("]\n        </td>\n        <td>\n          <form  method=\"post\" action=\"/repository/admin/updateGrants\" style=\"margin: 0pt;\">\n           <input type=\"hidden\" name=\"lock_access\" value=\"");
      out.print( Utils.escapeHTMLAttribute(Access.READ.getURI().stringValue()) );
      out.write("\"/>\n           <input type=\"hidden\" name=\"type\" value=\"Workflow Transition\"/>\n           <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute(uri.stringValue()) );
      out.write("\"/>\n           <input type=\"hidden\" name=\"label\" value=\"");
      out.print( Utils.escapeHTMLAttribute(label) );
      out.write("\"/>\n           <input type=\"hidden\" name=\"action\" value=\"remove\"/>\n           <input type=\"hidden\" name=\"agent\" value=\"");
      out.print( Utils.escapeHTMLAttribute(g.getAgentURI().stringValue()) );
      out.write("\"/>\n           <input type=\"hidden\" name=\"access\" value=\"");
      out.print( Utils.escapeHTMLAttribute(g.getAccessURI().stringValue()) );
      out.write("\"/>\n           <button type=\"submit\">Delete!</button>\n          </form>\n        </td>\n      </tr>\n");

        }
    }

      out.write("\n    </table>\n    <br/>\n\n    <form  action=\"/repository/admin/editGrants.jsp\">\n      <fieldset style=\"width: 80%; align: center;\">\n       <legend><b>Change Access on Workflow Transition</b></legend>\n      <input type=\"hidden\" name=\"lock_access\" value=\"");
      out.print( Utils.escapeHTMLAttribute(Access.READ.getURI().stringValue()) );
      out.write("\"/>\n      <input type=\"hidden\" name=\"type\" value=\"Workflow Transition\" />\n      <input type=\"hidden\" name=\"label\" value=\"");
      out.print( Utils.escapeHTMLAttribute(label) );
      out.write("\"/>\n      <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute(uri.stringValue()) );
      out.write("\"/>\n      <button type=\"submit\">Edit ACL</button><i> (Leaves this page)</i>\n     </fieldset>\n    </form>\n");

    }

      out.write("\n    <p></p>\n    <p>\n    <a href=\"/repository/admin/transitions.jsp\">Return to list of Workflow Transitions</a>\n    </p>\n    <p>\n    <a href=\"/repository/admin/editTransition.jsp?create\">Create a New Workflow Transition</a>\n    </p>\n    <p>\n    <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n    </p>\n  </body>\n");

    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
