package org.eaglei.repository.servlet;

import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.BindingSet;
import org.openrdf.model.impl.URIImpl;

import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.rid.RIDGenerator;

/**
 * <p>New class.</p>
 *
 * @author lcs
 * @version $Id: $
 */
public class New extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(New.class);

    private static String columnNames[] = { "new" };

    /** {@inheritDoc} */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        request.setCharacterEncoding("UTF-8");
        String rawcount = getParameter(request, "count", false);
        String format = getParameter(request, "format", false);
        int count = 1;

        // sanity checks - count must be > 0 or defaulted to 1
        if (rawcount != null) {
            try {
                count = Integer.parseInt(rawcount);
            } catch (NumberFormatException e) {
                throw new BadRequestException("The 'count' argument was not an integer: "+count, e);
            }
        }
        if (count <= 0)
            throw new BadRequestException("The 'count' argument was not an integer greater than 0: "+count);

        log.debug("Got /new GET request, count="+count);
        UUID uuids[] = RIDGenerator.getInstance().newIDs(count);

        // XXX FIXME: need access check, ideally find a graph
        //  that this user can write, but maybe it's enough to just
        //  be an authenticated user?? (which is done by servlet container)

        ArrayList<BindingSet> results = new ArrayList<BindingSet>(uuids.length);
        for (UUID uuid : uuids) {
            MapBindingSet bs = new MapBindingSet(1);
            bs.addBinding(columnNames[0],
              new URIImpl(Configuration.getInstance().getDefaultNamespace() + uuid.toString()));
            results.add(bs);
        }
        SPARQL.sendTupleQueryResults(request, response, format, results);
    }
}
