/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.format;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

public class SPARQLTextWriter
implements TupleQueryResultWriter {
    public static final TupleQueryResultFormat FORMAT = new TupleQueryResultFormat("Tab-Separated Values", "text/plain", ".txt");
    private PrintStream out = null;
    private OutputStream outStream = null;
    private List<String> columns = null;

    public SPARQLTextWriter(OutputStream out) {
        this.outStream = out;
    }

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return FORMAT;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        try {
            this.out = new PrintStream(this.outStream, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
        this.columns = bindingNames;
        boolean first = true;
        for (String bn : bindingNames) {
            this.out.print(first ? bn : "\t" + bn);
            first = false;
        }
        this.out.println();
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
    }

    public void handleSolution(BindingSet bs) throws TupleQueryResultHandlerException {
        boolean first = true;
        for (String bn : this.columns) {
            if (!first) {
                this.out.print("\t");
            }
            if (bs.hasBinding(bn)) {
                Value bsv = bs.getValue(bn);
                this.out.print(bsv == null ? "" : bsv.toString());
            }
            first = false;
        }
        this.out.println();
    }
}

