/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.User;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Access {
    READ(REPO.HAS_READ_ACCESS),
    ADD(REPO.HAS_ADD_ACCESS),
    REMOVE(REPO.HAS_REMOVE_ACCESS),
    ADMIN(REPO.HAS_ADMIN_ACCESS);

    private URI uri = null;
    private static final Set<URI> valueURIs;
    private static final String hasPermissionQuery;
    public static final DatasetImpl ACCESS_DATASET;
    private static final Logger log;

    private Access(URI uri) {
        this.uri = uri;
    }

    public static boolean isAccessPredicate(URI uri) {
        return valueURIs.contains(uri);
    }

    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return this.name().toUpperCase();
    }

    public static boolean hasPermission(HttpServletRequest request, Resource subject, Access pred) {
        if (Authentication.isSuperuser((HttpServletRequest)request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Superuser elides check: hasPermission(" + subject + ", " + pred + ") => true"));
            }
            return true;
        }
        try {
            URI pu = Authentication.getPrincipalURI((HttpServletRequest)request);
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            BooleanQuery q = rc.prepareBooleanQuery(QueryLanguage.SPARQL, hasPermissionQuery);
            q.setIncludeInferred(true);
            q.setDataset((Dataset)ACCESS_DATASET);
            q.clearBindings();
            q.setBinding("user", (Value)pu);
            q.setBinding("access", (Value)pred.uri);
            q.setBinding("resource", (Value)subject);
            boolean result = q.evaluate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Access Query: user=" + pu + ", access=" + pred + ", query=\n" + hasPermissionQuery));
                log.debug((Object)("hasPermission(" + subject + ", " + pred + ", " + pu + ") => " + result));
            }
            return result;
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in access check: ", (Throwable)e);
        }
    }

    public static boolean hasPermissionOnUser(HttpServletRequest request, String username) {
        Principal p = request.getUserPrincipal();
        return Authentication.isSuperuser((HttpServletRequest)request) || username != null && p != null && username.equals(p.getName());
    }

    public static void filterByPermission(HttpServletRequest request, URI aprincipal, String name, String results, String patternGroup, Access pred, Dataset dataset, BindingSet bindings, TupleQueryResultHandler handler) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            URI principal = aprincipal == null ? Authentication.getPrincipalURI((HttpServletRequest)request) : aprincipal;
            String qs = Access.makeAccessQuery((String)name, (String)("SELECT " + results + " WHERE"), (String)patternGroup);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL query in filterByPermission, name=" + name + ", query=\n  " + qs));
            }
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
            q.setIncludeInferred(true);
            q.setDataset(dataset);
            q.clearBindings();
            q.setBinding("user", (Value)principal);
            q.setBinding("access", (Value)pred.uri);
            if (bindings != null && bindings.size() > 0) {
                for (Binding b : bindings) {
                    q.setBinding(b.getName(), b.getValue());
                }
            }
            q.evaluate(handler);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in access check: ", (Throwable)e);
        }
    }

    private static String makeAccessQuery(String resourceName, String prologue, String patternGroup) {
        StringBuilder result = new StringBuilder();
        result.append(prologue).append(" { ");
        if (patternGroup != null) {
            result.append(patternGroup);
        }
        result.append("{ { ?user <").append(REPO.HAS_ROLE).append("> ?r . ?").append(resourceName).append(" ?access ?r }\n");
        result.append(" UNION { ?").append(resourceName).append(" ?access ?user } } }");
        return result.toString();
    }

    static {
        valueURIs = new HashSet();
        for (Access a : Access.values()) {
            valueURIs.add(a.uri);
        }
        hasPermissionQuery = Access.makeAccessQuery((String)"resource", (String)"ASK", null);
        ACCESS_DATASET = SPARQL.copyDataset((Dataset)SPARQL.InternalGraphs);
        ACCESS_DATASET.addDefaultGraph(User.USER_GRAPH);
        log = LogManager.getLogger(Access.class);
    }
}

