/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public class AccessGrant {
    private static Logger log = LogManager.getLogger(Access.class);
    private static String importGrantQuery = null;
    private static final String getGrantsQueryPrefix = "SELECT DISTINCT * WHERE { \nGRAPH <" + REPO.NG_INTERNAL + "> { ?instance ?access ?agent } . \n" + "?access <" + RDFS.SUBPROPERTYOF + "> <" + REPO.HAS_ANY_ACCESS + "> \n" + "OPTIONAL { ?access <" + RDFS.LABEL + "> ?accessLabel }\n" + "OPTIONAL { ?agent <" + RDFS.LABEL + "> ?agentLabel }\n" + "OPTIONAL { {{?agent <" + RDF.TYPE + "> ?agentType} UNION {?agent <" + RDFS.SUBCLASSOF + "> ?agentType}}\n" + "  FILTER (?agentType = <" + REPO.ROLE + "> || ?agentType = <" + REPO.PERSON + ">) \n" + "  OPTIONAL { ?agentType <" + RDFS.LABEL + "> ?agentTypeLabel }}\n";
    private static final String getGrantsQuery = getGrantsQueryPrefix + "}";
    private static final String getMyGrantsQuery = getGrantsQueryPrefix + "{{?user <" + REPO.HAS_ROLE + "> ?agent} UNION {?instance ?access ?user}}}";
    private Term access = null;
    private Term agent = null;
    private Term agentType = null;

    private AccessGrant(URI agent, String agentLabel, URI agentType, String agentTypeLabel, URI access, String accessLabel) {
        this.agent = new Term(agent, agentLabel, null);
        this.agentType = new Term(agentType, agentTypeLabel, null);
        this.access = new Term(access, accessLabel, null);
    }

    public URI getAccessURI() {
        return this.access == null ? null : Term.access$100((Term)this.access);
    }

    public String getAccessLabel() {
        return this.access == null ? null : Term.access$200((Term)this.access);
    }

    public URI getAgentURI() {
        return this.agent == null ? null : Term.access$100((Term)this.agent);
    }

    public String getAgentLabel() {
        return this.agent == null ? null : Term.access$200((Term)this.agent);
    }

    public URI getAgentTypeURI() {
        return this.agentType == null ? null : Term.access$100((Term)this.agentType);
    }

    public String getAgentTypeLabel() {
        return this.agentType == null ? null : Term.access$200((Term)this.agentType);
    }

    public static boolean removeGrant(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (Access.hasPermission((HttpServletRequest)request, (Resource)instance, (Access)Access.ADMIN)) {
            return AccessGrant.removeGrantAsAdministrator((HttpServletRequest)request, (URI)instance, (URI)agent, (URI)access);
        }
        throw new ForbiddenException("You are not allowed to change access controls on " + instance);
    }

    public static boolean removeGrantAsAdministrator(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (instance == null || access == null || agent == null) {
            throw new BadRequestException("removeGrant called with an illegal null URI.");
        }
        if (Access.isAccessPredicate((URI)access)) {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            try {
                if (rc.hasStatement((Resource)instance, access, (Value)agent, false, new Resource[]{REPO.NG_INTERNAL})) {
                    rc.remove((Resource)instance, access, (Value)agent, new Resource[]{REPO.NG_INTERNAL});
                    return true;
                }
                return false;
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new InternalServerErrorException("Failed in remove ACL: ", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Access URI is not a valid access predicate: " + access.stringValue());
    }

    public static void addGrant(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (!Access.hasPermission((HttpServletRequest)request, (Resource)instance, (Access)Access.ADMIN)) {
            throw new ForbiddenException("You are not allowed to change access controls on " + instance);
        }
        AccessGrant.addGrantAsAdministrator((HttpServletRequest)request, (URI)instance, (URI)agent, (URI)access);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addGrantAsAdministrator(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (!Access.isAccessPredicate((URI)access)) throw new IllegalArgumentException("Access URI is not a valid access predicate: " + access.stringValue());
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            if (rc.hasStatement((Resource)instance, access, (Value)agent, false, new Resource[]{REPO.NG_INTERNAL})) return;
            rc.add((Resource)instance, access, (Value)agent, new Resource[]{REPO.NG_INTERNAL});
            return;
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in add ACL: ", (Throwable)e);
        }
    }

    public static Iterable<AccessGrant> getGrants(HttpServletRequest request, URI uri) {
        return AccessGrant.getGrantsInternal((HttpServletRequest)request, (RepositoryConnection)WithRepositoryConnection.get((ServletRequest)request), (URI)uri, (boolean)false);
    }

    public static Iterable<AccessGrant> getMyGrants(HttpServletRequest request, URI uri) {
        return AccessGrant.getGrantsInternal((HttpServletRequest)request, (RepositoryConnection)WithRepositoryConnection.get((ServletRequest)request), (URI)uri, (boolean)true);
    }

    private static Iterable<AccessGrant> getGrantsInternal(HttpServletRequest request, RepositoryConnection rc, URI uri, boolean mine) {
        try {
            String qs;
            String string = qs = mine ? getMyGrantsQuery : getGrantsQuery;
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL query to get " + (mine ? "MY (" + Authentication.getPrincipalURI((HttpServletRequest)request).stringValue() + ")" : "") + "grants, instance=" + uri.stringValue() + ", query=\n" + qs));
            }
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
            q.setBinding("instance", (Value)uri);
            if (mine) {
                if (request == null) {
                    throw new IllegalArgumentException("Cannot get grants for current user when request is null.");
                }
                q.setBinding("user", (Value)Authentication.getPrincipalURI((HttpServletRequest)request));
            }
            q.setDataset((Dataset)Access.ACCESS_DATASET);
            grantHandler h = new grantHandler();
            q.evaluate((TupleQueryResultHandler)h);
            return grantHandler.access$300((grantHandler)h);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in query: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public static Iterable<Statement> exportGrants(URI uri, Iterable<AccessGrant> grants) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (AccessGrant g : grants) {
            result.add((Statement)new ContextStatementImpl((Resource)uri, Term.access$100((Term)g.access), (Value)Term.access$100((Term)g.agent), (Resource)REPO.NG_INTERNAL));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<Statement> importGrants(HttpServletRequest request, RepositoryConnection content, URI oldURI, URI newURI) {
        try {
            if (importGrantQuery == null) {
                StringBuilder igq = new StringBuilder("SELECT ?p ?o WHERE {?s ?p ?o FILTER(");
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * WHERE { ?accessPred <" + RDFS.SUBPROPERTYOF + "> <" + REPO.HAS_ANY_ACCESS + ">}");
                q.setDataset((Dataset)Access.ACCESS_DATASET);
                TupleQueryResult qr = null;
                try {
                    qr = q.evaluate();
                    boolean first = true;
                    while (qr.hasNext()) {
                        String ap = Utils.valueAsString((Value)((BindingSet)qr.next()).getValue("accessPred"));
                        if (first) {
                            first = false;
                        } else {
                            igq.append(" || ");
                        }
                        igq.append("?p = <").append(ap).append(">");
                    }
                    igq.append(")}");
                    importGrantQuery = igq.toString();
                    log.debug((Object)("Generating fixed Access Import query: \"" + importGrantQuery + "\""));
                }
                finally {
                    if (qr != null) {
                        qr.close();
                    }
                }
            }
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, importGrantQuery);
            q.setDataset((Dataset)Access.ACCESS_DATASET);
            q.setBinding("s", (Value)oldURI);
            TupleQueryResult qr = null;
            ArrayList<Statement> result = new ArrayList<Statement>();
            try {
                qr = q.evaluate();
                while (qr.hasNext()) {
                    BindingSet bs = (BindingSet)qr.next();
                    result.add((Statement)new ContextStatementImpl((Resource)newURI, (URI)bs.getValue("p"), bs.getValue("o"), (Resource)REPO.NG_INTERNAL));
                }
            }
            finally {
                if (qr != null) {
                    qr.close();
                }
            }
            log.debug((Object)("importGrants(" + oldURI.stringValue() + "): returning " + result.size() + " grant statements."));
            return result;
        }
        catch (OpenRDFException e) {
            log.error((Object)"Failed in one of the Import Grant queries: ", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }
}

