/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.util.Utils;
import org.openrdf.model.URI;

public enum DataModel {
    GRAPH_URI("datamodel.graph.uri", URI.class),
    VERSION_INFO_URI("datamodel.versionInfo.uri", URI.class),
    VERSION_INFO_SOURCE("datamodel.versionInfo.source", String.class),
    HIDE_PROPERTY_PREDICATE("datamodel.hideProperty.predicate", URI.class),
    HIDE_PROPERTY_OBJECT("datamodel.hideProperty.object", URI.class),
    CONTACT_PROPERTY_PREDICATE("datamodel.contactProperty.predicate", URI.class),
    CONTACT_PROPERTY_OBJECT("datamodel.contactProperty.object", URI.class),
    EMBEDDED_INSTANCE_PREDICATE("datamodel.embedded.predicate", URI.class),
    EMBEDDED_INSTANCE_OBJECT("datamodel.embedded.object", URI.class),
    LABEL_PREDICATE("datamodel.label.predicate", URI.class),
    CONTACT_EMAIL_BINDINGS("datamodel.contact.email.bindings", String.class),
    CONTACT_EMAIL_QUERY("datamodel.contact.email.query", String.class);

    private static final Logger log;
    private static final String DEFAULT_DATAMODEL_SOURCE = "eaglei-datamodel.properties";
    private String configKey = null;
    private Class type = null;
    private Object result = null;
    private boolean initialized = false;
    private static org.apache.commons.configuration.Configuration dmConfig;

    private DataModel(String key, Class type) {
        this.configKey = key;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.commons.configuration.Configuration getConfiguration() {
        if (dmConfig == null) {
            String source = Configuration.getInstance().getConfigurationProperty("eaglei.repository.datamodel.source", DEFAULT_DATAMODEL_SOURCE);
            URL srcURL = DataModel.class.getClassLoader().getResource(source);
            try {
                if (srcURL == null) {
                    log.error((Object)("Cannot find Data Model Configuration resource, source=" + source));
                    log.error((Object)"This will be BAD, no data model is available.  DO NOT EXPECT ANYTHING TO WORK.");
                } else {
                    log.debug((Object)("Loading data model config from source=" + srcURL));
                    dmConfig = new PropertiesConfiguration(srcURL);
                }
            }
            catch (ConfigurationException e) {
                log.error((Object)("Failed loading Data Model configuration from URL=" + srcURL + ": "), (Throwable)e);
            }
            finally {
                if (dmConfig == null) {
                    dmConfig = new PropertiesConfiguration();
                }
            }
        }
        return dmConfig;
    }

    private void loadScalar() {
        if (!this.initialized) {
            String val = this.getConfiguration().getString(this.configKey);
            if (val == null) {
                throw new IllegalStateException("Missing data model configuration value for key: " + this.configKey);
            }
            if (this.type == URI.class) {
                this.result = Utils.parseURI((String)val, (String)this.configKey, (boolean)true);
            } else if (this.type == String.class) {
                this.result = val;
            } else {
                throw new IllegalStateException("Unrecognized type in data model config: " + this.type.getName());
            }
        }
    }

    private void loadArray() {
        if (!this.initialized) {
            if (!this.getConfiguration().containsKey(this.configKey)) {
                throw new IllegalStateException("Missing data model configuration value for key: " + this.configKey);
            }
            String[] val = this.getConfiguration().getStringArray(this.configKey);
            if (this.type == String.class) {
                this.result = val;
            } else if (this.type == URI.class) {
                URI[] aresult = new URI[val.length];
                for (int i = 0; i < val.length; ++i) {
                    aresult[i] = Utils.parseURI((String)val[i], (String)this.configKey, (boolean)true);
                }
                this.result = aresult;
            } else {
                throw new IllegalStateException("Unrecognized type in data model config: " + this.type.getName());
            }
        }
    }

    public URI getURI() {
        this.loadScalar();
        return (URI)this.result;
    }

    public String getString() {
        this.loadScalar();
        return (String)this.result;
    }

    public URI[] getArrayOfURI() {
        this.loadArray();
        return (URI[])this.result;
    }

    public String[] getArrayOfString() {
        this.loadArray();
        return (String[])this.result;
    }

    public String toString() {
        this.loadScalar();
        return this.result == null ? "null" : this.result.toString();
    }

    static {
        log = LogManager.getLogger(DataModel.class);
        dmConfig = null;
    }
}

