/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Lifecycle;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.CalendarLiteralImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class Provenance {
    private static Logger log = LogManager.getLogger(Provenance.class);
    public static final URI PROVENANCE_GRAPH = REPO.NG_METADATA;
    private static final Set<URI> predicates = new HashSet();
    private static DatasetImpl provDataset;
    private URI uri = null;
    private Map<URI, String> stmCache = null;
    private static final String provQuery;

    public Provenance(URI uri) {
        this.uri = uri;
    }

    public static boolean isProvenancePredicate(URI pp) {
        return predicates.contains(pp);
    }

    public void setCreated(HttpServletRequest request, Date when) {
        Literal lwhen = Provenance.makeDateTime((Date)when);
        this.setProvenanceInternal(request, DCTERMS.CREATOR, DCTERMS.CREATED, lwhen);
        this.setProvenanceInternal(request, DCTERMS.CONTRIBUTOR, DCTERMS.MODIFIED, lwhen);
        Lifecycle.getInstance().updateLastModified(when);
    }

    public void setMediated(HttpServletRequest request, Date when) {
        Literal lwhen = Provenance.makeDateTime((Date)when);
        this.setProvenanceInternal(request, DCTERMS.MEDIATOR, DCTERMS.CREATED, lwhen);
        this.setProvenanceInternal(request, DCTERMS.CONTRIBUTOR, DCTERMS.MODIFIED, lwhen);
        Lifecycle.getInstance().updateLastModified(when);
    }

    public void setModified(HttpServletRequest request, Date when) {
        this.setProvenanceInternal(request, DCTERMS.CONTRIBUTOR, DCTERMS.MODIFIED, Provenance.makeDateTime((Date)when));
        Lifecycle.getInstance().updateLastModified(when);
    }

    private void setProvenanceInternal(HttpServletRequest request, URI whoTerm, URI whenTerm, Literal when) {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        URI who = Authentication.getPrincipalURI((HttpServletRequest)request);
        this.setProvenanceStatement(rc, whoTerm, (Value)who);
        this.setProvenanceStatement(rc, whenTerm, (Value)when);
    }

    public void setProvenanceStatement(RepositoryConnection rc, URI term, Value value) {
        try {
            rc.remove((Resource)this.uri, term, null, new Resource[]{PROVENANCE_GRAPH});
            rc.add((Resource)this.uri, term, value, new Resource[]{PROVENANCE_GRAPH});
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting provenance: (" + this.uri + ", " + term + ", " + value + ")"));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
        this.decache();
    }

    public void setSource(HttpServletRequest request, String source, Date sourceModified) {
        if (source == null) {
            return;
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        this.setSourceStatements(rc, (Value)vf.createLiteral(source, XMLSchema.STRING), (Value)(sourceModified == null ? null : Provenance.makeDateTime((Date)sourceModified)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceStatements(RepositoryConnection rc, Value source, Value sourceModified) {
        if (source == null) {
            return;
        }
        try {
            if (rc.hasStatement((Resource)this.uri, DCTERMS.SOURCE, null, true, new Resource[]{PROVENANCE_GRAPH})) {
                RepositoryResult rr = rc.getStatements((Resource)this.uri, DCTERMS.SOURCE, null, true, new Resource[]{PROVENANCE_GRAPH});
                try {
                    while (rr.hasNext()) {
                        Statement s = (Statement)rr.next();
                        Value bn = s.getObject();
                        if (!(bn instanceof Resource)) continue;
                        rc.remove((Resource)bn, null, null, new Resource[]{PROVENANCE_GRAPH});
                    }
                }
                finally {
                    rr.close();
                }
                rc.remove((Resource)this.uri, DCTERMS.SOURCE, null, new Resource[]{PROVENANCE_GRAPH});
            }
            BNode bn = rc.getValueFactory().createBNode();
            rc.add((Resource)bn, DCTERMS.IDENTIFIER, source, new Resource[]{PROVENANCE_GRAPH});
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting provenance source: (" + this.uri + ", dcterms:source, " + bn + ")"));
                log.debug((Object)("Setting provenance source: (" + bn + ", dcterms:identifier, " + source + ")"));
            }
            if (sourceModified != null) {
                URI dt;
                URI uRI = dt = sourceModified instanceof Literal ? ((Literal)sourceModified).getDatatype() : null;
                if (dt != null && XMLDatatypeUtil.isCalendarDatatype((URI)dt)) {
                    rc.add((Resource)bn, DCTERMS.MODIFIED, sourceModified, new Resource[]{PROVENANCE_GRAPH});
                    log.debug((Object)("Setting provenance source: (" + bn + ", dcterms:modified, " + sourceModified + ")"));
                } else {
                    throw new IllegalArgumentException("The dcterms:modified provenance property requires a literal date/time value, this was not: " + sourceModified);
                }
            }
            rc.add((Resource)this.uri, DCTERMS.SOURCE, (Value)bn, new Resource[]{PROVENANCE_GRAPH});
            this.decache();
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static Literal makeDateTime(Date when) {
        try {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(when);
            return new CalendarLiteralImpl(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
        }
        catch (DatatypeConfigurationException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    private void decache() {
        this.stmCache = null;
    }

    private Map<URI, String> getStatementCache(HttpServletRequest request) {
        if (this.stmCache == null) {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            this.stmCache = new HashMap();
            try {
                log.debug((Object)("Provenance SPARQL query = " + provQuery));
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, provQuery);
                q.setBinding("subject", (Value)this.uri);
                q.setDataset(this.getProvDataset(request));
                q.setIncludeInferred(false);
                q.evaluate((TupleQueryResultHandler)new provenanceHandler(this.uri, this.stmCache));
            }
            catch (MalformedQueryException e) {
                log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
                throw new InternalServerErrorException((Throwable)e);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        return this.stmCache;
    }

    public String getField(HttpServletRequest request, URI field) {
        return (String)this.getStatementCache(request).get(field);
    }

    private Dataset getProvDataset(HttpServletRequest request) {
        if (provDataset == null) {
            provDataset = SPARQL.copyDataset((Dataset)SPARQL.getInternalAndMetadataGraphs((HttpServletRequest)request));
            SPARQL.addGraph((DatasetImpl)provDataset, (URI)REPO.NG_USERS);
        }
        return provDataset;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static {
        Collections.addAll(predicates, DCTERMS.CREATED, DCTERMS.CREATOR, DCTERMS.CONTRIBUTOR, DCTERMS.MODIFIED, DCTERMS.MEDIATOR, DCTERMS.SOURCE, DCTERMS.IDENTIFIER);
        provDataset = null;
        provQuery = "SELECT * WHERE { GRAPH <" + PROVENANCE_GRAPH + "> { \n" + "?subject ?dcterm ?dcvalue \n" + "OPTIONAL { GRAPH ?g {?dcvalue <" + RDFS.LABEL + "> ?dcvalueLabel}} \n" + "OPTIONAL { ?dcvalue ?dcsubterm ?dcsubvalue \n" + " OPTIONAL { GRAPH ?gg {?dcsubvalue <" + RDFS.LABEL + "> ?dcsubvalueLabel}}}}}";
    }
}

