/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Role;
import org.eaglei.repository.model.WritableObjectModel;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

/*
 * Exception performing whole class analysis ignored.
 */
@HasContentCache
public class Role
extends WritableObjectModel
implements Comparable {
    private static Logger log = LogManager.getLogger(Role.class);
    private URI uri;
    private String label = null;
    private String comment = null;
    private boolean implicit = false;
    private static volatile Map<URI, Role> cacheInternal = null;
    public static final String ROLE_QUERY = "SELECT DISTINCT ?uri ?label ?comment ?implicit WHERE {\n ?uri a <" + REPO.ROLE + "> ; <" + RDFS.LABEL + "> ?label .\n" + "  OPTIONAL { ?uri <" + REPO.IS_IMPLICIT + "> ?implicit }\n" + "  OPTIONAL { ?uri <" + RDFS.COMMENT + "> ?comment }}";

    private Role(URI uri, String label, String comment, boolean implicit) {
        this.uri = uri;
        this.label = label;
        this.comment = comment;
        this.implicit = implicit;
    }

    public static Role find(HttpServletRequest request, URI uri) throws ServletException {
        Map cache = Role.getCache((HttpServletRequest)request);
        if (cache.containsKey(uri)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("find(" + uri.stringValue() + ") => " + cache.get(uri)));
            }
            return (Role)cache.get(uri);
        }
        throw new NotFoundException("There is no Role of URI=" + uri);
    }

    public static List<Role> findAll(HttpServletRequest request) throws ServletException {
        Map cache = Role.getCache((HttpServletRequest)request);
        return new ArrayList<Role>(cache.values());
    }

    public static List<Role> findAllGrantable(HttpServletRequest request) throws ServletException {
        Map cache = Role.getCache((HttpServletRequest)request);
        ArrayList<Role> result = new ArrayList<Role>(cache.values());
        result.remove(Role.find((HttpServletRequest)request, (URI)REPO.ROLE_SUPERUSER));
        Collections.sort(result);
        return result;
    }

    public static List<Role> findAllUserRoles(HttpServletRequest request) throws ServletException {
        Map cache = Role.getCache((HttpServletRequest)request);
        ArrayList<Role> result = new ArrayList<Role>();
        for (Role r : cache.values()) {
            if (r.implicit) continue;
            result.add(r);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decache() {
        Class<Role> clazz = Role.class;
        synchronized (Role.class) {
            cacheInternal = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void decacheInstance() {
        Role.decache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<URI, Role> getCache(HttpServletRequest request) throws ServletException {
        Class<Role> clazz = Role.class;
        synchronized (Role.class) {
            if (cacheInternal != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return cacheInternal;
            }
            cacheInternal = new HashMap();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("All role SPARQL query = " + ROLE_QUERY));
                }
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, ROLE_QUERY);
                q.setDataset((Dataset)SPARQL.InternalGraphs);
                q.setIncludeInferred(true);
                q.evaluate((TupleQueryResultHandler)new allRoleHandler(cacheInternal));
            }
            catch (MalformedQueryException e) {
                log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
                throw new ServletException((Throwable)e);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            return cacheInternal;
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isSuperuser() {
        return this.uri.equals(REPO.ROLE_SUPERUSER);
    }

    public String getLabel() {
        return this.label;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object other) {
        return other instanceof Role && this.uri.equals(((Role)other).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "<#Role: uri=" + this.uri.toString() + ", label=" + this.label + ">";
    }

    public int compareTo(Object o) {
        return this.label.compareTo(((Role)o).label);
    }

    public boolean isBuiltin() {
        return this.implicit || REPO.ROLE_SUPERUSER.equals(this.uri);
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public static Role create(HttpServletRequest request, URI asubject, String label, String comment, boolean aimplicit) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to create a new Role.");
        }
        if (aimplicit) {
            throw new IllegalArgumentException("Cannot create() a Role with implicit = true.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            if (label == null || label.length() == 0) {
                throw new BadRequestException("Label is required when creating a new Role.");
            }
            URI subject = asubject;
            if (subject == null) {
                subject = vf.createURI(Configuration.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString());
            }
            rc.add((Resource)subject, RDF.TYPE, (Value)REPO.ROLE, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)subject, RDFS.LABEL, (Value)vf.createLiteral(label), new Resource[]{REPO.NG_INTERNAL});
            if (comment != null && comment.length() > 0) {
                rc.add((Resource)subject, RDFS.COMMENT, (Value)vf.createLiteral(comment), new Resource[]{REPO.NG_INTERNAL});
            }
            Role result = new Role(subject, label, comment, aimplicit);
            result.setDirty(true);
            Role.decache();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created Role uri=" + subject.stringValue() + ", label=" + label));
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void delete(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to delete a Role.");
        }
        if (this.isBuiltin()) {
            throw new ForbiddenException("Built-in Roles may not be deleted.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.uri, null, null, new Resource[]{REPO.NG_INTERNAL});
            this.setDirty(true);
            this.decacheInstance();
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setLabel(HttpServletRequest request, String label) throws ServletException {
        if (label == null || label.length() == 0) {
            throw new BadRequestException("Label must be a non-empty string.");
        }
        this.setMetadataInternal(request, RDFS.LABEL, label);
    }

    public void setComment(HttpServletRequest request, String newVal) throws ServletException {
        this.setMetadataInternal(request, RDFS.COMMENT, newVal);
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, String newVal) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to modify Roles.");
        }
        if (this.isBuiltin()) {
            throw new ForbiddenException("Builtin Roles may not be modified.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            rc.remove((Resource)this.uri, property, null, new Resource[]{REPO.NG_INTERNAL});
            if (newVal != null) {
                rc.add((Resource)this.uri, property, (Value)vf.createLiteral(newVal), new Resource[]{REPO.NG_INTERNAL});
                log.debug((Object)("Setting Role uri=" + this.uri + ", property=" + property + " to value=" + newVal));
            } else {
                log.debug((Object)("Clearing Role uri=" + this.uri + ", property=" + property));
            }
            this.setDirty(true);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

